/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.collections;

import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.activemq.artemis.core.PriorityAware;
import org.apache.activemq.artemis.utils.collections.PriorityCollection;
import org.apache.activemq.artemis.utils.collections.ResettableIterator;
import org.junit.Assert;
import org.junit.Test;

public class PriorityCollectionTest {
    @Test
    public void simpleInsertions() {
        PriorityCollection set = new PriorityCollection(CopyOnWriteArraySet::new);
        Assert.assertTrue((boolean)set.isEmpty());
        Assert.assertTrue((boolean)set.add((PriorityAware)new TestPriorityAware(1L)));
        Assert.assertFalse((boolean)set.isEmpty());
        Assert.assertTrue((boolean)set.add((PriorityAware)new TestPriorityAware(2L)));
        Assert.assertTrue((boolean)set.add((PriorityAware)new TestPriorityAware(3L)));
        Assert.assertEquals((long)set.size(), (long)3L);
        Assert.assertTrue((boolean)set.contains((PriorityAware)new TestPriorityAware(1L)));
        Assert.assertEquals((long)set.size(), (long)3L);
        Assert.assertTrue((boolean)set.remove((Object)new TestPriorityAware(1L)));
        Assert.assertEquals((long)set.size(), (long)2L);
        Assert.assertFalse((boolean)set.contains((PriorityAware)new TestPriorityAware(1L)));
        Assert.assertFalse((boolean)set.contains((PriorityAware)new TestPriorityAware(5L)));
        Assert.assertEquals((long)set.size(), (long)2L);
        Assert.assertTrue((boolean)set.add((PriorityAware)new TestPriorityAware(1L)));
        Assert.assertEquals((long)set.size(), (long)3L);
        Assert.assertFalse((boolean)set.add((PriorityAware)new TestPriorityAware(1L)));
        Assert.assertEquals((long)set.size(), (long)3L);
    }

    @Test
    public void testRemove() {
        PriorityCollection set = new PriorityCollection(CopyOnWriteArraySet::new);
        Assert.assertTrue((boolean)set.isEmpty());
        Assert.assertTrue((boolean)set.add((PriorityAware)new TestPriorityAware(1L)));
        Assert.assertFalse((boolean)set.isEmpty());
        Assert.assertFalse((boolean)set.remove((Object)new TestPriorityAware(0L)));
        Assert.assertFalse((boolean)set.isEmpty());
        Assert.assertTrue((boolean)set.remove((Object)new TestPriorityAware(1L)));
        Assert.assertTrue((boolean)set.isEmpty());
    }

    @Test
    public void concurrentInsertions() throws Throwable {
        PriorityCollection set = new PriorityCollection(CopyOnWriteArraySet::new);
        ExecutorService executor = Executors.newCachedThreadPool();
        int nThreads = 16;
        int N = 1000;
        ArrayList futures = new ArrayList();
        int i = 0;
        while (i < 16) {
            int n = i++;
            futures.add(executor.submit(() -> {
                ThreadLocalRandom random = ThreadLocalRandom.current();
                for (int j = 0; j < 1000; ++j) {
                    long key = random.nextLong(Long.MAX_VALUE);
                    key -= key % (long)(threadIdx + 1);
                    set.add((PriorityAware)new TestPriorityAware(key));
                }
            }));
        }
        for (Future future : futures) {
            future.get();
        }
        Assert.assertEquals((long)set.size(), (long)16000L);
        executor.shutdown();
    }

    @Test
    public void concurrentInsertionsAndReads() throws Throwable {
        PriorityCollection set = new PriorityCollection(CopyOnWriteArraySet::new);
        ExecutorService executor = Executors.newCachedThreadPool();
        int nThreads = 16;
        int N = 1000;
        ArrayList futures = new ArrayList();
        int i = 0;
        while (i < 16) {
            int n = i++;
            futures.add(executor.submit(() -> {
                ThreadLocalRandom random = ThreadLocalRandom.current();
                for (int j = 0; j < 1000; ++j) {
                    long key = random.nextLong(Long.MAX_VALUE);
                    key -= key % (long)(threadIdx + 1);
                    set.add((PriorityAware)new TestPriorityAware(key));
                }
            }));
            futures.add(executor.submit(() -> {
                ResettableIterator iterator = set.resettableIterator();
                while (iterator.hasNext()) {
                    iterator.next();
                }
            }));
        }
        for (Future future : futures) {
            future.get();
        }
        Assert.assertEquals((long)set.size(), (long)16000L);
        executor.shutdown();
    }

    @Test
    public void testIteration() {
        PriorityCollection set = new PriorityCollection(CopyOnWriteArraySet::new);
        Assert.assertFalse((boolean)set.iterator().hasNext());
        set.add((PriorityAware)new TestPriorityAware(0L));
        Assert.assertTrue((boolean)set.iterator().hasNext());
        set.remove((Object)new TestPriorityAware(0L));
        Assert.assertFalse((boolean)set.iterator().hasNext());
        set.add((PriorityAware)new TestPriorityAware(0L));
        set.add((PriorityAware)new TestPriorityAware(1L));
        set.add((PriorityAware)new TestPriorityAware(2L));
        ArrayList values = new ArrayList(set);
        Assert.assertTrue((boolean)values.contains(new TestPriorityAware(0L)));
        Assert.assertTrue((boolean)values.contains(new TestPriorityAware(1L)));
        Assert.assertTrue((boolean)values.contains(new TestPriorityAware(2L)));
        set.clear();
        Assert.assertTrue((boolean)set.isEmpty());
    }

    @Test
    public void priorityTest() {
        PriorityCollection set = new PriorityCollection(CopyOnWriteArraySet::new);
        set.add((PriorityAware)new TestPriority("A", 127));
        set.add((PriorityAware)new TestPriority("B", 127));
        set.add((PriorityAware)new TestPriority("E", 0));
        set.add((PriorityAware)new TestPriority("D", 20));
        set.add((PriorityAware)new TestPriority("C", 127));
        ResettableIterator iterator = set.resettableIterator();
        iterator.reset();
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)"A", (Object)((TestPriority)iterator.next()).getName());
        iterator.reset();
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)"B", (Object)((TestPriority)iterator.next()).getName());
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)"C", (Object)((TestPriority)iterator.next()).getName());
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)"A", (Object)((TestPriority)iterator.next()).getName());
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)"D", (Object)((TestPriority)iterator.next()).getName());
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)"E", (Object)((TestPriority)iterator.next()).getName());
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator.reset();
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)"B", (Object)((TestPriority)iterator.next()).getName());
    }

    private class TestPriority
    implements PriorityAware {
        private String name;
        private int priority;

        private TestPriority(String name, int priority) {
            this.name = name;
            this.priority = priority;
        }

        public int getPriority() {
            return this.priority;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestPriority that = (TestPriority)o;
            return this.priority == that.priority && Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.priority);
        }
    }

    private class TestPriorityAware
    implements PriorityAware {
        private long value;

        private TestPriorityAware(long value) {
            this.value = value;
        }

        public int getPriority() {
            return (int)this.value % 10;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestPriorityAware that = (TestPriorityAware)o;
            return this.value == that.value;
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }
}

