/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.collections;

import java.util.ArrayList;
import org.apache.activemq.artemis.utils.collections.ArrayResettableIterator;
import org.apache.activemq.artemis.utils.collections.UpdatableIterator;
import org.junit.Assert;
import org.junit.Test;

public class UpdatableIteratorTest {
    @Test
    public void testUnderlyingIterator() {
        int i;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i2 = 0; i2 < 1000; ++i2) {
            arrayList.add(i2);
        }
        UpdatableIterator iterator = new UpdatableIterator(ArrayResettableIterator.iterator(arrayList));
        for (i = 0; i < 1000; ++i) {
            Assert.assertTrue((boolean)iterator.hasNext());
            Assert.assertEquals((Object)i, (Object)iterator.next());
        }
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator.reset();
        for (i = 0; i < 1000; ++i) {
            Assert.assertTrue((boolean)iterator.hasNext());
            Assert.assertEquals((Object)i, (Object)iterator.next());
        }
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testUpdateIterator() {
        int i;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i2 = 0; i2 < 1000; ++i2) {
            arrayList.add(i2);
        }
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (int i3 = 4000; i3 < 5000; ++i3) {
            arrayList2.add(i3);
        }
        UpdatableIterator iterator = new UpdatableIterator(ArrayResettableIterator.iterator(arrayList));
        for (i = 0; i < 100; ++i) {
            Assert.assertTrue((boolean)iterator.hasNext());
            Assert.assertEquals((Object)i, (Object)iterator.next());
        }
        iterator.update(ArrayResettableIterator.iterator(arrayList2));
        for (i = 100; i < 1000; ++i) {
            Assert.assertTrue((boolean)iterator.hasNext());
            Assert.assertEquals((Object)i, (Object)iterator.next());
        }
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator.reset();
        for (i = 4000; i < 5000; ++i) {
            Assert.assertTrue((boolean)iterator.hasNext());
            Assert.assertEquals((Object)i, (Object)iterator.next());
        }
        Assert.assertFalse((boolean)iterator.hasNext());
    }
}

