/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.critical;

import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import org.apache.activemq.artemis.utils.ReusableLatch;
import org.apache.activemq.artemis.utils.Wait;
import org.apache.activemq.artemis.utils.critical.CriticalCloseable;
import org.apache.activemq.artemis.utils.critical.CriticalMeasure;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.Test;

public class MultiThreadCriticalMeasureTest {
    private static final Logger logger = Logger.getLogger(MultiThreadCriticalMeasureTest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiThread() throws Throwable {
        int THREADS = 20;
        ExecutorService executorService = Executors.newFixedThreadPool(THREADS);
        AtomicInteger errors = new AtomicInteger(0);
        AtomicBoolean running = new AtomicBoolean(true);
        AtomicBoolean load = new AtomicBoolean(true);
        ReusableLatch latchOnMeasure = new ReusableLatch(0);
        try {
            int i;
            CriticalMeasure measure = new CriticalMeasure(null, 0);
            CyclicBarrier barrier = new CyclicBarrier(THREADS + 1);
            Runnable runnable = () -> {
                try {
                    logger.debug((Object)("Thread " + Thread.currentThread().getName() + " waiting to Start"));
                    barrier.await();
                    logger.debug((Object)("Thread " + Thread.currentThread().getName() + " Started"));
                    while (running.get()) {
                        if (!load.get()) {
                            barrier.await();
                            barrier.await();
                        }
                        CriticalCloseable closeable = measure.measure();
                        try {
                            latchOnMeasure.await();
                        }
                        finally {
                            if (closeable == null) continue;
                            closeable.close();
                        }
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    errors.incrementAndGet();
                }
            };
            for (i = 0; i < THREADS; ++i) {
                executorService.execute(runnable);
            }
            logger.debug((Object)"Going to release it now");
            barrier.await();
            for (i = 0; i < 5; ++i) {
                LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(10L));
                load.set(false);
                barrier.await(10L, TimeUnit.SECONDS);
                LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(20L));
                Assert.assertFalse((boolean)measure.checkExpiration(TimeUnit.MILLISECONDS.toNanos(10L), false));
                logger.debug((Object)"Count down");
                load.set(true);
                barrier.await(10L, TimeUnit.SECONDS);
            }
            latchOnMeasure.countUp();
            Assert.assertTrue((boolean)Wait.waitFor(() -> measure.checkExpiration(TimeUnit.MILLISECONDS.toNanos(100L), false), 1000L, 1L));
        }
        finally {
            load.set(true);
            running.set(false);
            latchOnMeasure.countDown();
            Assert.assertEquals((long)0L, (long)errors.get());
            executorService.shutdown();
            Wait.assertTrue(executorService::isShutdown);
            Wait.assertTrue(executorService::isTerminated, 5000L, 1L);
        }
    }
}

