/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.jboss.logging.Logger;
import org.junit.rules.ExternalResource;

public class CleanupSystemPropertiesRule
extends ExternalResource {
    private static Logger log = Logger.getLogger(CleanupSystemPropertiesRule.class);
    private Properties originalProperties;

    protected void before() throws Throwable {
        this.originalProperties = new Properties();
        this.originalProperties.putAll((Map<?, ?>)System.getProperties());
    }

    protected void after() {
        Properties changed = new Properties();
        HashSet<Object> newProperties = new HashSet<Object>();
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            Object object = this.originalProperties.get(entry.getKey());
            if (object == null) {
                newProperties.add(entry.getKey());
                continue;
            }
            if (object.equals(entry.getValue())) continue;
            changed.put(entry.getKey(), object);
        }
        for (Map.Entry<Object, Object> entry : this.originalProperties.entrySet()) {
            if (System.getProperty((String)entry.getKey()) != null) continue;
            System.out.println("======================================================================================================");
            System.out.println("Reinstating property " + entry.getKey() + "=" + entry.getValue());
            System.setProperty((String)entry.getKey(), (String)entry.getValue());
            System.out.println("======================================================================================================");
        }
        if (!newProperties.isEmpty() || !changed.isEmpty()) {
            System.out.println("======================================================================================================");
            if (!newProperties.isEmpty()) {
                System.out.println("Clearing system property...");
                int i = 1;
                for (Object e : newProperties) {
                    System.out.printf("\t%3d. %s = %s%n", i++, e, System.getProperty(e.toString()));
                    System.clearProperty(e.toString());
                }
            }
            if (!changed.isEmpty()) {
                System.out.println("Resetting system property...");
                int i = 1;
                for (Map.Entry entry : changed.entrySet()) {
                    System.out.printf("\t%3d. %s = %s (was %s)%n", i++, entry.getKey(), entry.getValue(), System.getProperty(entry.getKey().toString()));
                    System.setProperty(entry.getKey().toString(), entry.getValue().toString());
                }
            }
            System.out.println("======================================================================================================");
        }
        this.originalProperties.clear();
        this.originalProperties = null;
    }
}

