/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;

public class ExecuteUtil {
    private static final Logger logger = Logger.getLogger(ExecuteUtil.class);

    public static int runCommand(boolean logOutput, String ... command) throws Exception {
        return ExecuteUtil.runCommand(logOutput, 10L, TimeUnit.SECONDS, command);
    }

    public static int runCommand(boolean logOutput, long timeout, TimeUnit timeoutUnit, String ... command) throws Exception {
        ProcessHolder processHolder = ExecuteUtil.run(logOutput, command);
        return processHolder.waitFor(timeout, timeoutUnit);
    }

    public static ProcessHolder run(final boolean logOutput, String ... command) throws IOException {
        ExecuteUtil.logCommand(command);
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        final ProcessHolder processHolder = new ProcessHolder();
        processHolder.process = processBuilder.start();
        processHolder.inputStreamReader = new Thread(){

            @Override
            public void run() {
                try {
                    ExecuteUtil.readStream(processHolder.process.getInputStream(), true, logOutput);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        processHolder.errorStreamReader = new Thread(){

            @Override
            public void run() {
                try {
                    ExecuteUtil.readStream(processHolder.process.getErrorStream(), true, logOutput);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        processHolder.errorStreamReader.start();
        processHolder.inputStreamReader.start();
        return processHolder;
    }

    private static void logCommand(String[] command) {
        StringBuffer logCommand = new StringBuffer();
        for (String c : command) {
            logCommand.append(c + " ");
        }
        System.out.println("command::" + logCommand.toString());
    }

    private static void readStream(InputStream stream, boolean error, boolean logOutput) throws IOException {
        String inputLine;
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        while ((inputLine = reader.readLine()) != null) {
            if (logOutput) {
                System.out.println(inputLine);
                continue;
            }
            if (error) {
                logger.warn((Object)inputLine);
                continue;
            }
            logger.trace((Object)inputLine);
        }
        reader.close();
    }

    public static class ProcessHolder {
        Thread inputStreamReader;
        Thread errorStreamReader;
        Process process;

        public void kill() throws InterruptedException {
            this.process.destroy();
            this.errorStreamReader.join();
            this.inputStreamReader.join();
        }

        public long pid() throws Exception {
            return this.process.pid();
        }

        public int waitFor(long timeout, TimeUnit unit) throws InterruptedException {
            if (!this.process.waitFor(timeout, unit)) {
                logger.warn((Object)"could not complete execution in time");
                return -1;
            }
            this.errorStreamReader.join();
            this.inputStreamReader.join();
            return this.process.exitValue();
        }

        public int waitFor() throws InterruptedException {
            this.process.waitFor();
            this.errorStreamReader.join();
            this.inputStreamReader.join();
            return this.process.exitValue();
        }
    }
}

