/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import org.apache.activemq.artemis.utils.RetryMethod;
import org.jboss.logging.Logger;
import org.junit.internal.AssumptionViolatedException;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class RetryRule
implements MethodRule {
    public static final String PROPERTY_NAME = "org.apache.activemq.artemis.utils.RetryRule.retry";
    private static Logger logger = Logger.getLogger(RetryRule.class);
    final int defaultNumberOfRetries;
    final boolean retrySuccess;

    public RetryRule() {
        this(0);
    }

    public RetryRule(int defaultNumberOfRetries) {
        this.defaultNumberOfRetries = defaultNumberOfRetries;
        this.retrySuccess = false;
    }

    public RetryRule(int defaultNumberOfRetries, boolean retrySuccess) {
        this.defaultNumberOfRetries = defaultNumberOfRetries;
        this.retrySuccess = retrySuccess;
    }

    private int getNumberOfRetries(FrameworkMethod method) {
        if (!Boolean.parseBoolean(System.getProperty(PROPERTY_NAME))) {
            return 0;
        }
        RetryMethod retry = (RetryMethod)method.getAnnotation(RetryMethod.class);
        if (retry != null) {
            return retry.retries();
        }
        return this.defaultNumberOfRetries;
    }

    public Statement apply(Statement base, FrameworkMethod method, Object target) {
        if (this.retrySuccess) {
            return this.retrySuccess(base, method, target);
        }
        return this.retryIfFailed(base, method, target);
    }

    protected Statement retrySuccess(final Statement base, final FrameworkMethod method, Object target) {
        return new Statement(){

            public void evaluate() throws Throwable {
                int retries = RetryRule.this.getNumberOfRetries(method) + 1;
                for (int i = 0; i < retries; ++i) {
                    logger.warn((Object)("LOOP " + i));
                    base.evaluate();
                }
            }
        };
    }

    protected Statement retryIfFailed(final Statement base, final FrameworkMethod method, final Object target) {
        return new Statement(){

            public void evaluate() throws Throwable {
                block6: {
                    Throwable currentException = null;
                    try {
                        base.evaluate();
                    }
                    catch (Throwable t) {
                        if (t instanceof AssumptionViolatedException) {
                            throw t;
                        }
                        currentException = t;
                        int retries = RetryRule.this.getNumberOfRetries(method);
                        for (int retryNr = 0; retryNr < retries; ++retryNr) {
                            logger.warn((Object)("RETRY " + (retryNr + 1) + " of " + retries + " on " + target.getClass() + "::" + method.getName()), currentException);
                            currentException = null;
                            try {
                                base.evaluate();
                                logger.warn((Object)("RETRY " + (retryNr + 1) + " of " + retries + " on " + target.getClass() + "::" + method.getName() + " succeeded"));
                                break;
                            }
                            catch (Throwable t2) {
                                logger.warn((Object)("RETRY " + (retryNr + 1) + " of " + retries + " on " + target.getClass() + "::" + method.getName() + " failed "), t2);
                                currentException = t2;
                                continue;
                            }
                        }
                        if (currentException == null) break block6;
                        throw currentException;
                    }
                }
            }
        };
    }
}

