/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.collections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.LongFunction;
import org.apache.activemq.artemis.utils.collections.ConcurrentLongHashMap;
import org.junit.Assert;
import org.junit.Test;

public class ConcurrentLongHashMapTest {
    int Iterations = 1;
    int ReadIterations = 100;
    int N = 1000000;

    @Test
    public void simpleInsertions() {
        ConcurrentLongHashMap map = new ConcurrentLongHashMap(16);
        Assert.assertTrue((boolean)map.isEmpty());
        Assert.assertNull((Object)map.put(1L, (Object)"one"));
        Assert.assertFalse((boolean)map.isEmpty());
        Assert.assertNull((Object)map.put(2L, (Object)"two"));
        Assert.assertNull((Object)map.put(3L, (Object)"three"));
        Assert.assertEquals((long)map.size(), (long)3L);
        Assert.assertEquals((Object)map.get(1L), (Object)"one");
        Assert.assertEquals((long)map.size(), (long)3L);
        Assert.assertEquals((Object)map.remove(1L), (Object)"one");
        Assert.assertEquals((long)map.size(), (long)2L);
        Assert.assertEquals((Object)map.get(1L), null);
        Assert.assertEquals((Object)map.get(5L), null);
        Assert.assertEquals((long)map.size(), (long)2L);
        Assert.assertNull((Object)map.put(1L, (Object)"one"));
        Assert.assertEquals((long)map.size(), (long)3L);
        Assert.assertEquals((Object)map.put(1L, (Object)"uno"), (Object)"one");
        Assert.assertEquals((long)map.size(), (long)3L);
    }

    @Test
    public void testRemove() {
        ConcurrentLongHashMap map = new ConcurrentLongHashMap();
        Assert.assertTrue((boolean)map.isEmpty());
        Assert.assertNull((Object)map.put(1L, (Object)"one"));
        Assert.assertFalse((boolean)map.isEmpty());
        Assert.assertFalse((boolean)map.remove(0L, (Object)"zero"));
        Assert.assertFalse((boolean)map.remove(1L, (Object)"uno"));
        Assert.assertFalse((boolean)map.isEmpty());
        Assert.assertTrue((boolean)map.remove(1L, (Object)"one"));
        Assert.assertTrue((boolean)map.isEmpty());
    }

    @Test
    public void testNegativeUsedBucketCount() {
        ConcurrentLongHashMap map = new ConcurrentLongHashMap(16, 1);
        map.put(0L, (Object)"zero");
        Assert.assertEquals((long)1L, (long)map.getUsedBucketCount());
        map.put(0L, (Object)"zero1");
        Assert.assertEquals((long)1L, (long)map.getUsedBucketCount());
        map.remove(0L);
        Assert.assertEquals((long)0L, (long)map.getUsedBucketCount());
        map.remove(0L);
        Assert.assertEquals((long)0L, (long)map.getUsedBucketCount());
    }

    @Test
    public void testRehashing() {
        int n = 16;
        ConcurrentLongHashMap map = new ConcurrentLongHashMap(n / 2, 1);
        Assert.assertEquals((long)map.capacity(), (long)n);
        Assert.assertEquals((long)map.size(), (long)0L);
        for (int i = 0; i < n; ++i) {
            map.put((long)i, (Object)i);
        }
        Assert.assertEquals((long)map.capacity(), (long)(2 * n));
        Assert.assertEquals((long)map.size(), (long)n);
    }

    @Test
    public void testRehashingWithDeletes() {
        int i;
        int n = 16;
        ConcurrentLongHashMap map = new ConcurrentLongHashMap(n / 2, 1);
        Assert.assertEquals((long)map.capacity(), (long)n);
        Assert.assertEquals((long)map.size(), (long)0L);
        for (i = 0; i < n / 2; ++i) {
            map.put((long)i, (Object)i);
        }
        for (i = 0; i < n / 2; ++i) {
            map.remove((long)i);
        }
        for (i = n; i < 2 * n; ++i) {
            map.put((long)i, (Object)i);
        }
        Assert.assertEquals((long)map.capacity(), (long)(2 * n));
        Assert.assertEquals((long)map.size(), (long)n);
    }

    @Test
    public void concurrentInsertions() throws Throwable {
        ConcurrentLongHashMap map = new ConcurrentLongHashMap();
        ExecutorService executor = Executors.newCachedThreadPool();
        int nThreads = 16;
        int N = 100000;
        String value = "value";
        ArrayList futures = new ArrayList();
        int i = 0;
        while (i < 16) {
            int n = i++;
            futures.add(executor.submit(() -> {
                Random random = new Random();
                for (int j = 0; j < 100000; ++j) {
                    long key = random.nextLong();
                    key -= key % (long)(threadIdx + 1);
                    map.put(key, (Object)value);
                }
            }));
        }
        for (Future future : futures) {
            future.get();
        }
        Assert.assertEquals((long)map.size(), (long)1600000L);
        executor.shutdown();
    }

    @Test
    public void concurrentInsertionsAndReads() throws Throwable {
        ConcurrentLongHashMap map = new ConcurrentLongHashMap();
        ExecutorService executor = Executors.newCachedThreadPool();
        int nThreads = 16;
        int N = 100000;
        String value = "value";
        ArrayList futures = new ArrayList();
        int i = 0;
        while (i < 16) {
            int n = i++;
            futures.add(executor.submit(() -> {
                Random random = new Random();
                for (int j = 0; j < 100000; ++j) {
                    long key = random.nextLong();
                    key -= key % (long)(threadIdx + 1);
                    map.put(key, (Object)value);
                }
            }));
        }
        for (Future future : futures) {
            future.get();
        }
        Assert.assertEquals((long)map.size(), (long)1600000L);
        executor.shutdown();
    }

    @Test
    public void testIteration() {
        ConcurrentLongHashMap map = new ConcurrentLongHashMap();
        Assert.assertEquals((Object)map.keys(), Collections.emptyList());
        Assert.assertEquals((Object)map.values(), Collections.emptyList());
        map.put(0L, (Object)"zero");
        Assert.assertEquals((Object)map.keys(), Arrays.asList(0L));
        Assert.assertEquals((Object)map.values(), Arrays.asList("zero"));
        map.remove(0L);
        Assert.assertEquals((Object)map.keys(), Collections.emptyList());
        Assert.assertEquals((Object)map.values(), Collections.emptyList());
        map.put(0L, (Object)"zero");
        map.put(1L, (Object)"one");
        map.put(2L, (Object)"two");
        List keys = map.keys();
        Collections.sort(keys);
        Assert.assertEquals((Object)keys, Arrays.asList(0L, 1L, 2L));
        List values = map.values();
        Collections.sort(values);
        Assert.assertEquals((Object)values, Arrays.asList("one", "two", "zero"));
        map.put(1L, (Object)"uno");
        keys = map.keys();
        Collections.sort(keys);
        Assert.assertEquals((Object)keys, Arrays.asList(0L, 1L, 2L));
        values = map.values();
        Collections.sort(values);
        Assert.assertEquals((Object)values, Arrays.asList("two", "uno", "zero"));
        map.clear();
        Assert.assertTrue((boolean)map.isEmpty());
    }

    @Test
    public void testHashConflictWithDeletion() {
        int Buckets = 16;
        ConcurrentLongHashMap map = new ConcurrentLongHashMap(16, 1);
        long key1 = 1L;
        long key2 = 27L;
        int bucket1 = ConcurrentLongHashMap.signSafeMod((long)ConcurrentLongHashMap.hash((long)key1), (int)16);
        int bucket2 = ConcurrentLongHashMap.signSafeMod((long)ConcurrentLongHashMap.hash((long)key2), (int)16);
        Assert.assertEquals((long)bucket1, (long)bucket2);
        Assert.assertEquals((Object)map.put(key1, (Object)"value-1"), null);
        Assert.assertEquals((Object)map.put(key2, (Object)"value-2"), null);
        Assert.assertEquals((long)map.size(), (long)2L);
        Assert.assertEquals((Object)map.remove(key1), (Object)"value-1");
        Assert.assertEquals((long)map.size(), (long)1L);
        Assert.assertEquals((Object)map.put(key1, (Object)"value-1-overwrite"), null);
        Assert.assertEquals((long)map.size(), (long)2L);
        Assert.assertEquals((Object)map.remove(key1), (Object)"value-1-overwrite");
        Assert.assertEquals((long)map.size(), (long)1L);
        Assert.assertEquals((Object)map.put(key2, (Object)"value-2-overwrite"), (Object)"value-2");
        Assert.assertEquals((Object)map.get(key2), (Object)"value-2-overwrite");
        Assert.assertEquals((long)map.size(), (long)1L);
        Assert.assertEquals((Object)map.remove(key2), (Object)"value-2-overwrite");
        Assert.assertTrue((boolean)map.isEmpty());
    }

    @Test
    public void testPutIfAbsent() {
        ConcurrentLongHashMap map = new ConcurrentLongHashMap();
        Assert.assertEquals((Object)map.putIfAbsent(1L, (Object)"one"), null);
        Assert.assertEquals((Object)map.get(1L), (Object)"one");
        Assert.assertEquals((Object)map.putIfAbsent(1L, (Object)"uno"), (Object)"one");
        Assert.assertEquals((Object)map.get(1L), (Object)"one");
    }

    @Test
    public void testComputeIfAbsent() {
        ConcurrentLongHashMap map = new ConcurrentLongHashMap(16, 1);
        AtomicInteger counter = new AtomicInteger();
        LongFunction<Integer> provider = key -> counter.getAndIncrement();
        Assert.assertEquals((long)((Integer)map.computeIfAbsent(0L, provider)).intValue(), (long)0L);
        Assert.assertEquals((long)((Integer)map.get(0L)).intValue(), (long)0L);
        Assert.assertEquals((long)((Integer)map.computeIfAbsent(1L, provider)).intValue(), (long)1L);
        Assert.assertEquals((long)((Integer)map.get(1L)).intValue(), (long)1L);
        Assert.assertEquals((long)((Integer)map.computeIfAbsent(1L, provider)).intValue(), (long)1L);
        Assert.assertEquals((long)((Integer)map.get(1L)).intValue(), (long)1L);
        Assert.assertEquals((long)((Integer)map.computeIfAbsent(2L, provider)).intValue(), (long)2L);
        Assert.assertEquals((long)((Integer)map.get(2L)).intValue(), (long)2L);
    }

    public void benchConcurrentLongHashMap() throws Exception {
        ConcurrentLongHashMap map = new ConcurrentLongHashMap(this.N, 1);
        for (long i = 0L; i < (long)this.Iterations; ++i) {
            int j;
            for (j = 0; j < this.N; ++j) {
                map.put(i, (Object)"value");
            }
            for (long h = 0L; h < (long)this.ReadIterations; ++h) {
                for (int j2 = 0; j2 < this.N; ++j2) {
                    map.get(i);
                }
            }
            for (j = 0; j < this.N; ++j) {
                map.remove(i);
            }
        }
    }

    public void benchConcurrentHashMap() throws Exception {
        ConcurrentHashMap<Long, String> map = new ConcurrentHashMap<Long, String>(this.N, 0.66f, 1);
        for (long i = 0L; i < (long)this.Iterations; ++i) {
            int j;
            for (j = 0; j < this.N; ++j) {
                map.put(i, "value");
            }
            for (long h = 0L; h < (long)this.ReadIterations; ++h) {
                for (int j2 = 0; j2 < this.N; ++j2) {
                    map.get(i);
                }
            }
            for (j = 0; j < this.N; ++j) {
                map.remove(i);
            }
        }
    }

    void benchHashMap() throws Exception {
        HashMap<Long, String> map = new HashMap<Long, String>(this.N, 0.66f);
        for (long i = 0L; i < (long)this.Iterations; ++i) {
            int j;
            for (j = 0; j < this.N; ++j) {
                map.put(i, "value");
            }
            for (long h = 0L; h < (long)this.ReadIterations; ++h) {
                for (int j2 = 0; j2 < this.N; ++j2) {
                    map.get(i);
                }
            }
            for (j = 0; j < this.N; ++j) {
                map.remove(i);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        ConcurrentLongHashMapTest t = new ConcurrentLongHashMapTest();
        long start = System.nanoTime();
        long end = System.nanoTime();
        System.out.println("HM:   " + TimeUnit.NANOSECONDS.toMillis(end - start) + " ms");
        start = System.nanoTime();
        t.benchConcurrentHashMap();
        end = System.nanoTime();
        System.out.println("CHM:  " + TimeUnit.NANOSECONDS.toMillis(end - start) + " ms");
        start = System.nanoTime();
        end = System.nanoTime();
        System.out.println("CLHM: " + TimeUnit.NANOSECONDS.toMillis(end - start) + " ms");
    }
}

