/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.dto;

import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.activemq.artemis.dto.AppDTO;
import org.apache.activemq.artemis.dto.BindingDTO;
import org.apache.activemq.artemis.dto.ComponentDTO;
import org.apache.activemq.artemis.dto.RequestLogDTO;

@XmlRootElement(name="web")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class WebServerDTO
extends ComponentDTO {
    @Deprecated
    @XmlAttribute
    public String bind;
    @XmlAttribute(required=true)
    public String path;
    @Deprecated
    @XmlAttribute
    public Boolean clientAuth;
    @Deprecated
    @XmlAttribute
    public String passwordCodec;
    @Deprecated
    @XmlAttribute
    public String keyStorePath;
    @Deprecated
    @XmlAttribute
    public String trustStorePath;
    @XmlAttribute
    public String customizer;
    @XmlElementRef
    private List<BindingDTO> bindings;
    @Deprecated
    @XmlElementRef
    public List<AppDTO> apps;
    @XmlElementRef(required=false)
    public RequestLogDTO requestLog;
    @Deprecated
    @XmlAttribute
    private String keyStorePassword;
    @Deprecated
    @XmlAttribute
    private String trustStorePassword;
    @Deprecated
    @XmlAttribute
    private String includedTLSProtocols;
    @Deprecated
    @XmlAttribute
    private String excludedTLSProtocols;
    @Deprecated
    @XmlAttribute
    private String includedCipherSuites;
    @Deprecated
    @XmlAttribute
    private String excludedCipherSuites;

    public WebServerDTO() {
        this.componentClassName = "org.apache.activemq.artemis.component.WebServerComponent";
    }

    public List<BindingDTO> getBindings() {
        if (this.bindings == null || this.bindings.isEmpty()) {
            return Collections.singletonList(this.convertToBindingDTO());
        }
        return this.bindings;
    }

    public void setBindings(List<BindingDTO> bindings) {
        this.bindings = bindings;
    }

    private BindingDTO convertToBindingDTO() {
        BindingDTO bindingDTO = new BindingDTO();
        bindingDTO.uri = this.bind;
        bindingDTO.apps = this.apps;
        bindingDTO.clientAuth = this.clientAuth;
        bindingDTO.passwordCodec = this.passwordCodec;
        bindingDTO.keyStorePath = this.keyStorePath;
        bindingDTO.setKeyStorePassword(this.keyStorePassword);
        bindingDTO.trustStorePath = this.trustStorePath;
        bindingDTO.setTrustStorePassword(this.trustStorePassword);
        bindingDTO.setIncludedTLSProtocols(this.includedTLSProtocols);
        bindingDTO.setExcludedTLSProtocols(this.excludedTLSProtocols);
        bindingDTO.setIncludedCipherSuites(this.includedCipherSuites);
        bindingDTO.setExcludedCipherSuites(this.excludedCipherSuites);
        return bindingDTO;
    }

    public BindingDTO getDefaultBinding() {
        return this.getBindings().get(0);
    }
}

