/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.protocols.relay;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Consumer;
import org.apache.activemq.artemis.shaded.org.jgroups.Address;
import org.apache.activemq.artemis.shaded.org.jgroups.EmptyMessage;
import org.apache.activemq.artemis.shaded.org.jgroups.Event;
import org.apache.activemq.artemis.shaded.org.jgroups.JChannel;
import org.apache.activemq.artemis.shaded.org.jgroups.Message;
import org.apache.activemq.artemis.shaded.org.jgroups.PhysicalAddress;
import org.apache.activemq.artemis.shaded.org.jgroups.View;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.Component;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.ManagedAttribute;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.ManagedOperation;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.Property;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.XmlElement;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.XmlInclude;
import org.apache.activemq.artemis.shaded.org.jgroups.conf.AttributeType;
import org.apache.activemq.artemis.shaded.org.jgroups.conf.ConfiguratorFactory;
import org.apache.activemq.artemis.shaded.org.jgroups.conf.XmlNode;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.relay.RelayHeader;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.relay.Relayer;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.relay.Route;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.relay.RouteStatusListener;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.relay.SiteAddress;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.relay.SiteMasterPicker;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.relay.Topology;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.relay.config.RelayConfig;
import org.apache.activemq.artemis.shaded.org.jgroups.stack.Protocol;
import org.apache.activemq.artemis.shaded.org.jgroups.util.ExtendedUUID;
import org.apache.activemq.artemis.shaded.org.jgroups.util.SuppressLog;
import org.apache.activemq.artemis.shaded.org.jgroups.util.TimeScheduler;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

@XmlInclude(schema={"relay.xsd"}, type=XmlInclude.Type.IMPORT, namespace="urn:jgroups:relay:1.0", alias="relay")
@XmlElement(name="RelayConfiguration", type="relay:RelayConfigurationType")
public abstract class RELAY
extends Protocol {
    public static final short can_become_site_master_flag = 2;
    @Property(description="Name of the site; must be defined in the configuration", writable=false)
    protected String site;
    @Property(description="Name of the relay configuration", writable=false)
    protected String config;
    @Property(description="Whether or not this node can become the site master. If false, and we become the coordinator, we won't start the bridge(s)", writable=false)
    protected boolean can_become_site_master = true;
    @Property(description="Maximum number of site masters. Setting this to a value greater than 1 means that we can have multiple site masters. If the value is greater than the number of cluster nodes, everyone in the site will be a site master (and thus join the global cluster", writable=false)
    protected int max_site_masters = 1;
    @Property(description="Ratio of members that are site masters, out of range [0..1] (0 disables this). The number of site masters is computes as Math.min(max_site_masters, view.size() * site_masters_ratio). See https://issues.redhat.com/browse/JGRP-2581 for details")
    protected double site_masters_ratio;
    @Property(description="Fully qualified name of a class implementing SiteMasterPicker")
    protected String site_master_picker_impl;
    @Property(description="If true, the creation of the relay channel (and the connect()) are done in the background. Async relay creation is recommended, so the view callback won't be blocked")
    protected boolean async_relay_creation = true;
    @Property(description="When a site master goes down, delay the sitesDown() callback if we have multiple members; we know that another member will become site master (https://issues.redhat.com/browse/JGRP-2708)")
    protected boolean delay_sites_down = true;
    @Property(description="Time during which identical errors about no route to host will be suppressed. 0 disables this (every error will be logged).", type=AttributeType.TIME)
    protected long suppress_time_no_route_errors = 60000L;
    @ManagedAttribute(description="Whether this member is a site master")
    protected volatile boolean is_site_master;
    @ManagedAttribute(description="A list of site masters in this (local) site")
    protected volatile List<Address> site_masters;
    @ManagedAttribute(description="The first of all site masters broadcasts route-up/down messages to all members of the local cluster")
    protected volatile boolean broadcast_route_notifications;
    protected volatile Relayer relayer;
    @Component(description="Maintains a cache of sites and members", name="topo")
    protected final Topology topo = new Topology(this);
    protected final LongAdder forward_to_site_master = new LongAdder();
    protected final LongAdder forward_sm_time = new LongAdder();
    protected final LongAdder relayed = new LongAdder();
    protected final LongAdder relayed_time = new LongAdder();
    protected final LongAdder forward_to_local_mbr = new LongAdder();
    protected final LongAdder forward_to_local_mbr_time = new LongAdder();
    protected short[] prots_above;
    protected TimeScheduler timer;
    protected SiteMasterPicker site_master_picker;
    protected volatile View view;
    protected volatile List<Address> members = new ArrayList<Address>(11);
    protected volatile RouteStatusListener route_status_listener;
    protected Consumer<Boolean> site_master_listener;
    protected final Map<String, RelayConfig.SiteConfig> sites = new HashMap<String, RelayConfig.SiteConfig>();
    protected RelayConfig.SiteConfig site_config;
    protected SuppressLog<String> suppress_log_no_route;

    @ManagedAttribute(description="Number of messages forwarded to the local SiteMaster")
    public long getNumForwardedToSiteMaster() {
        return this.forward_to_site_master.sum();
    }

    @ManagedAttribute(description="The total time (in ms) spent forwarding messages to the local SiteMaster", type=AttributeType.TIME)
    public long getTimeForwardingToSM() {
        return TimeUnit.MILLISECONDS.convert(this.forward_sm_time.sum(), TimeUnit.NANOSECONDS);
    }

    @ManagedAttribute(description="The average number of messages / s for forwarding messages to the local SiteMaster")
    public long getAvgMsgsForwardingToSM() {
        return this.getTimeForwardingToSM() > 0L ? (long)((double)this.getNumForwardedToSiteMaster() / ((double)this.getTimeForwardingToSM() / 1000.0)) : 0L;
    }

    @ManagedAttribute(description="Number of messages sent by this SiteMaster to a remote SiteMaster")
    public long getNumRelayed() {
        return this.relayed.sum();
    }

    @ManagedAttribute(description="The total time (ms) spent relaying messages from this SiteMaster to remote SiteMasters", type=AttributeType.TIME)
    public long getTimeRelaying() {
        return TimeUnit.MILLISECONDS.convert(this.relayed_time.sum(), TimeUnit.NANOSECONDS);
    }

    @ManagedAttribute(description="The average number of messages / s for relaying messages from this SiteMaster to remote SiteMasters")
    public long getAvgMsgsRelaying() {
        return this.getTimeRelaying() > 0L ? (long)((double)this.getNumRelayed() / ((double)this.getTimeRelaying() / 1000.0)) : 0L;
    }

    @ManagedAttribute(description="Number of messages (received from a remote Sitemaster and) delivered by this SiteMaster to a local node")
    public long getNumForwardedToLocalMbr() {
        return this.forward_to_local_mbr.sum();
    }

    @ManagedAttribute(description="The total time (in ms) spent forwarding messages to a member in the same site", type=AttributeType.TIME)
    public long getTimeForwardingToLocalMbr() {
        return TimeUnit.MILLISECONDS.convert(this.forward_to_local_mbr_time.sum(), TimeUnit.NANOSECONDS);
    }

    @ManagedAttribute(description="The average number of messages / s for forwarding messages to a member in the same site")
    public long getAvgMsgsForwardingToLocalMbr() {
        return this.getTimeForwardingToLocalMbr() > 0L ? (long)((double)this.getNumForwardedToLocalMbr() / ((double)this.getTimeForwardingToLocalMbr() / 1000.0)) : 0L;
    }

    @ManagedAttribute(description="Number of 'no route to site X' errors")
    public int getNumberOfNoRouteErrors() {
        return this.suppress_log_no_route.getCache().size();
    }

    @ManagedOperation(description="Clears the 'no route to site X' cache")
    public <T extends RELAY> T clearNoRouteCache() {
        this.suppress_log_no_route.getCache().clear();
        return (T)this;
    }

    public String getSite() {
        return this.site;
    }

    public String site() {
        return this.site;
    }

    public <T extends RELAY> T setSite(String s) {
        this.site = s;
        return (T)this;
    }

    public <T extends RELAY> T site(String s) {
        this.site = s;
        return (T)this;
    }

    public Topology topo() {
        return this.topo;
    }

    public View view() {
        return this.view;
    }

    public List<Address> members() {
        return this.members;
    }

    public String config() {
        return this.config;
    }

    public <T extends RELAY> T config(String cfg) {
        this.config = cfg;
        return (T)this;
    }

    public String getConfig() {
        return this.config;
    }

    public <T extends RELAY> T setConfig(String c) {
        this.config = c;
        return (T)this;
    }

    public TimeScheduler getTimer() {
        return this.timer;
    }

    public void incrementRelayed() {
        this.relayed.increment();
    }

    public void addToRelayedTime(long d) {
        this.relayed_time.add(d);
    }

    public List<Address> siteMasters() {
        return this.site_masters;
    }

    public boolean canBecomeSiteMaster() {
        return this.can_become_site_master;
    }

    public <T extends RELAY> T canBecomeSiteMaster(boolean f) {
        this.can_become_site_master = f;
        return (T)this;
    }

    public int getMaxSiteMasters() {
        return this.max_site_masters;
    }

    public <T extends RELAY> T setMaxSiteMasters(int m) {
        this.max_site_masters = m;
        return (T)this;
    }

    public double getSiteMastersRatio() {
        return this.site_masters_ratio;
    }

    public <T extends RELAY> T setSiteMastersRatio(double r) {
        this.site_masters_ratio = r;
        return (T)this;
    }

    public String getSiteMasterPickerImpl() {
        return this.site_master_picker_impl;
    }

    public <T extends RELAY> T setSiteMasterPickerImpl(String s) {
        this.site_master_picker_impl = s;
        return (T)this;
    }

    public <T extends RELAY> T siteMasterPicker(SiteMasterPicker s) {
        if (s != null) {
            this.site_master_picker = s;
        }
        return (T)this;
    }

    public boolean asyncRelayCreation() {
        return this.async_relay_creation;
    }

    public <T extends RELAY> T asyncRelayCreation(boolean flag) {
        this.async_relay_creation = flag;
        return (T)this;
    }

    public boolean delaySitesDown() {
        return this.delay_sites_down;
    }

    public <T extends RELAY> T delaySitesDown(boolean b) {
        this.delay_sites_down = b;
        return (T)this;
    }

    public boolean broadcastRouteNotifications() {
        return this.broadcast_route_notifications;
    }

    public <T extends RELAY> T broadcastRouteNotifications(boolean b) {
        this.broadcast_route_notifications = b;
        return (T)this;
    }

    public RouteStatusListener getRouteStatusListener() {
        return this.route_status_listener;
    }

    public void setRouteStatusListener(RouteStatusListener l) {
        this.route_status_listener = l;
    }

    public <T extends RELAY> T setSiteMasterListener(Consumer<Boolean> l) {
        this.site_master_listener = l;
        return (T)this;
    }

    public <T extends RELAY> T addSite(String n, RelayConfig.SiteConfig cfg) {
        this.sites.put(n, cfg);
        return (T)this;
    }

    public List<String> siteNames() {
        return this.getSites();
    }

    @ManagedAttribute(description="Whether or not this instance is a site master")
    public boolean isSiteMaster() {
        return this.relayer != null;
    }

    public List<String> getSites() {
        return this.sites.isEmpty() ? Collections.emptyList() : new ArrayList<String>(this.sites.keySet());
    }

    @ManagedOperation(description="Prints the routes that are currently up. Only available if we're the current coordinator (site master)")
    public String printSites() {
        return this.relayer != null ? Util.print(this.relayer.getSiteNames()) : "n/a (not site master)";
    }

    @ManagedOperation(description="Prints the contents of the routing table. Only available if we're the current coordinator (site master)")
    public String printRoutes() {
        return this.relayer != null ? this.relayer.printRoutes() : "n/a (not site master)";
    }

    public Route getRoute(String site_name) {
        Relayer tmp = this.relayer;
        return tmp != null ? tmp.getRoute(site_name) : null;
    }

    public List<String> getCurrentSites() {
        Relayer rel = this.relayer;
        return rel == null ? null : new ArrayList<String>(rel.getSiteNames());
    }

    public JChannel getBridge(String site_name) {
        Relayer tmp = this.relayer;
        Route route = tmp != null ? tmp.getRoute(site_name) : null;
        return route != null ? route.bridge() : null;
    }

    public View getBridgeView(String cluster_name) {
        Relayer tmp = this.relayer;
        return tmp != null ? tmp.getBridgeView(cluster_name) : null;
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.forward_to_site_master.reset();
        this.forward_sm_time.reset();
        this.relayed.reset();
        this.relayed_time.reset();
        this.forward_to_local_mbr.reset();
        this.forward_to_local_mbr_time.reset();
        this.clearNoRouteCache();
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.configure();
        if (this.site_master_picker == null) {
            this.site_master_picker = new SiteMasterPicker(){

                @Override
                public Address pickSiteMaster(List<Address> site_masters, Address original_sender) {
                    return Util.pickRandomElement(site_masters);
                }

                @Override
                public Route pickRoute(String site, List<Route> routes, Address original_sender) {
                    return Util.pickRandomElement(routes);
                }
            };
        }
        if (this.suppress_time_no_route_errors <= 0L) {
            throw new IllegalArgumentException("suppress_time_no_route_errors has to be > 0");
        }
        this.suppress_log_no_route = new SuppressLog(this.log, "RelayNoRouteToSite", "SuppressMsgRelay");
    }

    @Override
    public void stop() {
        super.stop();
        this.is_site_master = false;
        this.log.trace("%s: ceased to be site master; closing bridges", this.local_addr);
        if (this.relayer != null) {
            this.relayer.stop();
        }
    }

    public void configure() throws Exception {
        this.timer = this.getTransport().getTimer();
        if (this.site == null) {
            throw new IllegalArgumentException("site cannot be null");
        }
        if (this.max_site_masters < 1) {
            this.log.warn("max_size_masters was " + this.max_site_masters + ", changed to 1");
            this.max_site_masters = 1;
        }
        if (this.site_masters_ratio < 0.0) {
            this.log.warn("%s: changing incorrect site_masters_ratio of %.2f to 0", this.local_addr, this.site_masters_ratio);
            this.site_masters_ratio = 0.0;
        } else if (this.site_masters_ratio > 1.0) {
            this.log.warn("%s: changing incorrect site_masters_ratio of %.2f to 1", this.local_addr, this.site_masters_ratio);
            this.site_masters_ratio = 1.0;
        }
        if (this.site_master_picker_impl != null) {
            Class<?> clazz = Util.loadClass(this.site_master_picker_impl, (Class)null);
            this.site_master_picker = (SiteMasterPicker)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        if (this.config != null) {
            this.parseSiteConfiguration(this.sites);
        }
        this.site_config = this.sites.get(this.site);
        if (this.site_config == null) {
            throw new Exception("site configuration for \"" + this.site + "\" not found in " + this.config);
        }
        this.log.trace("site configuration:\n" + this.site_config);
        this.prots_above = this.getIdsAbove();
    }

    @Override
    public void parse(XmlNode node) throws Exception {
        RelayConfig.parse(node, this.sites);
    }

    @Override
    public Object down(Event evt) {
        if (evt.getType() == 6) {
            this.handleView((View)evt.getArg());
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object up(Event evt) {
        if (evt.getType() == 6) {
            this.handleView((View)evt.getArg());
        }
        return this.up_prot.up(evt);
    }

    public abstract void handleView(View var1);

    protected abstract void handleRelayMessage(Message var1);

    public String toString() {
        return String.format("%s%s", this.getClass().getSimpleName(), this.local_addr != null ? String.format(" (%s)", this.local_addr) : "");
    }

    protected void parseSiteConfiguration(Map<String, RelayConfig.SiteConfig> map) throws Exception {
        try (InputStream input = ConfiguratorFactory.getConfigStream(this.config);){
            RelayConfig.parse(input, map);
        }
    }

    protected Message copy(Message msg) {
        return Util.copy(msg, true, (short)200, this.prots_above);
    }

    protected void sitesChange(boolean down2, Set<String> sites) {
        if (!this.broadcast_route_notifications || sites == null || sites.isEmpty()) {
            return;
        }
        RelayHeader hdr = new RelayHeader(down2 ? (byte)5 : 4, null, null).addToSites(sites);
        this.down_prot.down(new EmptyMessage(null).putHeader(this.id, hdr));
    }

    protected void notifySiteMasterListener(boolean flag) {
        if (this.site_master_listener != null) {
            this.site_master_listener.accept(flag);
        }
    }

    protected PhysicalAddress getPhysicalAddress(Address mbr) {
        return mbr != null ? (PhysicalAddress)this.down(new Event(87, mbr)) : null;
    }

    protected static List<Address> determineSiteMasters(View view, int max_num_site_masters) {
        Address coord;
        ArrayList<Address> retval = new ArrayList<Address>(view.size());
        int selected = 0;
        for (Address member : view) {
            if (member instanceof ExtendedUUID && !((ExtendedUUID)member).isFlagSet((short)2) || selected++ >= max_num_site_masters) continue;
            retval.add(member);
        }
        if (retval.isEmpty() && (coord = view.getCoord()) != null) {
            retval.add(coord);
        }
        return retval;
    }

    protected Address pickSiteMaster(Address sender) {
        List<Address> masters = this.site_masters;
        if (masters.size() == 1) {
            return masters.get(0);
        }
        return this.site_master_picker.pickSiteMaster(masters, sender);
    }

    protected void triggerSiteUnreachableEvent(SiteAddress remoteSite) {
        this.up_prot.up(new Event(104, remoteSite));
        if (this.route_status_listener != null) {
            this.route_status_listener.sitesUnreachable(remoteSite.getSite());
        }
    }
}

