/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.stack;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.activemq.artemis.shaded.org.jgroups.Address;
import org.apache.activemq.artemis.shaded.org.jgroups.PhysicalAddress;
import org.apache.activemq.artemis.shaded.org.jgroups.logging.Log;
import org.apache.activemq.artemis.shaded.org.jgroups.logging.LogFactory;
import org.apache.activemq.artemis.shaded.org.jgroups.stack.GossipData;
import org.apache.activemq.artemis.shaded.org.jgroups.stack.GossipType;
import org.apache.activemq.artemis.shaded.org.jgroups.stack.RouterStub;
import org.apache.activemq.artemis.shaded.org.jgroups.util.SocketFactory;
import org.apache.activemq.artemis.shaded.org.jgroups.util.TimeScheduler;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

public class RouterStubManager
implements Runnable,
RouterStub.CloseListener {
    protected final List<RouterStub> stubs = new ArrayList<RouterStub>();
    protected final TimeScheduler timer;
    protected final String cluster_name;
    protected final Address local_addr;
    protected final String logical_name;
    protected final PhysicalAddress phys_addr;
    protected final long reconnect_interval;
    protected boolean use_nio = true;
    protected Future<?> reconnector_task;
    protected Future<?> heartbeat_task;
    protected Future<?> timeout_checker_task;
    protected final Log log;
    protected SocketFactory socket_factory;
    protected long heartbeat_interval;
    protected long heartbeat_timeout;
    protected final Runnable send_heartbeat = this::sendHeartbeat;
    protected final Runnable check_timeouts = this::checkTimeouts;

    public RouterStubManager(Log log, TimeScheduler timer, String cluster_name, Address local_addr, String logical_name, PhysicalAddress phys_addr, long reconnect_interval) {
        this.log = log != null ? log : LogFactory.getLog(RouterStubManager.class);
        this.timer = timer;
        this.cluster_name = cluster_name;
        this.local_addr = local_addr;
        this.logical_name = logical_name;
        this.phys_addr = phys_addr;
        this.reconnect_interval = reconnect_interval;
    }

    public static RouterStubManager emptyGossipClientStubManager(Log log, TimeScheduler timer) {
        return new RouterStubManager(log, timer, null, null, null, null, 0L);
    }

    public RouterStubManager useNio(boolean flag) {
        this.use_nio = flag;
        return this;
    }

    public boolean reconnectorRunning() {
        return this.reconnector_task != null && !this.reconnector_task.isDone();
    }

    public boolean heartbeaterRunning() {
        return this.heartbeat_task != null && !this.heartbeat_task.isDone();
    }

    public boolean timeouterRunning() {
        return this.timeout_checker_task != null && !this.timeout_checker_task.isDone();
    }

    public RouterStubManager socketFactory(SocketFactory socket_factory) {
        this.socket_factory = socket_factory;
        return this;
    }

    public RouterStubManager heartbeat(long heartbeat_interval, long heartbeat_timeout) {
        if (heartbeat_interval <= 0L) {
            this.stopHeartbeatTask();
            this.stopTimeoutChecker();
            this.stubs.forEach((? super T s) -> s.handleHeartbeats(false));
            this.heartbeat_interval = 0L;
            return this;
        }
        if (heartbeat_interval >= heartbeat_timeout) {
            throw new IllegalArgumentException(String.format("heartbeat_interval (%d) must be < than heartbeat_timeout (%d)", heartbeat_interval, heartbeat_timeout));
        }
        this.heartbeat_interval = heartbeat_interval;
        this.heartbeat_timeout = heartbeat_timeout;
        this.stubs.forEach((? super T s) -> s.handleHeartbeats(true));
        this.startHeartbeatTask();
        this.startTimeoutChecker();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEach(Consumer<RouterStub> action) {
        List<RouterStub> list = this.stubs;
        synchronized (list) {
            this.stubs.stream().filter(RouterStub::isConnected).forEach(action);
        }
    }

    public void forAny(Consumer<RouterStub> action) {
        RouterStub stub = this.findRandomConnectedStub();
        if (stub != null) {
            action.accept(stub);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RouterStub createAndRegisterStub(InetSocketAddress local, InetSocketAddress router_addr) {
        RouterStub stub = new RouterStub(local, router_addr, this.use_nio, this, this.socket_factory).handleHeartbeats(this.heartbeat_interval > 0L);
        List<RouterStub> list = this.stubs;
        synchronized (list) {
            this.stubs.add(stub);
        }
        return stub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RouterStub unregisterStub(InetSocketAddress router_addr_sa) {
        List<RouterStub> list = this.stubs;
        synchronized (list) {
            RouterStub s = this.stubs.stream().filter(st -> Objects.equals(st.remote_sa, router_addr_sa)).findFirst().orElse(null);
            if (s != null) {
                s.destroy();
                this.stubs.remove(s);
            }
            return s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectStubs() {
        boolean failed_connect_attempts = false;
        List<RouterStub> list = this.stubs;
        synchronized (list) {
            for (RouterStub stub : this.stubs) {
                if (stub.isConnected()) continue;
                try {
                    stub.connect(this.cluster_name, this.local_addr, this.logical_name, this.phys_addr);
                }
                catch (Exception ex) {
                    failed_connect_attempts = true;
                }
            }
        }
        if (failed_connect_attempts) {
            this.startReconnector();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnectStubs() {
        this.stopReconnector();
        List<RouterStub> list = this.stubs;
        synchronized (list) {
            for (RouterStub stub : this.stubs) {
                try {
                    stub.disconnect(this.cluster_name, this.local_addr);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyStubs() {
        this.stopReconnector();
        List<RouterStub> list = this.stubs;
        synchronized (list) {
            this.stubs.forEach(RouterStub::destroy);
            this.stubs.clear();
        }
    }

    public String printStubs() {
        return Util.printListWithDelimiter(this.stubs, ", ");
    }

    public String printReconnectList() {
        return this.stubs.stream().filter(s -> !s.isConnected()).map(s -> String.format("%s:%d", s.remote_sa.getHostString(), s.remote_sa.getPort())).collect(Collectors.joining(", "));
    }

    public String print() {
        return String.format("Stubs: %s\nReconnect list: %s", this.printStubs(), this.printReconnectList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int failed_reconnect_attempts = 0;
        List<RouterStub> list = this.stubs;
        synchronized (list) {
            for (RouterStub stub : this.stubs) {
                if (stub.isConnected()) continue;
                try {
                    stub.connect(this.cluster_name, this.local_addr, this.logical_name, this.phys_addr);
                    this.log.debug("%s: re-established connection to GossipRouter %s (group: %s)", this.local_addr, stub.remote(), this.cluster_name);
                }
                catch (Exception ex) {
                    ++failed_reconnect_attempts;
                }
            }
        }
        if (failed_reconnect_attempts == 0) {
            this.stopReconnector();
        }
    }

    @Override
    public void closed(RouterStub stub) {
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("%s: GossipRouter %s closed connection; starting reconnector task", this.local_addr, stub.remote());
            }
            stub.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.startReconnector();
    }

    protected synchronized void startReconnector() {
        if (this.reconnector_task == null || this.reconnector_task.isDone()) {
            this.reconnector_task = this.timer.scheduleWithFixedDelay(this, this.reconnect_interval, this.reconnect_interval, TimeUnit.MILLISECONDS);
        }
    }

    protected synchronized void stopReconnector() {
        if (this.reconnector_task != null) {
            this.reconnector_task.cancel(true);
        }
    }

    protected synchronized void startHeartbeatTask() {
        if (this.heartbeat_task == null || this.heartbeat_task.isDone()) {
            this.heartbeat_task = this.timer.scheduleWithFixedDelay(this.send_heartbeat, this.heartbeat_interval, this.heartbeat_interval, TimeUnit.MILLISECONDS);
        }
    }

    protected synchronized void stopHeartbeatTask() {
        this.stopTimeoutChecker();
        if (this.heartbeat_task != null) {
            this.heartbeat_task.cancel(true);
        }
    }

    protected synchronized void startTimeoutChecker() {
        if (this.timeout_checker_task == null || this.timeout_checker_task.isDone()) {
            this.timeout_checker_task = this.timer.scheduleWithFixedDelay(this.check_timeouts, this.heartbeat_timeout, this.heartbeat_timeout, TimeUnit.MILLISECONDS);
        }
    }

    protected synchronized void stopTimeoutChecker() {
        if (this.timeout_checker_task != null) {
            this.timeout_checker_task.cancel(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RouterStub findRandomConnectedStub() {
        RouterStub stub = null;
        List<RouterStub> list = this.stubs;
        synchronized (list) {
            while (this.connectedStubs() > 0) {
                RouterStub tmp = Util.pickRandomElement(this.stubs);
                if (tmp == null || !tmp.isConnected()) continue;
                return tmp;
            }
            return stub;
        }
    }

    protected void sendHeartbeat() {
        GossipData hb = new GossipData(GossipType.HEARTBEAT);
        this.forEach(s -> {
            try {
                s.writeRequest(hb);
            }
            catch (Exception ex) {
                this.log.error("failed sending heartbeat", ex);
            }
        });
    }

    protected void checkTimeouts() {
        this.forEach(st -> {
            long timeout = System.currentTimeMillis() - st.lastHeartbeat();
            if (timeout > this.heartbeat_timeout) {
                this.log.debug("%s: closed connection to GossipRouter %s as no heartbeat has been received for %s", this.local_addr, st.remote(), Util.printTime(timeout, TimeUnit.MILLISECONDS), st);
                st.destroy();
            }
        });
        if (this.disconnectedStubs()) {
            this.startReconnector();
        }
    }

    protected int connectedStubs() {
        return (int)this.stubs.stream().filter(RouterStub::isConnected).count();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean disconnectedStubs() {
        List<RouterStub> list = this.stubs;
        synchronized (list) {
            return this.stubs.stream().anyMatch(st -> !st.isConnected());
        }
    }
}

