/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.protocols.relay;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.activemq.artemis.shaded.org.jgroups.Address;
import org.apache.activemq.artemis.shaded.org.jgroups.JChannel;
import org.apache.activemq.artemis.shaded.org.jgroups.Message;
import org.apache.activemq.artemis.shaded.org.jgroups.Receiver;
import org.apache.activemq.artemis.shaded.org.jgroups.View;
import org.apache.activemq.artemis.shaded.org.jgroups.logging.Log;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.pbcast.GMS;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.relay.RELAY;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.relay.Relayer;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.relay.Relayer3;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.relay.Route;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.relay.SiteUUID;
import org.apache.activemq.artemis.shaded.org.jgroups.stack.AddressGenerator;
import org.apache.activemq.artemis.shaded.org.jgroups.stack.Protocol;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

public class Bridge
implements Receiver {
    protected final JChannel channel;
    protected final Relayer3 rel;
    protected final RELAY relay;
    protected final Log log;
    protected final String cluster_name;
    protected View view;
    protected final long join_timeout;

    protected Bridge(JChannel ch, Relayer3 r, String cluster_name, String channel_name, AddressGenerator addr_generator) throws Exception {
        this.channel = ch;
        this.cluster_name = cluster_name;
        this.rel = r;
        this.relay = this.rel.relay();
        this.log = this.rel.log();
        this.channel.setName(channel_name).setReceiver(this).addAddressGenerator(addr_generator);
        this.join_timeout = ((GMS)this.channel.getProtocolStack().findProtocol((Class<? extends Protocol>)GMS.class)).getJoinTimeout();
    }

    protected void start() throws Exception {
        this.channel.connect(this.cluster_name);
        this.log.info("%s: joined bridge cluster '%s'", this.channel.getAddress(), this.cluster_name);
    }

    protected void stop() {
        this.log.info("%s: leaving bridge cluster '%s'", this.channel.getAddress(), this.channel.getClusterName());
        Util.close((Closeable)this.channel);
    }

    @Override
    public void receive(Message msg) {
        this.relay.handleRelayMessage(msg);
    }

    @Override
    public void viewAccepted(View new_view) {
        View old_view = this.view;
        Map<String, List<Address>> sites = Util.getSites(new_view, this.relay.site());
        List<String> removed_routes = Bridge.removedRoutes(old_view, new_view);
        HashSet<String> up2 = new HashSet<String>();
        HashSet<String> down2 = new HashSet<String>(removed_routes);
        this.view = new_view;
        for (String string : sites.keySet()) {
            if (this.rel.hasRouteTo(string)) continue;
            up2.add(string);
        }
        this.log.trace("[Relayer " + String.valueOf(this.channel.getAddress()) + "] view: " + String.valueOf(new_view));
        for (Map.Entry entry : sites.entrySet()) {
            String key = (String)entry.getKey();
            List val = (List)entry.getValue();
            List<Route> existing = this.rel.getRoutes(key);
            ArrayList<Route> newRoutes = existing != null ? new ArrayList<Route>(existing) : new ArrayList();
            newRoutes.removeIf(r -> !val.contains(r.siteMaster()));
            val.stream().filter(addr -> !Bridge.contains(newRoutes, addr)).forEach(addr -> newRoutes.add(new Route((Address)addr, this.channel, this.relay, this.log).stats(this.relay.statsEnabled())));
            if (newRoutes.isEmpty()) {
                this.rel.removeRoute(key);
                down2.add(key);
                continue;
            }
            this.rel.addRoutes(key, newRoutes);
        }
        if (!removed_routes.isEmpty() && this.log.isTraceEnabled()) {
            this.log.trace("%s: removing routes %s from routing table", this.channel.getAddress(), removed_routes);
        }
        removed_routes.forEach(this.rel::removeRoute);
        if (!down2.isEmpty()) {
            if (this.relay.delaySitesDown()) {
                Relayer r3 = this.relay.relayer;
                Map<String, View> map = this.relay.topo().cache();
                for (String s : down2) {
                    View v = map.get(s);
                    if (v == null || v.size() < 2) {
                        this.relay.sitesChange(true, Set.of(s));
                        continue;
                    }
                    long timeout = this.join_timeout * 2L;
                    long interval = timeout / 10L;
                    CompletableFuture.supplyAsync(() -> Util.waitUntilTrue(timeout, interval, () -> r3.hasRouteTo(s))).thenAccept(success -> {
                        if (!success.booleanValue()) {
                            this.relay.sitesChange(true, Set.of(s));
                        }
                    });
                }
            } else {
                this.relay.sitesChange(true, down2);
            }
        }
        if (!up2.isEmpty()) {
            this.relay.sitesChange(false, up2);
        }
    }

    public String toString() {
        return String.format("bridge %s", this.cluster_name);
    }

    protected static boolean contains(List<Route> routes, Address addr) {
        return routes.stream().anyMatch(route -> route.siteMaster().equals(addr));
    }

    protected static List<String> removedRoutes(View old_view, View new_view) {
        ArrayList<String> l = new ArrayList<String>();
        if (old_view == null) {
            return l;
        }
        List<String> old_routes = Stream.of(old_view.getMembersRaw()).filter(a -> a instanceof SiteUUID).map(s -> ((SiteUUID)s).getSite()).collect(Collectors.toList());
        List new_routes = Stream.of(new_view.getMembersRaw()).filter(a -> a instanceof SiteUUID).map(s -> ((SiteUUID)s).getSite()).collect(Collectors.toList());
        old_routes.removeAll(new_routes);
        return old_routes;
    }
}

