/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.util;

import java.io.Closeable;
import java.io.IOException;
import java.net.Socket;
import java.nio.file.Path;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import org.apache.activemq.artemis.shaded.org.jgroups.logging.Log;
import org.apache.activemq.artemis.shaded.org.jgroups.logging.LogFactory;
import org.apache.activemq.artemis.shaded.org.jgroups.util.FileWatcher;

public final class ReloadingX509KeyManager
extends X509ExtendedKeyManager
implements Closeable {
    static final Log LOG = LogFactory.getLog(ReloadingX509KeyManager.class);
    private final AtomicReference<X509ExtendedKeyManager> manager;
    private final Path path;
    private final Function<Path, X509ExtendedKeyManager> action;
    private final FileWatcher watcher;
    private Instant lastLoaded;

    public ReloadingX509KeyManager(FileWatcher watcher, Path path, Function<Path, X509ExtendedKeyManager> action) {
        Objects.requireNonNull(watcher, "watcher must be non-null");
        Objects.requireNonNull(path, "path must be non-null");
        Objects.requireNonNull(action, "action must be non-null");
        this.manager = new AtomicReference();
        this.watcher = watcher;
        this.path = path;
        this.action = action;
        this.reload(this.path);
        watcher.watch(path, this::reload);
    }

    private void reload(Path path) {
        this.manager.set(this.action.apply(path));
        this.lastLoaded = Instant.now();
        LOG.debug("Loaded '%s'", path);
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return this.manager.get().getClientAliases(keyType, issuers);
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        return this.manager.get().chooseClientAlias(keyType, issuers, socket);
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return this.manager.get().getServerAliases(keyType, issuers);
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        return this.manager.get().chooseServerAlias(keyType, issuers, socket);
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        return this.manager.get().getCertificateChain(alias);
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        return this.manager.get().getPrivateKey(alias);
    }

    @Override
    public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
        return this.manager.get().chooseEngineClientAlias(keyType, issuers, engine);
    }

    @Override
    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        return this.manager.get().chooseEngineServerAlias(keyType, issuers, engine);
    }

    public Instant lastLoaded() {
        return this.lastLoaded;
    }

    @Override
    public void close() throws IOException {
        this.watcher.unwatch(this.path);
    }
}

