/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.protocols;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.activemq.artemis.shaded.org.jgroups.Event;
import org.apache.activemq.artemis.shaded.org.jgroups.Message;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.Experimental;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.MBean;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.ManagedAttribute;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.Property;
import org.apache.activemq.artemis.shaded.org.jgroups.conf.AttributeType;
import org.apache.activemq.artemis.shaded.org.jgroups.stack.Protocol;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

@Experimental
@MBean(description="Limits the sending rate to max_bytes per time_period")
public class RATE_LIMITER
extends Protocol {
    @Property(description="Max number of bytes to be sent in time_period ms. Blocks the sender if exceeded until a new time period has started", type=AttributeType.BYTES)
    protected long max_bytes = 300000L;
    @Property(description="Number of milliseconds during which max_bytes bytes can be sent", type=AttributeType.TIME)
    protected long time_period = 10L;
    protected long time_period_ns;
    @ManagedAttribute(description="Number of bytes sent in the current time period. Reset after every time period.", type=AttributeType.BYTES)
    protected long num_bytes_sent_in_period = 0L;
    protected long current_period_start;
    protected final Lock lock = new ReentrantLock();
    @ManagedAttribute
    protected int num_blockings = 0;
    protected long total_block_time = 0L;
    protected int frag_size = 0;
    protected volatile boolean running = true;

    public long getMaxBytes() {
        return this.max_bytes;
    }

    public void setMaxBytes(long max_bytes) {
        this.max_bytes = max_bytes;
    }

    public long getTimePeriod() {
        return this.time_period;
    }

    public void setTimePeriod(long time_period) {
        this.time_period = time_period;
        this.time_period_ns = TimeUnit.NANOSECONDS.convert(time_period, TimeUnit.MILLISECONDS);
    }

    @ManagedAttribute(description="Total block time in milliseconds", type=AttributeType.TIME)
    public long getTotalBlockTime() {
        return TimeUnit.MILLISECONDS.convert(this.total_block_time, TimeUnit.NANOSECONDS);
    }

    @ManagedAttribute(description="Average block time in ms (total block time / number of blockings)")
    public double getAverageBlockTime() {
        long block_time_ms = this.getTotalBlockTime();
        return this.num_blockings == 0 ? 0.0 : (double)block_time_ms / (double)this.num_blockings;
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.num_blockings = 0;
        this.total_block_time = 0L;
    }

    @Override
    public void init() throws Exception {
        super.init();
        if (this.time_period <= 0L) {
            throw new IllegalArgumentException("time_period needs to be positive");
        }
        this.time_period_ns = TimeUnit.NANOSECONDS.convert(this.time_period, TimeUnit.MILLISECONDS);
    }

    @Override
    public void start() throws Exception {
        super.start();
        if (this.max_bytes < (long)this.frag_size) {
            throw new IllegalStateException("max_bytes (" + this.max_bytes + ") need to be bigger than frag_size (" + this.frag_size + ")");
        }
        this.running = true;
    }

    @Override
    public void stop() {
        this.running = false;
        super.stop();
    }

    @Override
    public Object down(Event evt) {
        if (evt.getType() == 56) {
            Integer tmp;
            Map map = (Map)evt.getArg();
            Integer n = tmp = map != null ? (Integer)map.get("frag_size") : null;
            if (tmp != null) {
                this.frag_size = tmp;
            }
            if (this.frag_size > 0 && this.max_bytes % (long)this.frag_size != 0L) {
                this.log.warn("For optimal performance, max_bytes (%d) should be a multiple of frag_size (%d)", this.max_bytes, this.frag_size);
            }
        }
        return this.down_prot.down(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object down(Message msg) {
        int len = msg.getLength();
        if (len == 0 || msg.isFlagSet(Message.Flag.NO_FC)) {
            return this.down_prot.down(msg);
        }
        this.lock.lock();
        try {
            if ((long)len > this.max_bytes) {
                this.log.error(Util.getMessage("MessageLength") + len + " bytes) exceeded max_bytes (" + this.max_bytes + "); adjusting max_bytes to " + len);
                this.max_bytes = len;
            }
            if (this.num_bytes_sent_in_period + (long)len > this.max_bytes) {
                long current_time = System.nanoTime();
                long block_time = this.time_period_ns - (current_time - this.current_period_start);
                if (block_time > 0L) {
                    LockSupport.parkNanos(block_time);
                    ++this.num_blockings;
                    this.total_block_time += block_time;
                }
                this.current_period_start = block_time > 0L ? current_time + block_time : System.nanoTime();
                this.num_bytes_sent_in_period = 0L;
            }
        }
        finally {
            this.num_bytes_sent_in_period += (long)len;
            this.lock.unlock();
        }
        return this.down_prot.down(msg);
    }
}

