/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.protocols.pbcast;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.activemq.artemis.shaded.org.jgroups.Address;
import org.apache.activemq.artemis.shaded.org.jgroups.View;
import org.apache.activemq.artemis.shaded.org.jgroups.ViewId;
import org.apache.activemq.artemis.shaded.org.jgroups.util.ArrayIterator;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

public class DeltaView
extends View {
    protected ViewId ref_view_id;
    protected Address[] left_members;
    protected Address[] new_members;

    public DeltaView() {
    }

    public DeltaView(ViewId view_id, ViewId ref_view_id, Address[] left_members, Address[] new_members) {
        this.view_id = view_id;
        this.ref_view_id = ref_view_id;
        this.left_members = left_members;
        this.new_members = new_members;
        if (view_id == null) {
            throw new IllegalArgumentException("view_id cannot be null");
        }
        if (ref_view_id == null) {
            throw new IllegalArgumentException("ref_view_id cannot be null");
        }
    }

    public ViewId getRefViewId() {
        return this.ref_view_id;
    }

    public Address[] getLeftMembers() {
        return this.left_members;
    }

    public Address[] getNewMembers() {
        return this.new_members;
    }

    @Override
    public int serializedSize() {
        int retval = this.view_id.serializedSize() + this.ref_view_id.serializedSize();
        retval = (int)((long)retval + Util.size(this.left_members));
        retval = (int)((long)retval + Util.size(this.new_members));
        return retval;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        this.view_id.writeTo(out);
        this.ref_view_id.writeTo(out);
        Util.writeAddresses(this.left_members, out);
        Util.writeAddresses(this.new_members, out);
    }

    @Override
    public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
        this.view_id = new ViewId();
        this.view_id.readFrom(in);
        this.ref_view_id = new ViewId();
        this.ref_view_id.readFrom(in);
        this.left_members = Util.readAddresses(in);
        this.new_members = Util.readAddresses(in);
    }

    @Override
    public Iterator<Address> iterator() {
        Address[] combined = new Address[this.left_members.length + this.new_members.length];
        int left_len = this.left_members.length;
        System.arraycopy(this.left_members, 0, combined, 0, left_len);
        System.arraycopy(this.new_members, 0, combined, left_len, this.new_members.length);
        return new ArrayIterator<Address>(combined);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString()).append(", ref-view=").append(this.ref_view_id);
        if (this.left_members != null && this.left_members.length > 0) {
            sb.append(", left=").append(Arrays.toString(this.left_members));
        }
        if (this.new_members != null && this.new_members.length > 0) {
            sb.append(", joined=").append(Arrays.toString(this.new_members));
        }
        return sb.toString();
    }
}

