/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.ra;

import jakarta.jms.ConnectionMetaData;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.apache.activemq.artemis.ra.ActiveMQRALogger;

public class ActiveMQRAConnectionMetaData
implements ConnectionMetaData {
    public static final String DEFAULT_PROP_FILE_NAME = "jms-version.properties";
    private static final String JMS_VERSION_NAME;
    private static final int JMS_MAJOR_VERSION;
    private static final int JMS_MINOR_VERSION;

    public ActiveMQRAConnectionMetaData() {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("constructor()");
        }
    }

    public String getJMSVersion() {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getJMSVersion()");
        }
        return JMS_VERSION_NAME;
    }

    public int getJMSMajorVersion() {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getJMSMajorVersion()");
        }
        return JMS_MAJOR_VERSION;
    }

    public int getJMSMinorVersion() {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getJMSMinorVersion()");
        }
        return JMS_MINOR_VERSION;
    }

    public String getJMSProviderName() {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getJMSProviderName()");
        }
        return "ActiveMQ Artemis";
    }

    public String getProviderVersion() {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getJMSProviderName()");
        }
        return "2.4";
    }

    public int getProviderMajorVersion() {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getProviderMajorVersion()");
        }
        return 2;
    }

    public int getProviderMinorVersion() {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getProviderMinorVersion()");
        }
        return 4;
    }

    public Enumeration<Object> getJMSXPropertyNames() {
        Vector<String> v = new Vector<String>();
        v.add("JMSXGroupID");
        v.add("JMSXGroupSeq");
        v.add("JMSXDeliveryCount");
        return v.elements();
    }

    static {
        Properties versionProps = new Properties();
        try (InputStream in = ActiveMQRAConnectionMetaData.class.getClassLoader().getResourceAsStream(DEFAULT_PROP_FILE_NAME);){
            if (in != null) {
                versionProps.load(in);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        JMS_VERSION_NAME = versionProps.getProperty("activemq.version.implementation.versionName", "2.0");
        JMS_MAJOR_VERSION = Integer.valueOf(versionProps.getProperty("activemq.version.implementation.majorVersion", "2"));
        JMS_MINOR_VERSION = Integer.valueOf(versionProps.getProperty("activemq.version.implementation.minorVersion", "0"));
    }
}

