/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.activemq.artemis.ra;

import jakarta.jms.JMSException;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.XAQueueConnection;
import jakarta.jms.XATopicConnection;

/**
 * A joint interface for all connection types
 */
public interface ActiveMQRASessionFactory extends XATopicConnection, XAQueueConnection {

   /**
    * Error message for strict behaviour
    */
   String ISE = "This method is not applicable inside the application server. See the J2EE spec, e.g. J2EE1.4 Section 6.6";

   /**
    * Add a temporary queue
    *
    * @param temp The temporary queue
    */
   void addTemporaryQueue(TemporaryQueue temp);

   /**
    * Add a temporary topic
    *
    * @param temp The temporary topic
    */
   void addTemporaryTopic(TemporaryTopic temp);

   /**
    * Notification that a session is closed
    *
    * @param session The session
    * @throws JMSException for any error
    */
   void closeSession(ActiveMQRASession session) throws JMSException;
}
