/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.ra.inflow;

import jakarta.resource.ResourceException;
import jakarta.resource.spi.ActivationSpec;
import jakarta.resource.spi.InvalidPropertyException;
import jakarta.resource.spi.ResourceAdapter;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.Hashtable;
import java.util.Objects;
import org.apache.activemq.artemis.ra.ActiveMQRALogger;
import org.apache.activemq.artemis.ra.ActiveMQRaUtils;
import org.apache.activemq.artemis.ra.ActiveMQResourceAdapter;
import org.apache.activemq.artemis.ra.ConnectionFactoryProperties;
import org.apache.activemq.artemis.ra.inflow.ActiveMQActivationValidationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQActivationSpec
extends ConnectionFactoryProperties
implements ActivationSpec,
Serializable {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final long serialVersionUID = -7997041053897964654L;
    private static final int DEFAULT_MAX_SESSION = 15;
    private static final boolean DEFAULT_SINGLE_CONNECTION = false;
    public String strConnectorClassName;
    public String strConnectionParameters;
    protected Boolean allowLocalTransactions;
    private ActiveMQResourceAdapter ra;
    private String connectionFactoryLookup;
    private String destination;
    private String destinationType;
    private String messageSelector;
    private Integer acknowledgeMode;
    private Boolean subscriptionDurability;
    private String subscriptionName;
    private Boolean shareSubscriptions = false;
    private String user;
    private String password;
    private Integer maxSession;
    private Boolean singleConnection = false;
    @Deprecated(forRemoval=true)
    private Integer transactionTimeout;
    private Boolean useJNDI = true;
    private String jndiParams = null;
    private Hashtable<String, String> parsedJndiParams;
    private Boolean localTx;
    private Integer setupAttempts;
    private Long setupInterval;
    private Boolean rebalanceConnections = false;
    private String topicPrefix;
    private String queuePrefix;

    public ActiveMQActivationSpec() {
        logger.trace("constructor()");
        this.ra = new ActiveMQResourceAdapter();
        this.destination = null;
        this.destinationType = null;
        this.messageSelector = null;
        this.acknowledgeMode = 1;
        this.subscriptionDurability = false;
        this.subscriptionName = null;
        this.user = null;
        this.password = null;
        this.maxSession = 15;
        this.transactionTimeout = 0;
    }

    public ResourceAdapter getResourceAdapter() {
        logger.trace("getResourceAdapter()");
        return this.ra;
    }

    public Boolean isUseJNDI() {
        if (this.useJNDI == null) {
            return this.ra.isUseJNDI();
        }
        return this.useJNDI;
    }

    public void setUseJNDI(Boolean value) {
        this.useJNDI = value;
    }

    public String getJndiParams() {
        if (this.jndiParams == null) {
            return this.ra.getJndiParams();
        }
        return this.jndiParams;
    }

    public void setJndiParams(String jndiParams) {
        this.jndiParams = jndiParams;
        this.parsedJndiParams = ActiveMQRaUtils.parseHashtableConfig(jndiParams);
    }

    public Hashtable<?, ?> getParsedJndiParams() {
        if (this.parsedJndiParams == null) {
            return this.ra.getParsedJndiParams();
        }
        return this.parsedJndiParams;
    }

    public void setResourceAdapter(ResourceAdapter ra) throws ResourceException {
        logger.trace("setResourceAdapter({})", (Object)ra);
        if (ra == null || !(ra instanceof ActiveMQResourceAdapter)) {
            throw new ResourceException("Resource adapter is " + String.valueOf(ra));
        }
        this.ra = (ActiveMQResourceAdapter)ra;
    }

    public String getConnectionFactoryLookup() {
        logger.trace("getConnectionFactoryLookup() ->{}", (Object)this.connectionFactoryLookup);
        return this.connectionFactoryLookup;
    }

    public void setConnectionFactoryLookup(String value) {
        logger.trace("setConnectionFactoryLookup({})", (Object)value);
        this.connectionFactoryLookup = value;
    }

    public String getDestination() {
        logger.trace("getDestination()");
        return this.destination;
    }

    public void setDestination(String value) {
        logger.trace("setDestination({})", (Object)value);
        this.destination = value;
    }

    public String getDestinationLookup() {
        return this.getDestination();
    }

    public void setDestinationLookup(String value) {
        this.setDestination(value);
        this.setUseJNDI(true);
    }

    public String getDestinationType() {
        logger.trace("getDestinationType()");
        return this.destinationType;
    }

    public void setDestinationType(String value) {
        logger.trace("setDestinationType({})", (Object)value);
        this.destinationType = value;
    }

    public String getMessageSelector() {
        logger.trace("getMessageSelector()");
        return this.messageSelector;
    }

    public void setMessageSelector(String value) {
        logger.trace("setMessageSelector({})", (Object)value);
        this.messageSelector = value;
    }

    public String getAcknowledgeMode() {
        logger.trace("getAcknowledgeMode()");
        if (3 == this.acknowledgeMode) {
            return "Dups-ok-acknowledge";
        }
        return "Auto-acknowledge";
    }

    public void setQueuePrefix(String prefix) {
        this.queuePrefix = prefix;
    }

    public String getQueuePrefix() {
        return this.queuePrefix;
    }

    public void setTopicPrefix(String prefix) {
        this.topicPrefix = prefix;
    }

    public String getTopicPrefix() {
        return this.topicPrefix;
    }

    public void setAcknowledgeMode(String value) {
        logger.trace("setAcknowledgeMode({})", (Object)value);
        try {
            this.acknowledgeMode = ActiveMQActivationValidationUtils.validateAcknowledgeMode(value);
        }
        catch (IllegalArgumentException e) {
            ActiveMQRALogger.LOGGER.invalidAcknowledgementMode(value);
            throw e;
        }
    }

    public Integer getAcknowledgeModeInt() {
        logger.trace("getAcknowledgeMode()");
        return this.acknowledgeMode;
    }

    public String getSubscriptionDurability() {
        logger.trace("getSubscriptionDurability()");
        if (this.subscriptionDurability.booleanValue()) {
            return "Durable";
        }
        return "NonDurable";
    }

    public void setSubscriptionDurability(String value) {
        logger.trace("setSubscriptionDurability({})", (Object)value);
        this.subscriptionDurability = "Durable".equals(value);
    }

    public Boolean isSubscriptionDurable() {
        logger.trace("isSubscriptionDurable()");
        return this.subscriptionDurability;
    }

    public String getSubscriptionName() {
        logger.trace("getSubscriptionName()");
        return this.subscriptionName;
    }

    public void setSubscriptionName(String value) {
        logger.trace("setSubscriptionName({})", (Object)value);
        this.subscriptionName = value;
    }

    public Boolean isShareSubscriptions() {
        logger.trace("isShareSubscriptions() = {}", (Object)this.shareSubscriptions);
        return this.shareSubscriptions;
    }

    public void setShareSubscriptions(Boolean shareSubscriptions) {
        logger.trace("setShareSubscriptions({})", (Object)shareSubscriptions);
        this.shareSubscriptions = shareSubscriptions;
    }

    public String getUser() {
        logger.trace("getUser()");
        if (this.user == null) {
            return this.ra.getUserName();
        }
        return this.user;
    }

    public void setUser(String value) {
        logger.trace("setUser()", (Object)value);
        this.user = value;
    }

    public String getUserName() {
        if (logger.isTraceEnabled()) {
            logger.trace("getUserName()");
        }
        if (this.user == null) {
            return this.ra.getUserName();
        }
        return this.user;
    }

    public void setUserName(String value) {
        if (logger.isTraceEnabled()) {
            logger.trace("setUserName(" + value + ")");
        }
        this.user = value;
    }

    public String getPassword() {
        logger.trace("getPassword()");
        if (this.password == null) {
            return this.ra.getPassword();
        }
        return this.password;
    }

    public String getOwnPassword() {
        return this.password;
    }

    public void setPassword(String value) throws Exception {
        logger.trace("setPassword(****)");
        this.password = value;
    }

    public Integer getMaxSession() {
        logger.trace("getMaxSession()");
        if (this.maxSession == null) {
            return 15;
        }
        return this.maxSession;
    }

    public void setMaxSession(Integer value) {
        logger.trace("setMaxSession({})", (Object)value);
        if (value < 1) {
            this.maxSession = 1;
            ActiveMQRALogger.LOGGER.invalidNumberOfMaxSession(value, this.maxSession);
        } else {
            this.maxSession = value;
        }
    }

    public Boolean isSingleConnection() {
        logger.trace("getSingleConnection()");
        if (this.singleConnection == null) {
            return false;
        }
        return this.singleConnection;
    }

    public void setSingleConnection(Boolean value) {
        logger.trace("setSingleConnection({})", (Object)value);
        this.singleConnection = value;
    }

    @Deprecated(forRemoval=true)
    public Integer getTransactionTimeout() {
        logger.trace("getTransactionTimeout()");
        return this.transactionTimeout;
    }

    @Deprecated(forRemoval=true)
    public void setTransactionTimeout(Integer value) {
        logger.trace("setTransactionTimeout({})", (Object)value);
        this.transactionTimeout = value;
    }

    public Boolean isUseLocalTx() {
        if (this.localTx == null) {
            return this.ra.getUseLocalTx();
        }
        return this.localTx;
    }

    public void setUseLocalTx(Boolean localTx) {
        this.localTx = localTx;
    }

    public Boolean getRebalanceConnections() {
        return this.rebalanceConnections;
    }

    public Boolean isRebalanceConnections() {
        return this.rebalanceConnections;
    }

    public void setRebalanceConnections(Boolean rebalanceConnections) {
        this.rebalanceConnections = rebalanceConnections;
    }

    public Integer getSetupAttempts() {
        logger.trace("getSetupAttempts()");
        if (this.setupAttempts == null) {
            return this.ra.getSetupAttempts();
        }
        return this.setupAttempts;
    }

    public void setSetupAttempts(Integer setupAttempts) {
        logger.trace("setSetupAttempts({})", (Object)setupAttempts);
        this.setupAttempts = setupAttempts;
    }

    public Long getSetupInterval() {
        logger.trace("getSetupInterval()");
        if (this.setupInterval == null) {
            return this.ra.getSetupInterval();
        }
        return this.setupInterval;
    }

    public void setSetupInterval(Long setupInterval) {
        logger.trace("setSetupInterval({})", (Object)setupInterval);
        this.setupInterval = setupInterval;
    }

    public void setClientId(String clientId) {
        this.setClientID(clientId);
    }

    public void validate() throws InvalidPropertyException {
        logger.trace("validate()");
        ActiveMQActivationValidationUtils.validate(this.destination, this.destinationType, this.isSubscriptionDurable(), this.subscriptionName);
    }

    public String getConnectorClassName() {
        return this.strConnectorClassName;
    }

    public void setConnectorClassName(String connectorClassName) {
        logger.trace("setConnectorClassName({})", (Object)connectorClassName);
        this.strConnectorClassName = connectorClassName;
        this.setParsedConnectorClassNames(ActiveMQRaUtils.parseConnectorConnectorConfig(connectorClassName));
    }

    public String getConnectionParameters() {
        return this.strConnectionParameters;
    }

    public void setConnectionParameters(String configuration) {
        this.strConnectionParameters = configuration;
        this.setParsedConnectionParameters(ActiveMQRaUtils.parseConfig(configuration));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ActiveMQActivationSpec.class.getName()).append('(');
        sb.append("ra=").append(this.ra);
        if (this.connectionFactoryLookup != null) {
            sb.append(" connectionFactoryLookup=").append(this.connectionFactoryLookup);
        }
        sb.append(" destination=").append(this.destination);
        sb.append(" destinationType=").append(this.destinationType);
        if (this.messageSelector != null) {
            sb.append(" selector=").append(this.messageSelector);
        }
        sb.append(" ack=").append(this.getAcknowledgeMode());
        sb.append(" durable=").append(this.subscriptionDurability);
        sb.append(" clientID=").append(this.getClientID());
        if (this.subscriptionName != null) {
            sb.append(" subscription=").append(this.subscriptionName);
        }
        sb.append(" user=").append(this.user);
        if (this.password != null) {
            sb.append(" password=").append("****");
        }
        sb.append(" maxSession=").append(this.maxSession);
        sb.append(')');
        return sb.toString();
    }

    public void setUseDLQ(Boolean b) {
    }

    public void setDLQJNDIName(String name) {
    }

    public void setDLQHandler(String handler) {
    }

    public void setDLQMaxResent(Integer maxResent) {
    }

    public void setProviderAdapterJNDI(String jndi) {
    }

    public void setKeepAlive(Boolean keepAlive) {
    }

    public void setKeepAliveMillis(Long keepAliveMillis) {
    }

    public void setReconnectInterval(Long interval) {
    }

    public void setMinSession(Integer value) {
    }

    public void setMaxMessages(Integer value) {
    }

    public Boolean isAllowLocalTransactions() {
        return this.allowLocalTransactions;
    }

    public void setAllowLocalTransactions(Boolean allowLocalTransactions) {
        this.allowLocalTransactions = allowLocalTransactions;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ActiveMQActivationSpec)) {
            return false;
        }
        ActiveMQActivationSpec that = (ActiveMQActivationSpec)obj;
        if (!super.equals(obj)) {
            return false;
        }
        return Objects.equals(this.acknowledgeMode, that.acknowledgeMode) && Objects.equals(this.subscriptionDurability, that.subscriptionDurability) && Objects.equals(this.shareSubscriptions, that.shareSubscriptions) && Objects.equals(this.strConnectorClassName, that.strConnectorClassName) && Objects.equals(this.strConnectionParameters, that.strConnectionParameters) && Objects.equals(this.ra, that.ra) && Objects.equals(this.connectionFactoryLookup, that.connectionFactoryLookup) && Objects.equals(this.destination, that.destination) && Objects.equals(this.destinationType, that.destinationType) && Objects.equals(this.messageSelector, that.messageSelector) && Objects.equals(this.subscriptionName, that.subscriptionName) && Objects.equals(this.user, that.user) && Objects.equals(this.password, that.password) && Objects.equals(this.maxSession, that.maxSession) && Objects.equals(this.useJNDI, that.useJNDI) && Objects.equals(this.transactionTimeout, that.transactionTimeout) && Objects.equals(this.singleConnection, that.singleConnection) && Objects.equals(this.jndiParams, that.jndiParams) && Objects.equals(this.parsedJndiParams, that.parsedJndiParams) && Objects.equals(this.localTx, that.localTx) && Objects.equals(this.rebalanceConnections, that.rebalanceConnections) && Objects.equals(this.setupAttempts, that.setupAttempts) && Objects.equals(this.queuePrefix, that.queuePrefix) && Objects.equals(this.topicPrefix, that.topicPrefix) && Objects.equals(this.setupInterval, that.setupInterval);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.strConnectorClassName, this.strConnectionParameters, this.ra, this.connectionFactoryLookup, this.destination, this.destinationType, this.messageSelector, this.acknowledgeMode, this.subscriptionDurability, this.subscriptionName, this.shareSubscriptions, this.user, this.password, this.maxSession, this.singleConnection, this.transactionTimeout, this.useJNDI, this.jndiParams, this.parsedJndiParams, this.localTx, this.rebalanceConnections, this.setupAttempts, this.setupInterval, this.queuePrefix, this.topicPrefix);
    }
}

