/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jdbc.store.file;

import java.io.File;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.io.nio.NIOSequentialFileFactory;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.jdbc.store.JDBCUtils;
import org.apache.activemq.artemis.jdbc.store.file.JDBCSequentialFile;
import org.apache.activemq.artemis.jdbc.store.file.JDBCSequentialFileFactoryDriver;
import org.apache.activemq.artemis.journal.ActiveMQJournalLogger;

public class JDBCSequentialFileFactory
implements SequentialFileFactory,
ActiveMQComponent {
    private boolean started;
    private List<JDBCSequentialFile> files;
    private Executor executor;
    private Map<String, Object> fileLocks = new HashMap<String, Object>();
    private final JDBCSequentialFileFactoryDriver dbDriver;

    public JDBCSequentialFileFactory(String connectionUrl, String tableName, String className, Executor executor) throws Exception {
        this.executor = executor;
        this.files = new ArrayList<JDBCSequentialFile>();
        this.dbDriver = JDBCUtils.getDBFileDriver(className, tableName, connectionUrl);
    }

    public synchronized void start() {
        try {
            if (!this.started) {
                this.dbDriver.start();
                this.started = true;
            }
        }
        catch (Exception e) {
            ActiveMQJournalLogger.LOGGER.error((Object)"Could not start file factory, unable to connect to database");
            this.started = false;
        }
    }

    public synchronized void stop() {
        try {
            this.dbDriver.stop();
        }
        catch (SQLException e) {
            ActiveMQJournalLogger.LOGGER.error((Object)"Error stopping file factory, unable to close db connection");
        }
        this.started = false;
    }

    public SequentialFile createSequentialFile(String fileName) {
        try {
            this.fileLocks.putIfAbsent(fileName, new Object());
            JDBCSequentialFile file = new JDBCSequentialFile(this, fileName, this.executor, this.dbDriver, this.fileLocks.get(fileName));
            this.files.add(file);
            return file;
        }
        catch (Exception e) {
            ActiveMQJournalLogger.LOGGER.error((Object)"Could not create file", (Throwable)e);
            return null;
        }
    }

    public int getMaxIO() {
        return 1;
    }

    public List<String> listFiles(String extension) throws Exception {
        return this.dbDriver.listFiles(extension);
    }

    public boolean isSupportsCallbacks() {
        return true;
    }

    public void onIOError(Exception exception, String message, SequentialFile file) {
    }

    public ByteBuffer allocateDirectBuffer(int size) {
        return NIOSequentialFileFactory.allocateDirectByteBuffer((int)size);
    }

    public void releaseDirectBuffer(ByteBuffer buffer) {
    }

    public ByteBuffer newBuffer(int size) {
        return ByteBuffer.allocate(size);
    }

    public void clearBuffer(ByteBuffer buffer) {
        int limit = buffer.limit();
        buffer.rewind();
        for (int i = 0; i < limit; ++i) {
            buffer.put((byte)0);
        }
        buffer.rewind();
    }

    public ByteBuffer wrapBuffer(byte[] bytes) {
        return ByteBuffer.wrap(bytes);
    }

    public int getAlignment() {
        return 1;
    }

    public int calculateBlockSize(int bytes) {
        return bytes;
    }

    public void deactivateBuffer() {
    }

    public void releaseBuffer(ByteBuffer buffer) {
    }

    public void activateBuffer(SequentialFile file) {
    }

    public File getDirectory() {
        return null;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void createDirs() throws Exception {
    }

    public void flush() {
    }

    public synchronized void destroy() throws SQLException {
        this.dbDriver.destroy();
    }
}

