/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jdbc.store.journal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.core.journal.LoaderCallback;
import org.apache.activemq.artemis.core.journal.PreparedTransactionInfo;
import org.apache.activemq.artemis.core.journal.RecordInfo;
import org.apache.activemq.artemis.core.journal.TransactionFailureCallback;

public class JDBCJournalLoaderCallback
implements LoaderCallback {
    private final List<PreparedTransactionInfo> preparedTransactions;
    private final TransactionFailureCallback failureCallback;
    private final Map<Long, List<Integer>> deleteReferences = new HashMap<Long, List<Integer>>();
    private final List<RecordInfo> committedRecords;
    private long maxId = -1L;

    public JDBCJournalLoaderCallback(List<RecordInfo> committedRecords, List<PreparedTransactionInfo> preparedTransactions, TransactionFailureCallback failureCallback, boolean fixBadTX) {
        this.committedRecords = committedRecords;
        this.preparedTransactions = preparedTransactions;
        this.failureCallback = failureCallback;
    }

    public synchronized void checkMaxId(long id) {
        if (this.maxId < id) {
            this.maxId = id;
        }
    }

    public void addPreparedTransaction(PreparedTransactionInfo preparedTransaction) {
        this.preparedTransactions.add(preparedTransaction);
    }

    public synchronized void addRecord(RecordInfo info) {
        int index = this.committedRecords.size();
        this.committedRecords.add(index, info);
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        indexes.add(index);
        this.deleteReferences.put(info.id, indexes);
        this.checkMaxId(info.id);
    }

    public synchronized void updateRecord(RecordInfo info) {
        int index = this.committedRecords.size();
        this.committedRecords.add(index, info);
    }

    public synchronized void deleteRecord(long id) {
        for (Integer i : this.deleteReferences.get(id)) {
            this.committedRecords.remove(i);
        }
    }

    public void failedTransaction(long transactionID, List<RecordInfo> records, List<RecordInfo> recordsToDelete) {
        if (this.failureCallback != null) {
            this.failureCallback.failedTransaction(transactionID, records, recordsToDelete);
        }
    }

    public long getMaxId() {
        return this.maxId;
    }
}

