/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jdbc.store.drivers;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.activemq.artemis.jdbc.store.JDBCUtils;
import org.apache.activemq.artemis.jdbc.store.sql.SQLProvider;
import org.apache.activemq.artemis.journal.ActiveMQJournalLogger;

public abstract class AbstractJDBCDriver {
    protected Connection connection;
    protected SQLProvider sqlProvider;
    protected String jdbcConnectionUrl;
    protected String jdbcDriverClass;
    protected Driver dbDriver;

    public AbstractJDBCDriver() {
    }

    public AbstractJDBCDriver(String tableName, String jdbcConnectionUrl, String jdbcDriverClass) {
        this.jdbcConnectionUrl = jdbcConnectionUrl;
        this.jdbcDriverClass = jdbcDriverClass;
        this.sqlProvider = JDBCUtils.getSQLProvider(jdbcDriverClass, tableName);
    }

    public void start() throws Exception {
        this.connect();
        this.createSchema();
        this.prepareStatements();
    }

    public void stop() throws SQLException {
        if (this.sqlProvider.closeConnectionOnShutdown()) {
            this.connection.close();
        }
    }

    protected abstract void prepareStatements() throws SQLException;

    protected abstract void createSchema() throws SQLException;

    protected void createTable(String schemaSql) throws SQLException {
        JDBCUtils.createTableIfNotExists(this.connection, this.sqlProvider.getTableName(), schemaSql);
    }

    protected void connect() throws Exception {
        try {
            this.dbDriver = JDBCUtils.getDriver(this.jdbcDriverClass);
            this.connection = this.dbDriver.connect(this.jdbcConnectionUrl, new Properties());
        }
        catch (SQLException e) {
            ActiveMQJournalLogger.LOGGER.error((Object)("Unable to connect to database using URL: " + this.jdbcConnectionUrl));
            throw new RuntimeException("Error connecting to database", e);
        }
    }

    public void destroy() throws Exception {
        try {
            this.connection.setAutoCommit(false);
            try (Statement statement = this.connection.createStatement();){
                statement.executeUpdate("DROP TABLE " + this.sqlProvider.getTableName());
            }
            this.connection.commit();
        }
        catch (SQLException e) {
            this.connection.rollback();
            throw e;
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public SQLProvider getSqlProvider() {
        return this.sqlProvider;
    }

    public void setSqlProvider(SQLProvider sqlProvider) {
        this.sqlProvider = sqlProvider;
    }

    public String getJdbcConnectionUrl() {
        return this.jdbcConnectionUrl;
    }

    public void setJdbcConnectionUrl(String jdbcConnectionUrl) {
        this.jdbcConnectionUrl = jdbcConnectionUrl;
    }

    public String getJdbcDriverClass() {
        return this.jdbcDriverClass;
    }

    public void setJdbcDriverClass(String jdbcDriverClass) {
        this.jdbcDriverClass = jdbcDriverClass;
    }
}

