/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jdbc.store.journal;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.journal.IOCompletion;
import org.apache.activemq.artemis.core.journal.Journal;
import org.apache.activemq.artemis.core.journal.JournalLoadInformation;
import org.apache.activemq.artemis.core.journal.LoaderCallback;
import org.apache.activemq.artemis.core.journal.PreparedTransactionInfo;
import org.apache.activemq.artemis.core.journal.RecordInfo;
import org.apache.activemq.artemis.core.journal.TransactionFailureCallback;
import org.apache.activemq.artemis.core.journal.impl.JournalFile;
import org.apache.activemq.artemis.core.journal.impl.SimpleWaitIOCallback;
import org.apache.activemq.artemis.jdbc.store.drivers.AbstractJDBCDriver;
import org.apache.activemq.artemis.jdbc.store.journal.JDBCJournalLoaderCallback;
import org.apache.activemq.artemis.jdbc.store.journal.JDBCJournalReaderCallback;
import org.apache.activemq.artemis.jdbc.store.journal.JDBCJournalRecord;
import org.apache.activemq.artemis.jdbc.store.journal.JDBCJournalSync;
import org.apache.activemq.artemis.jdbc.store.journal.TransactionHolder;
import org.apache.activemq.artemis.journal.ActiveMQJournalLogger;
import org.jboss.logging.Logger;

public class JDBCJournalImpl
extends AbstractJDBCDriver
implements Journal {
    private static final Logger logger = Logger.getLogger(JDBCJournalImpl.class);
    public static final int SYNC_DELAY = 5;
    private static int USER_VERSION = 1;
    private final List<JDBCJournalRecord> records;
    private PreparedStatement insertJournalRecords;
    private PreparedStatement selectJournalRecords;
    private PreparedStatement countJournalRecords;
    private PreparedStatement deleteJournalRecords;
    private PreparedStatement deleteJournalTxRecords;
    private boolean started;
    private Timer syncTimer;
    private final Object journalLock = new Object();
    private final String timerThread;
    private Map<Long, TransactionHolder> transactions = new ConcurrentHashMap<Long, TransactionHolder>();
    private AtomicLong seq = new AtomicLong(0L);

    public JDBCJournalImpl(String jdbcUrl, String tableName, String jdbcDriverClass) {
        super(tableName, jdbcUrl, jdbcDriverClass);
        this.timerThread = "Timer JDBC Journal(" + tableName + ")";
        this.records = new ArrayList<JDBCJournalRecord>();
    }

    @Override
    public void start() throws Exception {
        super.start();
        this.syncTimer = new Timer(this.timerThread, true);
        this.syncTimer.schedule((TimerTask)new JDBCJournalSync(this), 10L, 5L);
        this.started = true;
    }

    @Override
    protected void createSchema() throws SQLException {
        this.createTable(this.sqlProvider.getCreateJournalTableSQL());
    }

    @Override
    protected void prepareStatements() throws SQLException {
        logger.tracef("preparing statements", new Object[0]);
        this.insertJournalRecords = this.connection.prepareStatement(this.sqlProvider.getInsertJournalRecordsSQL());
        this.selectJournalRecords = this.connection.prepareStatement(this.sqlProvider.getSelectJournalRecordsSQL());
        this.countJournalRecords = this.connection.prepareStatement(this.sqlProvider.getCountJournalRecordsSQL());
        this.deleteJournalRecords = this.connection.prepareStatement(this.sqlProvider.getDeleteJournalRecordsSQL());
        this.deleteJournalTxRecords = this.connection.prepareStatement(this.sqlProvider.getDeleteJournalTxRecordsSQL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stop() throws SQLException {
        if (this.started) {
            Object object = this.journalLock;
            synchronized (object) {
                this.syncTimer.cancel();
                this.sync();
                this.started = false;
                super.stop();
            }
        }
    }

    @Override
    public synchronized void destroy() throws Exception {
        super.destroy();
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int sync() {
        if (!this.started) {
            return 0;
        }
        ArrayList<JDBCJournalRecord> recordRef = new ArrayList<JDBCJournalRecord>();
        List<JDBCJournalRecord> list = this.records;
        synchronized (list) {
            recordRef.addAll(this.records);
            this.records.clear();
        }
        ArrayList<Long> deletedRecords = new ArrayList<Long>();
        ArrayList<Long> committedTransactions = new ArrayList<Long>();
        boolean success = false;
        try {
            block14: for (JDBCJournalRecord record : recordRef) {
                record.storeLineUp();
                switch (record.getRecordType()) {
                    case 16: {
                        deletedRecords.add(record.getId());
                        record.writeDeleteRecord(this.deleteJournalRecords);
                        continue block14;
                    }
                    case 19: {
                        this.deleteJournalTxRecords.setLong(1, record.getTxId());
                        this.deleteJournalTxRecords.addBatch();
                        continue block14;
                    }
                    case 18: {
                        TransactionHolder holder = this.transactions.get(record.getTxId());
                        for (RecordInfo info : holder.recordsToDelete) {
                            deletedRecords.add(record.getId());
                            this.deleteJournalRecords.setLong(1, info.id);
                            this.deleteJournalRecords.addBatch();
                        }
                        record.writeRecord(this.insertJournalRecords);
                        committedTransactions.add(record.getTxId());
                        continue block14;
                    }
                }
                record.writeRecord(this.insertJournalRecords);
            }
        }
        catch (SQLException e) {
            this.executeCallbacks(recordRef, success);
            return 0;
        }
        try {
            this.connection.setAutoCommit(false);
            this.insertJournalRecords.executeBatch();
            this.deleteJournalRecords.executeBatch();
            this.deleteJournalTxRecords.executeBatch();
            this.connection.commit();
            success = true;
        }
        catch (SQLException e) {
            this.performRollback(recordRef);
        }
        try {
            if (success) {
                this.cleanupTxRecords(deletedRecords, committedTransactions);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.executeCallbacks(recordRef, success);
        return recordRef.size();
    }

    private synchronized void cleanupTxRecords(List<Long> deletedRecords, List<Long> committedTx) throws SQLException {
        this.connection.rollback();
        ArrayList<TransactionHolder> iterableCopyTx = new ArrayList<TransactionHolder>();
        iterableCopyTx.addAll(this.transactions.values());
        for (Long txId : committedTx) {
            this.transactions.get((Object)txId).committed = true;
        }
        for (TransactionHolder h : iterableCopyTx) {
            ArrayList<RecordInfo> iterableCopy = new ArrayList<RecordInfo>();
            iterableCopy.addAll(h.recordInfos);
            for (RecordInfo info : iterableCopy) {
                if (!deletedRecords.contains(info.id)) continue;
                h.recordInfos.remove(info);
            }
            if (!h.recordInfos.isEmpty() || !h.committed) continue;
            this.deleteJournalTxRecords.setLong(1, h.transactionID);
            this.deleteJournalTxRecords.addBatch();
            this.transactions.remove(h.transactionID);
        }
    }

    private void performRollback(List<JDBCJournalRecord> records) {
        try {
            for (JDBCJournalRecord record : records) {
                if (!record.isTransactional() && record.getRecordType() != 17) continue;
                this.removeTxRecord(record);
            }
            ArrayList<TransactionHolder> txHolders = new ArrayList<TransactionHolder>();
            txHolders.addAll(this.transactions.values());
            for (TransactionHolder txH : txHolders) {
                if (txH.prepared || !txH.recordInfos.isEmpty() || !txH.recordsToDelete.isEmpty()) continue;
                this.transactions.remove(txH.transactionID);
            }
        }
        catch (Exception sqlE) {
            ActiveMQJournalLogger.LOGGER.error((Object)"Error performing rollback", (Throwable)sqlE);
        }
    }

    private void executeCallbacks(final List<JDBCJournalRecord> records, final boolean result) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                for (JDBCJournalRecord record : records) {
                    record.complete(result);
                }
            }
        };
        Thread t = new Thread(r);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendRecord(JDBCJournalRecord record) throws Exception {
        SimpleWaitIOCallback callback = null;
        if (record.isSync() && record.getIoCompletion() == null) {
            callback = new SimpleWaitIOCallback();
            record.setIoCompletion((IOCompletion)callback);
        }
        Object object = this.journalLock;
        synchronized (object) {
            if (record.isTransactional() || record.getRecordType() == 17) {
                this.addTxRecord(record);
            }
            List<JDBCJournalRecord> list = this.records;
            synchronized (list) {
                this.records.add(record);
            }
        }
        if (callback != null) {
            callback.waitCompletion();
        }
    }

    private synchronized void addTxRecord(JDBCJournalRecord record) {
        TransactionHolder txHolder = this.transactions.get(record.getTxId());
        if (txHolder == null) {
            txHolder = new TransactionHolder(record.getTxId());
            this.transactions.put(record.getTxId(), txHolder);
        }
        if (record.isTransactional()) {
            RecordInfo info = new RecordInfo(record.getId().longValue(), record.getRecordType(), new byte[0], record.isUpdate(), (short)record.getCompactCount());
            if (record.getRecordType() == 15) {
                txHolder.recordsToDelete.add(info);
            } else {
                txHolder.recordInfos.add(info);
            }
        } else {
            txHolder.prepared = true;
        }
    }

    private synchronized void removeTxRecord(JDBCJournalRecord record) {
        TransactionHolder txHolder = this.transactions.get(record.getTxId());
        if (record.isTransactional()) {
            RecordInfo info = new RecordInfo(record.getTxId(), record.getRecordType(), new byte[0], record.isUpdate(), (short)record.getCompactCount());
            if (record.getRecordType() == 15) {
                txHolder.recordsToDelete.remove(info);
            } else {
                txHolder.recordInfos.remove(info);
            }
        } else {
            txHolder.prepared = false;
        }
    }

    public void appendAddRecord(long id, byte recordType, byte[] record, boolean sync) throws Exception {
        JDBCJournalRecord r = new JDBCJournalRecord(id, 11, this.seq.incrementAndGet());
        r.setUserRecordType(recordType);
        r.setRecord(record);
        r.setSync(sync);
        this.appendRecord(r);
    }

    public void appendAddRecord(long id, byte recordType, EncodingSupport record, boolean sync) throws Exception {
        JDBCJournalRecord r = new JDBCJournalRecord(id, 11, this.seq.incrementAndGet());
        r.setUserRecordType(recordType);
        r.setRecord(record);
        r.setSync(sync);
        this.appendRecord(r);
    }

    public void appendAddRecord(long id, byte recordType, EncodingSupport record, boolean sync, IOCompletion completionCallback) throws Exception {
        JDBCJournalRecord r = new JDBCJournalRecord(id, 11, this.seq.incrementAndGet());
        r.setUserRecordType(recordType);
        r.setRecord(record);
        r.setSync(sync);
        r.setIoCompletion(completionCallback);
        this.appendRecord(r);
    }

    public void appendUpdateRecord(long id, byte recordType, byte[] record, boolean sync) throws Exception {
        JDBCJournalRecord r = new JDBCJournalRecord(id, 12, this.seq.incrementAndGet());
        r.setUserRecordType(recordType);
        r.setRecord(record);
        r.setSync(sync);
        this.appendRecord(r);
    }

    public void appendUpdateRecord(long id, byte recordType, EncodingSupport record, boolean sync) throws Exception {
        JDBCJournalRecord r = new JDBCJournalRecord(id, 12, this.seq.incrementAndGet());
        r.setUserRecordType(recordType);
        r.setRecord(record);
        r.setSync(sync);
        this.appendRecord(r);
    }

    public void appendUpdateRecord(long id, byte recordType, EncodingSupport record, boolean sync, IOCompletion completionCallback) throws Exception {
        JDBCJournalRecord r = new JDBCJournalRecord(id, 11, this.seq.incrementAndGet());
        r.setUserRecordType(recordType);
        r.setRecord(record);
        r.setSync(sync);
        r.setIoCompletion(completionCallback);
        this.appendRecord(r);
    }

    public void appendDeleteRecord(long id, boolean sync) throws Exception {
        JDBCJournalRecord r = new JDBCJournalRecord(id, 16, this.seq.incrementAndGet());
        r.setSync(sync);
        this.appendRecord(r);
    }

    public void appendDeleteRecord(long id, boolean sync, IOCompletion completionCallback) throws Exception {
        JDBCJournalRecord r = new JDBCJournalRecord(id, 16, this.seq.incrementAndGet());
        r.setSync(sync);
        r.setIoCompletion(completionCallback);
        this.appendRecord(r);
    }

    public void appendAddRecordTransactional(long txID, long id, byte recordType, byte[] record) throws Exception {
        JDBCJournalRecord r = new JDBCJournalRecord(id, 13, this.seq.incrementAndGet());
        r.setUserRecordType(recordType);
        r.setRecord(record);
        r.setTxId(txID);
        this.appendRecord(r);
    }

    public void appendAddRecordTransactional(long txID, long id, byte recordType, EncodingSupport record) throws Exception {
        JDBCJournalRecord r = new JDBCJournalRecord(id, 13, this.seq.incrementAndGet());
        r.setUserRecordType(recordType);
        r.setRecord(record);
        r.setTxId(txID);
        this.appendRecord(r);
    }

    public void appendUpdateRecordTransactional(long txID, long id, byte recordType, byte[] record) throws Exception {
        JDBCJournalRecord r = new JDBCJournalRecord(id, 14, this.seq.incrementAndGet());
        r.setUserRecordType(recordType);
        r.setRecord(record);
        r.setTxId(txID);
        this.appendRecord(r);
    }

    public void appendUpdateRecordTransactional(long txID, long id, byte recordType, EncodingSupport record) throws Exception {
        JDBCJournalRecord r = new JDBCJournalRecord(id, 14, this.seq.incrementAndGet());
        r.setUserRecordType(recordType);
        r.setRecord(record);
        r.setTxId(txID);
        this.appendRecord(r);
    }

    public void appendDeleteRecordTransactional(long txID, long id, byte[] record) throws Exception {
        JDBCJournalRecord r = new JDBCJournalRecord(id, 15, this.seq.incrementAndGet());
        r.setRecord(record);
        r.setTxId(txID);
        this.appendRecord(r);
    }

    public void appendDeleteRecordTransactional(long txID, long id, EncodingSupport record) throws Exception {
        JDBCJournalRecord r = new JDBCJournalRecord(id, 15, this.seq.incrementAndGet());
        r.setRecord(record);
        r.setTxId(txID);
        this.appendRecord(r);
    }

    public void appendDeleteRecordTransactional(long txID, long id) throws Exception {
        JDBCJournalRecord r = new JDBCJournalRecord(id, 15, this.seq.incrementAndGet());
        r.setTxId(txID);
        this.appendRecord(r);
    }

    public void appendCommitRecord(long txID, boolean sync) throws Exception {
        JDBCJournalRecord r = new JDBCJournalRecord(-1L, 18, this.seq.incrementAndGet());
        r.setTxId(txID);
        this.appendRecord(r);
    }

    public void appendCommitRecord(long txID, boolean sync, IOCompletion callback) throws Exception {
        JDBCJournalRecord r = new JDBCJournalRecord(-1L, 18, this.seq.incrementAndGet());
        r.setTxId(txID);
        r.setIoCompletion(callback);
        this.appendRecord(r);
    }

    public void appendCommitRecord(long txID, boolean sync, IOCompletion callback, boolean lineUpContext) throws Exception {
        JDBCJournalRecord r = new JDBCJournalRecord(-1L, 18, this.seq.incrementAndGet());
        r.setTxId(txID);
        r.setStoreLineUp(lineUpContext);
        r.setIoCompletion(callback);
        this.appendRecord(r);
    }

    public void appendPrepareRecord(long txID, EncodingSupport transactionData, boolean sync) throws Exception {
        JDBCJournalRecord r = new JDBCJournalRecord(-1L, 17, this.seq.incrementAndGet());
        r.setTxId(txID);
        r.setTxData(transactionData);
        r.setSync(sync);
        this.appendRecord(r);
    }

    public void appendPrepareRecord(long txID, EncodingSupport transactionData, boolean sync, IOCompletion callback) throws Exception {
        JDBCJournalRecord r = new JDBCJournalRecord(0L, 17, this.seq.incrementAndGet());
        r.setTxId(txID);
        r.setTxData(transactionData);
        r.setTxData(transactionData);
        r.setSync(sync);
        r.setIoCompletion(callback);
        this.appendRecord(r);
    }

    public void appendPrepareRecord(long txID, byte[] transactionData, boolean sync) throws Exception {
        JDBCJournalRecord r = new JDBCJournalRecord(0L, 17, this.seq.incrementAndGet());
        r.setTxId(txID);
        r.setTxData(transactionData);
        r.setSync(sync);
        this.appendRecord(r);
    }

    public void appendRollbackRecord(long txID, boolean sync) throws Exception {
        JDBCJournalRecord r = new JDBCJournalRecord(0L, 19, this.seq.incrementAndGet());
        r.setTxId(txID);
        r.setSync(sync);
        this.appendRecord(r);
    }

    public void appendRollbackRecord(long txID, boolean sync, IOCompletion callback) throws Exception {
        JDBCJournalRecord r = new JDBCJournalRecord(0L, 19, this.seq.incrementAndGet());
        r.setTxId(txID);
        r.setSync(sync);
        r.setIoCompletion(callback);
        this.appendRecord(r);
    }

    public synchronized JournalLoadInformation load(LoaderCallback reloadManager) throws Exception {
        JournalLoadInformation jli = new JournalLoadInformation();
        JDBCJournalReaderCallback jrc = new JDBCJournalReaderCallback(reloadManager);
        try (ResultSet rs = this.selectJournalRecords.executeQuery();){
            int noRecords = 0;
            while (rs.next()) {
                JDBCJournalRecord r = JDBCJournalRecord.readRecord(rs);
                switch (r.getRecordType()) {
                    case 11: {
                        jrc.onReadAddRecord(r.toRecordInfo());
                        break;
                    }
                    case 12: {
                        jrc.onReadUpdateRecord(r.toRecordInfo());
                        break;
                    }
                    case 16: {
                        jrc.onReadDeleteRecord(r.getId());
                        break;
                    }
                    case 13: {
                        jrc.onReadAddRecordTX(r.getTxId(), r.toRecordInfo());
                        break;
                    }
                    case 14: {
                        jrc.onReadUpdateRecordTX(r.getTxId(), r.toRecordInfo());
                        break;
                    }
                    case 15: {
                        jrc.onReadDeleteRecordTX(r.getTxId(), r.toRecordInfo());
                        break;
                    }
                    case 17: {
                        jrc.onReadPrepareRecord(r.getTxId(), r.getTxDataAsByteArray(), r.getTxCheckNoRecords());
                        break;
                    }
                    case 18: {
                        jrc.onReadCommitRecord(r.getTxId(), r.getTxCheckNoRecords());
                        break;
                    }
                    case 19: {
                        jrc.onReadRollbackRecord(r.getTxId());
                        break;
                    }
                    default: {
                        throw new Exception("Error Reading Journal, Unknown Record Type: " + r.getRecordType());
                    }
                }
                ++noRecords;
                if (r.getSeq() <= this.seq.longValue()) continue;
                this.seq.set(r.getSeq());
            }
            jrc.checkPreparedTx();
            jli.setMaxID(((JDBCJournalLoaderCallback)reloadManager).getMaxId());
            jli.setNumberOfRecords(noRecords);
            this.transactions = jrc.getTransactions();
        }
        return jli;
    }

    public JournalLoadInformation loadInternalOnly() throws Exception {
        return null;
    }

    public JournalLoadInformation loadSyncOnly(Journal.JournalState state) throws Exception {
        return null;
    }

    public void lineUpContext(IOCompletion callback) {
        callback.storeLineUp();
    }

    public JournalLoadInformation load(List<RecordInfo> committedRecords, List<PreparedTransactionInfo> preparedTransactions, TransactionFailureCallback transactionFailure) throws Exception {
        return this.load(committedRecords, preparedTransactions, transactionFailure, true);
    }

    public synchronized JournalLoadInformation load(List<RecordInfo> committedRecords, List<PreparedTransactionInfo> preparedTransactions, TransactionFailureCallback failureCallback, boolean fixBadTX) throws Exception {
        JDBCJournalLoaderCallback lc = new JDBCJournalLoaderCallback(committedRecords, preparedTransactions, failureCallback, fixBadTX);
        return this.load(lc);
    }

    public int getAlignment() throws Exception {
        return 0;
    }

    public int getNumberOfRecords() {
        int count = 0;
        try (ResultSet rs = this.countJournalRecords.executeQuery();){
            rs.next();
            count = rs.getInt(1);
        }
        catch (SQLException e) {
            return -1;
        }
        return count;
    }

    public int getUserVersion() {
        return USER_VERSION;
    }

    public void perfBlast(int pages) {
    }

    public void runDirectJournalBlast() throws Exception {
    }

    public Map<Long, JournalFile> createFilesForBackupSync(long[] fileIds) throws Exception {
        return null;
    }

    public final void synchronizationLock() {
        logger.error((Object)"Replication is not supported with JDBC Store", (Throwable)new Exception("trace"));
    }

    public final void synchronizationUnlock() {
        logger.error((Object)"Replication is not supported with JDBC Store", (Throwable)new Exception("trace"));
    }

    public void forceMoveNextFile() throws Exception {
    }

    public JournalFile[] getDataFiles() {
        return new JournalFile[0];
    }

    public SequentialFileFactory getFileFactory() {
        return null;
    }

    public int getFileSize() {
        return 0;
    }

    public void scheduleCompactAndBlock(int timeout) throws Exception {
    }

    public void replicationSyncPreserveOldFiles() {
    }

    public void replicationSyncFinished() {
    }

    public boolean isStarted() {
        return this.started;
    }
}

