/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jdbc.store.drivers;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.activemq.artemis.jdbc.store.sql.SQLProvider;
import org.apache.activemq.artemis.journal.ActiveMQJournalLogger;
import org.jboss.logging.Logger;

public abstract class AbstractJDBCDriver {
    private static final Logger logger = Logger.getLogger(AbstractJDBCDriver.class);
    protected Connection connection;
    protected SQLProvider sqlProvider;
    private String jdbcConnectionUrl;
    private String jdbcDriverClass;
    private DataSource dataSource;

    public AbstractJDBCDriver() {
    }

    public AbstractJDBCDriver(SQLProvider sqlProvider, String jdbcConnectionUrl, String jdbcDriverClass) {
        this.jdbcConnectionUrl = jdbcConnectionUrl;
        this.jdbcDriverClass = jdbcDriverClass;
        this.sqlProvider = sqlProvider;
    }

    public AbstractJDBCDriver(DataSource dataSource, SQLProvider provider) {
        this.dataSource = dataSource;
        this.sqlProvider = provider;
    }

    public void start() throws Exception {
        this.connect();
        this.createSchema();
        this.prepareStatements();
    }

    public void stop() throws SQLException {
        if (this.sqlProvider.closeConnectionOnShutdown()) {
            this.connection.close();
        }
    }

    protected abstract void prepareStatements() throws SQLException;

    protected abstract void createSchema() throws SQLException;

    protected void createTable(String ... schemaSqls) throws SQLException {
        AbstractJDBCDriver.createTableIfNotExists(this.connection, this.sqlProvider.getTableName(), schemaSqls);
    }

    protected void connect() throws Exception {
        if (this.dataSource != null) {
            this.connection = this.dataSource.getConnection();
        } else {
            try {
                Driver dbDriver = this.getDriver(this.jdbcDriverClass);
                this.connection = dbDriver.connect(this.jdbcConnectionUrl, new Properties());
            }
            catch (SQLException e) {
                ActiveMQJournalLogger.LOGGER.error((Object)("Unable to connect to database using URL: " + this.jdbcConnectionUrl));
                throw new RuntimeException("Error connecting to database", e);
            }
        }
    }

    public void destroy() throws Exception {
        try {
            this.connection.setAutoCommit(false);
            try (Statement statement = this.connection.createStatement();){
                statement.executeUpdate("DROP TABLE " + this.sqlProvider.getTableName());
            }
            this.connection.commit();
        }
        catch (SQLException e) {
            this.connection.rollback();
            throw e;
        }
    }

    private static void createTableIfNotExists(Connection connection, String tableName, String ... sqls) throws SQLException {
        logger.tracef("Validating if table %s didn't exist before creating", (Object)tableName);
        try {
            block27: {
                connection.setAutoCommit(false);
                try (ResultSet rs = connection.getMetaData().getTables(null, null, tableName, null);){
                    if (rs == null || rs.next()) break block27;
                    logger.tracef("Table %s did not exist, creating it with SQL=%s", (Object)tableName, (Object)Arrays.toString(sqls));
                    try (Statement statement = connection.createStatement();){
                        for (String sql : sqls) {
                            statement.executeUpdate(sql);
                        }
                    }
                }
            }
            connection.commit();
        }
        catch (SQLException e) {
            connection.rollback();
        }
    }

    private Driver getDriver(String className) throws Exception {
        try {
            Driver driver = (Driver)Class.forName(className).newInstance();
            if (className.equals("org.apache.derby.jdbc.EmbeddedDriver")) {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        try {
                            DriverManager.getConnection("jdbc:derby:;shutdown=true");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
            return driver;
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("Could not find class: " + className);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate driver class: ", e);
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public void setSqlProvider(SQLProvider sqlProvider) {
        this.sqlProvider = sqlProvider;
    }

    public void setJdbcConnectionUrl(String jdbcConnectionUrl) {
        this.jdbcConnectionUrl = jdbcConnectionUrl;
    }

    public void setJdbcDriverClass(String jdbcDriverClass) {
        this.jdbcDriverClass = jdbcDriverClass;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

