/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jdbc.store.file;

import java.nio.ByteBuffer;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.activemq.artemis.jdbc.store.drivers.AbstractJDBCDriver;
import org.apache.activemq.artemis.jdbc.store.file.JDBCSequentialFile;
import org.apache.activemq.artemis.jdbc.store.sql.SQLProvider;

public class JDBCSequentialFileFactoryDriver
extends AbstractJDBCDriver {
    protected PreparedStatement deleteFile;
    PreparedStatement createFile;
    private PreparedStatement selectFileByFileName;
    private PreparedStatement copyFileRecord;
    private PreparedStatement renameFile;
    PreparedStatement readLargeObject;
    private PreparedStatement appendToLargeObject;
    private PreparedStatement selectFileNamesByExtension;

    JDBCSequentialFileFactoryDriver() {
    }

    JDBCSequentialFileFactoryDriver(DataSource dataSource, SQLProvider provider) {
        super(dataSource, provider);
    }

    @Override
    protected void createSchema() throws SQLException {
        this.createTable(this.sqlProvider.getCreateFileTableSQL());
    }

    @Override
    protected void prepareStatements() throws SQLException {
        this.deleteFile = this.connection.prepareStatement(this.sqlProvider.getDeleteFileSQL());
        this.createFile = this.connection.prepareStatement(this.sqlProvider.getInsertFileSQL(), 1);
        this.selectFileByFileName = this.connection.prepareStatement(this.sqlProvider.getSelectFileByFileName());
        this.copyFileRecord = this.connection.prepareStatement(this.sqlProvider.getCopyFileRecordByIdSQL());
        this.renameFile = this.connection.prepareStatement(this.sqlProvider.getUpdateFileNameByIdSQL());
        this.readLargeObject = this.connection.prepareStatement(this.sqlProvider.getReadLargeObjectSQL());
        this.appendToLargeObject = this.connection.prepareStatement(this.sqlProvider.getAppendToLargeObjectSQL());
        this.selectFileNamesByExtension = this.connection.prepareStatement(this.sqlProvider.getSelectFileNamesByExtensionSQL());
    }

    public synchronized List<String> listFiles(String extension) throws Exception {
        ArrayList<String> fileNames = new ArrayList<String>();
        try {
            this.connection.setAutoCommit(false);
            this.selectFileNamesByExtension.setString(1, extension);
            try (ResultSet rs = this.selectFileNamesByExtension.executeQuery();){
                while (rs.next()) {
                    fileNames.add(rs.getString(1));
                }
            }
            this.connection.commit();
        }
        catch (SQLException e) {
            this.connection.rollback();
            throw e;
        }
        return fileNames;
    }

    public void openFile(JDBCSequentialFile file) throws SQLException {
        int fileId = this.fileExists(file);
        if (fileId < 0) {
            this.createFile(file);
        } else {
            file.setId(fileId);
            this.loadFile(file);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int fileExists(JDBCSequentialFile file) throws SQLException {
        this.connection.setAutoCommit(false);
        this.selectFileByFileName.setString(1, file.getFileName());
        try (ResultSet rs = this.selectFileByFileName.executeQuery();){
            int id = rs.next() ? rs.getInt(1) : -1;
            this.connection.commit();
            int n = id;
            return n;
        }
        catch (Exception e) {
            this.connection.rollback();
            throw e;
        }
    }

    public synchronized void loadFile(JDBCSequentialFile file) throws SQLException {
        this.connection.setAutoCommit(false);
        this.readLargeObject.setInt(1, file.getId());
        try (ResultSet rs = this.readLargeObject.executeQuery();){
            if (rs.next()) {
                file.setWritePosition((int)rs.getBlob(1).length());
            }
            this.connection.commit();
        }
        catch (SQLException e) {
            this.connection.rollback();
            throw e;
        }
    }

    public synchronized void createFile(JDBCSequentialFile file) throws SQLException {
        try {
            this.connection.setAutoCommit(false);
            this.createFile.setString(1, file.getFileName());
            this.createFile.setString(2, file.getExtension());
            this.createFile.setBytes(3, new byte[0]);
            this.createFile.executeUpdate();
            try (ResultSet keys = this.createFile.getGeneratedKeys();){
                keys.next();
                file.setId(keys.getInt(1));
            }
            this.connection.commit();
        }
        catch (SQLException e) {
            this.connection.rollback();
            throw e;
        }
    }

    public synchronized void renameFile(JDBCSequentialFile file, String newFileName) throws SQLException {
        try {
            this.connection.setAutoCommit(false);
            this.renameFile.setString(1, newFileName);
            this.renameFile.setInt(2, file.getId());
            this.renameFile.executeUpdate();
            this.connection.commit();
        }
        catch (SQLException e) {
            this.connection.rollback();
            throw e;
        }
    }

    public synchronized void deleteFile(JDBCSequentialFile file) throws SQLException {
        try {
            this.connection.setAutoCommit(false);
            this.deleteFile.setInt(1, file.getId());
            this.deleteFile.executeUpdate();
            this.connection.commit();
        }
        catch (SQLException e) {
            this.connection.rollback();
            throw e;
        }
    }

    public synchronized int writeToFile(JDBCSequentialFile file, byte[] data) throws SQLException {
        try {
            this.connection.setAutoCommit(false);
            this.appendToLargeObject.setBytes(1, data);
            this.appendToLargeObject.setInt(2, file.getId());
            this.appendToLargeObject.executeUpdate();
            this.connection.commit();
            return data.length;
        }
        catch (SQLException e) {
            this.connection.rollback();
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int readFromFile(JDBCSequentialFile file, ByteBuffer bytes) throws SQLException {
        this.connection.setAutoCommit(false);
        this.readLargeObject.setInt(1, file.getId());
        int readLength = 0;
        try (ResultSet rs = this.readLargeObject.executeQuery();){
            if (rs.next()) {
                Blob blob = rs.getBlob(1);
                readLength = (int)this.calculateReadLength(blob.length(), bytes.remaining(), file.position());
                byte[] data = blob.getBytes(file.position() + 1L, readLength);
                bytes.put(data);
            }
            this.connection.commit();
            int n = readLength;
            return n;
        }
        catch (Throwable e) {
            this.connection.rollback();
            throw e;
        }
    }

    public synchronized void copyFileData(JDBCSequentialFile fileFrom, JDBCSequentialFile fileTo) throws SQLException {
        try {
            this.connection.setAutoCommit(false);
            this.copyFileRecord.setInt(1, fileFrom.getId());
            this.copyFileRecord.setInt(2, fileTo.getId());
            this.copyFileRecord.executeUpdate();
            this.connection.commit();
        }
        catch (SQLException e) {
            this.connection.rollback();
            throw e;
        }
    }

    @Override
    public synchronized void destroy() throws SQLException {
        try {
            this.connection.setAutoCommit(false);
            try (Statement statement = this.connection.createStatement();){
                statement.executeUpdate(this.sqlProvider.getDropFileTableSQL());
            }
            this.connection.commit();
        }
        catch (SQLException e) {
            this.connection.rollback();
            throw e;
        }
    }

    public long calculateReadLength(long objectLength, int bufferSpace, long readPosition) {
        long bytesRemaining = objectLength - readPosition;
        if (bytesRemaining > (long)bufferSpace) {
            return bufferSpace;
        }
        return bytesRemaining;
    }

    public int getMaxSize() {
        return this.sqlProvider.getMaxBlobSize();
    }
}

