/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jdbc.store.sql;

import org.apache.activemq.artemis.jdbc.store.sql.SQLProvider;

public class GenericSQLProvider
implements SQLProvider {
    private static final int MAX_BLOB_SIZE = 64512;
    protected final String tableName;
    private final String createFileTableSQL;
    private final String insertFileSQL;
    private final String selectFileNamesByExtensionSQL;
    private final String selectIdByFileNameSQL;
    private final String appendToFileSQL;
    private final String readLargeObjectSQL;
    private final String deleteFileSQL;
    private final String updateFileNameByIdSQL;
    private final String copyFileRecordByIdSQL;
    private final String cloneFileRecordSQL;
    private final String dropFileTableSQL;
    private final String[] createJournalTableSQL;
    private final String insertJournalRecordsSQL;
    private final String selectJournalRecordsSQL;
    private final String deleteJournalRecordsSQL;
    private final String deleteJournalTxRecordsSQL;
    private final String countJournalRecordsSQL;

    protected GenericSQLProvider(String tableName) {
        this.tableName = tableName;
        this.createFileTableSQL = "CREATE TABLE " + tableName + "(ID INT AUTO_INCREMENT, FILENAME VARCHAR(255), EXTENSION VARCHAR(10), DATA BLOB, PRIMARY KEY(ID))";
        this.insertFileSQL = "INSERT INTO " + tableName + " (FILENAME, EXTENSION, DATA) VALUES (?,?,?)";
        this.selectFileNamesByExtensionSQL = "SELECT FILENAME, ID FROM " + tableName + " WHERE EXTENSION=?";
        this.selectIdByFileNameSQL = "SELECT ID, FILENAME, EXTENSION, DATA FROM " + tableName + " WHERE fileName=?";
        this.appendToFileSQL = "UPDATE " + tableName + " SET DATA = CONCAT(DATA, ?) WHERE ID=?";
        this.readLargeObjectSQL = "SELECT DATA FROM " + tableName + " WHERE ID=?";
        this.deleteFileSQL = "DELETE FROM " + tableName + " WHERE ID=?";
        this.updateFileNameByIdSQL = "UPDATE " + tableName + " SET FILENAME=? WHERE ID=?";
        this.cloneFileRecordSQL = "INSERT INTO " + tableName + "(FILENAME, EXTENSION, DATA) " + "(SELECT FILENAME, EXTENSION, DATA FROM " + tableName + " WHERE ID=?)";
        this.copyFileRecordByIdSQL = "UPDATE " + tableName + " SET DATA = (SELECT DATA FROM " + tableName + " WHERE ID=?) WHERE ID=?";
        this.dropFileTableSQL = "DROP TABLE " + tableName;
        this.createJournalTableSQL = new String[]{"CREATE TABLE " + tableName + "(id BIGINT,recordType SMALLINT,compactCount SMALLINT,txId BIGINT,userRecordType SMALLINT,variableSize INTEGER,record BLOB,txDataSize INTEGER,txData BLOB,txCheckNoRecords INTEGER,seq BIGINT NOT NULL, PRIMARY KEY(seq))", "CREATE INDEX " + tableName + "_IDX ON " + tableName + " (id)"};
        this.insertJournalRecordsSQL = "INSERT INTO " + tableName + "(id,recordType,compactCount,txId,userRecordType,variableSize,record,txDataSize,txData,txCheckNoRecords,seq) " + "VALUES (?,?,?,?,?,?,?,?,?,?,?)";
        this.selectJournalRecordsSQL = "SELECT id,recordType,compactCount,txId,userRecordType,variableSize,record,txDataSize,txData,txCheckNoRecords,seq FROM " + tableName + " ORDER BY seq ASC";
        this.deleteJournalRecordsSQL = "DELETE FROM " + tableName + " WHERE id = ?";
        this.deleteJournalTxRecordsSQL = "DELETE FROM " + tableName + " WHERE txId=?";
        this.countJournalRecordsSQL = "SELECT COUNT(*) FROM " + tableName;
    }

    @Override
    public int getMaxBlobSize() {
        return 64512;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public String[] getCreateJournalTableSQL() {
        return this.createJournalTableSQL;
    }

    @Override
    public String getInsertJournalRecordsSQL() {
        return this.insertJournalRecordsSQL;
    }

    @Override
    public String getSelectJournalRecordsSQL() {
        return this.selectJournalRecordsSQL;
    }

    @Override
    public String getDeleteJournalRecordsSQL() {
        return this.deleteJournalRecordsSQL;
    }

    @Override
    public String getDeleteJournalTxRecordsSQL() {
        return this.deleteJournalTxRecordsSQL;
    }

    @Override
    public String getCountJournalRecordsSQL() {
        return this.countJournalRecordsSQL;
    }

    @Override
    public String getCreateFileTableSQL() {
        return this.createFileTableSQL;
    }

    @Override
    public String getInsertFileSQL() {
        return this.insertFileSQL;
    }

    @Override
    public String getSelectFileByFileName() {
        return this.selectIdByFileNameSQL;
    }

    @Override
    public String getSelectFileNamesByExtensionSQL() {
        return this.selectFileNamesByExtensionSQL;
    }

    @Override
    public String getAppendToLargeObjectSQL() {
        return this.appendToFileSQL;
    }

    @Override
    public String getReadLargeObjectSQL() {
        return this.readLargeObjectSQL;
    }

    @Override
    public String getDeleteFileSQL() {
        return this.deleteFileSQL;
    }

    @Override
    public String getUpdateFileNameByIdSQL() {
        return this.updateFileNameByIdSQL;
    }

    @Override
    public String getCopyFileRecordByIdSQL() {
        return this.copyFileRecordByIdSQL;
    }

    @Override
    public String getCloneFileRecordByIdSQL() {
        return this.cloneFileRecordSQL;
    }

    @Override
    public String getDropFileTableSQL() {
        return this.dropFileTableSQL;
    }

    @Override
    public boolean closeConnectionOnShutdown() {
        return true;
    }

    public static class Factory
    implements SQLProvider.Factory {
        @Override
        public SQLProvider create(String tableName) {
            return new GenericSQLProvider(tableName);
        }
    }
}

