/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jdbc.store.drivers;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.apache.activemq.artemis.jdbc.store.drivers.JDBCUtils;
import org.apache.activemq.artemis.jdbc.store.logging.LoggingConnection;
import org.apache.activemq.artemis.jdbc.store.sql.SQLProvider;
import org.apache.activemq.artemis.journal.ActiveMQJournalLogger;
import org.jboss.logging.Logger;

public abstract class AbstractJDBCDriver {
    private static final Logger logger = Logger.getLogger(AbstractJDBCDriver.class);
    protected Connection connection;
    protected SQLProvider sqlProvider;
    private String jdbcConnectionUrl;
    private String jdbcDriverClass;
    private DataSource dataSource;
    private Executor networkTimeoutExecutor;
    private int networkTimeoutMillis;
    private String user;
    private String password;
    private static AtomicBoolean shutAdded = new AtomicBoolean(false);

    public AbstractJDBCDriver() {
        this.networkTimeoutExecutor = null;
        this.networkTimeoutMillis = -1;
    }

    public AbstractJDBCDriver(SQLProvider sqlProvider, String jdbcConnectionUrl, String user, String password, String jdbcDriverClass) {
        this.jdbcConnectionUrl = jdbcConnectionUrl;
        this.user = user;
        this.password = password;
        this.jdbcDriverClass = jdbcDriverClass;
        this.sqlProvider = sqlProvider;
        this.networkTimeoutExecutor = null;
        this.networkTimeoutMillis = -1;
    }

    public AbstractJDBCDriver(DataSource dataSource, SQLProvider provider) {
        this.dataSource = dataSource;
        this.sqlProvider = provider;
        this.networkTimeoutExecutor = null;
        this.networkTimeoutMillis = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws SQLException {
        this.connect();
        Connection connection = this.connection;
        synchronized (connection) {
            this.createSchema();
            this.prepareStatements();
        }
    }

    public AbstractJDBCDriver(Connection connection, SQLProvider sqlProvider) {
        this.connection = logger.isTraceEnabled() && !(connection instanceof LoggingConnection) ? new LoggingConnection(connection, logger) : connection;
        this.sqlProvider = sqlProvider;
        this.networkTimeoutExecutor = null;
        this.networkTimeoutMillis = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws SQLException {
        Connection connection = this.connection;
        synchronized (connection) {
            if (this.sqlProvider.closeConnectionOnShutdown()) {
                try {
                    this.connection.setAutoCommit(true);
                    this.connection.close();
                }
                catch (SQLException e) {
                    logger.error((Object)JDBCUtils.appendSQLExceptionDetails(new StringBuilder(), e));
                    throw e;
                }
            }
        }
    }

    protected abstract void prepareStatements() throws SQLException;

    protected abstract void createSchema() throws SQLException;

    protected final void createTable(String ... schemaSqls) throws SQLException {
        this.createTableIfNotExists(this.sqlProvider.getTableName(), schemaSqls);
    }

    /*
     * Unable to fully structure code
     */
    private void connect() throws SQLException {
        if (this.connection == null) {
            if (this.dataSource != null) {
                try {
                    this.connection = this.dataSource.getConnection();
                    if (!AbstractJDBCDriver.logger.isTraceEnabled() || this.connection instanceof LoggingConnection) ** GOTO lbl33
                    this.connection = new LoggingConnection(this.connection, AbstractJDBCDriver.logger);
                }
                catch (SQLException e) {
                    AbstractJDBCDriver.logger.error((Object)JDBCUtils.appendSQLExceptionDetails(new StringBuilder(), e));
                    throw e;
                }
            } else {
                try {
                    if (this.jdbcDriverClass == null || this.jdbcDriverClass.isEmpty()) {
                        throw new IllegalStateException("jdbcDriverClass is null or empty!");
                    }
                    if (this.jdbcConnectionUrl == null || this.jdbcConnectionUrl.isEmpty()) {
                        throw new IllegalStateException("jdbcConnectionUrl is null or empty!");
                    }
                    dbDriver = this.getDriver(this.jdbcDriverClass);
                    properties = new Properties();
                    if (this.user != null) {
                        properties.setProperty("user", this.user);
                        properties.setProperty("password", this.password);
                    }
                    this.connection = dbDriver.connect(this.jdbcConnectionUrl, properties);
                    if (AbstractJDBCDriver.logger.isTraceEnabled() && !(this.connection instanceof LoggingConnection)) {
                        this.connection = new LoggingConnection(this.connection, AbstractJDBCDriver.logger);
                    }
                    if (this.connection == null) {
                        throw new IllegalStateException("the driver: " + this.jdbcDriverClass + " isn't able to connect to the requested url: " + this.jdbcConnectionUrl);
                    }
                }
                catch (SQLException e) {
                    AbstractJDBCDriver.logger.error((Object)JDBCUtils.appendSQLExceptionDetails(new StringBuilder(), e));
                    ActiveMQJournalLogger.LOGGER.error((Object)("Unable to connect to database using URL: " + this.jdbcConnectionUrl));
                    throw e;
                }
            }
lbl33:
            // 3 sources

            if (this.networkTimeoutMillis >= 0 && this.networkTimeoutExecutor == null) {
                AbstractJDBCDriver.logger.warn((Object)"Unable to set a network timeout on the JDBC connection: networkTimeoutExecutor is null");
            }
            if (this.networkTimeoutMillis >= 0 && this.networkTimeoutExecutor != null) {
                try {
                    this.connection.setNetworkTimeout(this.networkTimeoutExecutor, this.networkTimeoutMillis);
                }
                catch (SQLException e) {
                    AbstractJDBCDriver.logger.warn((Object)JDBCUtils.appendSQLExceptionDetails(new StringBuilder(), e));
                    ActiveMQJournalLogger.LOGGER.warn((Object)"Unable to set a network timeout on the JDBC connection");
                }
                catch (Throwable throwable) {
                    AbstractJDBCDriver.logger.warn((Object)"Unable to set a network timeout on the JDBC connection", throwable);
                }
            }
        }
    }

    public void destroy() throws Exception {
        String dropTableSql = "DROP TABLE " + this.sqlProvider.getTableName();
        try {
            this.connection.setAutoCommit(false);
            try (Statement statement = this.connection.createStatement();){
                statement.executeUpdate(dropTableSql);
            }
            this.connection.commit();
        }
        catch (SQLException e) {
            logger.error((Object)JDBCUtils.appendSQLExceptionDetails(new StringBuilder(), e, dropTableSql));
            try {
                this.connection.rollback();
            }
            catch (SQLException rollbackEx) {
                logger.error((Object)JDBCUtils.appendSQLExceptionDetails(new StringBuilder(), rollbackEx, dropTableSql));
                throw rollbackEx;
            }
            throw e;
        }
    }

    private void createTableIfNotExists(String tableName, String ... sqls) throws SQLException {
        block75: {
            logger.tracef("Validating if table %s didn't exist before creating", (Object)tableName);
            try {
                Statement statement;
                boolean tableExists;
                this.connection.setAutoCommit(false);
                try (ResultSet rs = this.connection.getMetaData().getTables(null, null, tableName, null);){
                    if (rs == null || !rs.next()) {
                        SQLWarning sqlWarning;
                        tableExists = false;
                        if (logger.isTraceEnabled()) {
                            logger.tracef("Table %s did not exist, creating it with SQL=%s", (Object)tableName, (Object)Arrays.toString(sqls));
                        }
                        if (rs != null && (sqlWarning = rs.getWarnings()) != null) {
                            logger.warn((Object)JDBCUtils.appendSQLExceptionDetails(new StringBuilder(), sqlWarning));
                        }
                    } else {
                        tableExists = true;
                    }
                }
                if (tableExists) {
                    logger.tracef("Validating if the existing table %s is initialized or not", (Object)tableName);
                    try {
                        statement = this.connection.createStatement();
                        var5_6 = null;
                        try (ResultSet cntRs = statement.executeQuery(this.sqlProvider.getCountJournalRecordsSQL());){
                            int rows;
                            logger.tracef("Validation of the existing table %s initialization is started", (Object)tableName);
                            if (cntRs.next() && (rows = cntRs.getInt(1)) > 0) {
                                long expectedRows;
                                logger.tracef("Table %s did exist but is not empty. Skipping initialization. Found %d rows.", (Object)tableName, (Object)rows);
                                if (logger.isDebugEnabled() && (long)rows < (expectedRows = Stream.of(sqls).map(String::toUpperCase).filter(sql -> sql.contains("INSERT INTO")).count())) {
                                    logger.debug((Object)("Table " + tableName + " was expected to contain " + expectedRows + " rows while it has " + rows + " rows."));
                                }
                                this.connection.commit();
                                return;
                            }
                            if ((sqls = (String[])Stream.of(sqls).filter(sql -> {
                                String upperCaseSql = sql.toUpperCase();
                                return !upperCaseSql.contains("CREATE TABLE") && !upperCaseSql.contains("CREATE INDEX");
                            }).toArray(String[]::new)).length > 0) {
                                logger.tracef("Table %s did exist but is empty. Starting initialization.", (Object)tableName);
                            } else {
                                logger.tracef("Table %s did exist but is empty. Initialization completed: no initialization statements left.", (Object)tableName);
                            }
                        }
                        catch (Throwable throwable) {
                            var5_6 = throwable;
                            throw throwable;
                        }
                        finally {
                            if (statement != null) {
                                if (var5_6 != null) {
                                    try {
                                        statement.close();
                                    }
                                    catch (Throwable expectedRows) {
                                        var5_6.addSuppressed(expectedRows);
                                    }
                                } else {
                                    statement.close();
                                }
                            }
                        }
                    }
                    catch (SQLException e) {
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)JDBCUtils.appendSQLExceptionDetails(new StringBuilder("Can't verify the initialization of table ").append(tableName).append(" due to:"), e, this.sqlProvider.getCountJournalRecordsSQL()));
                        }
                        try {
                            this.connection.rollback();
                        }
                        catch (SQLException rollbackEx) {
                            logger.debug((Object)"Rollback failed while validating initialization of a table", (Throwable)rollbackEx);
                        }
                        this.connection.setAutoCommit(false);
                        logger.tracef("Table %s seems to exist, but we can't verify the initialization. Keep trying to create and initialize.", (Object)tableName);
                    }
                }
                if (sqls.length <= 0) break block75;
                statement = this.connection.createStatement();
                Throwable rollbackEx = null;
                try {
                    for (String sql2 : sqls) {
                        statement.executeUpdate(sql2);
                        SQLWarning statementSqlWarning = statement.getWarnings();
                        if (statementSqlWarning == null) continue;
                        logger.warn((Object)JDBCUtils.appendSQLExceptionDetails(new StringBuilder(), statementSqlWarning, sql2));
                    }
                }
                catch (Throwable throwable) {
                    rollbackEx = throwable;
                    throw throwable;
                }
                finally {
                    if (statement != null) {
                        if (rollbackEx != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable) {
                                rollbackEx.addSuppressed(throwable);
                            }
                        } else {
                            statement.close();
                        }
                    }
                }
                this.connection.commit();
            }
            catch (SQLException e) {
                String sqlStatements = String.join((CharSequence)"\n", sqls);
                logger.error((Object)JDBCUtils.appendSQLExceptionDetails(new StringBuilder(), e, sqlStatements));
                try {
                    this.connection.rollback();
                }
                catch (SQLException rollbackEx) {
                    logger.error((Object)JDBCUtils.appendSQLExceptionDetails(new StringBuilder(), rollbackEx, sqlStatements));
                    throw rollbackEx;
                }
                throw e;
            }
        }
    }

    private Driver getDriver(String className) {
        try {
            Driver driver = (Driver)Class.forName(className).newInstance();
            if (className.equals("org.apache.derby.jdbc.EmbeddedDriver") && shutAdded.compareAndSet(false, true)) {
                Runtime.getRuntime().addShutdownHook(new ShutdownDerby());
            }
            return driver;
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("Could not find class: " + className);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate driver class: ", e);
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public final void setConnection(Connection connection) {
        if (this.connection == null) {
            this.connection = logger.isTraceEnabled() && !(connection instanceof LoggingConnection) ? new LoggingConnection(connection, logger) : connection;
        }
    }

    public void setSqlProvider(SQLProvider sqlProvider) {
        this.sqlProvider = sqlProvider;
    }

    public void setJdbcConnectionUrl(String jdbcConnectionUrl) {
        this.jdbcConnectionUrl = jdbcConnectionUrl;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setJdbcDriverClass(String jdbcDriverClass) {
        this.jdbcDriverClass = jdbcDriverClass;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setNetworkTimeout(Executor executor, int milliseconds) {
        this.networkTimeoutExecutor = executor;
        this.networkTimeoutMillis = milliseconds;
    }

    private static class ShutdownDerby
    extends Thread {
        private ShutdownDerby() {
        }

        @Override
        public void run() {
            try {
                DriverManager.getConnection("jdbc:derby:;shutdown=true");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

