/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jdbc.store.sql;

import org.apache.activemq.artemis.jdbc.store.sql.SQLProvider;

public class GenericSQLProvider
implements SQLProvider {
    private static final int STATE_ROW_ID = 0;
    private static final int LIVE_LOCK_ROW_ID = 1;
    private static final int BACKUP_LOCK_ROW_ID = 2;
    private static final int NODE_ID_ROW_ID = 3;
    private static final long MAX_BLOB_SIZE = 64512L;
    protected final String tableName;
    private final String createFileTableSQL;
    private final String insertFileSQL;
    private final String selectFileNamesByExtensionSQL;
    private final String selectIdByFileNameSQL;
    private final String appendToFileSQL;
    private final String readLargeObjectSQL;
    private final String deleteFileSQL;
    private final String updateFileNameByIdSQL;
    private final String copyFileRecordByIdSQL;
    private final String cloneFileRecordSQL;
    private final String dropFileTableSQL;
    private final String[] createJournalTableSQL;
    private final String insertJournalRecordsSQL;
    private final String selectJournalRecordsSQL;
    private final String deleteJournalRecordsSQL;
    private final String deleteJournalTxRecordsSQL;
    private final String countJournalRecordsSQL;
    private final String createNodeManagerStoreTableSQL;
    private final String createStateSQL;
    private final String createNodeIdSQL;
    private final String createLiveLockSQL;
    private final String createBackupLockSQL;
    private final String tryAcquireLiveLockSQL;
    private final String tryAcquireBackupLockSQL;
    private final String tryReleaseLiveLockSQL;
    private final String tryReleaseBackupLockSQL;
    private final String isLiveLockedSQL;
    private final String isBackupLockedSQL;
    private final String renewLiveLockSQL;
    private final String renewBackupLockSQL;
    private final String currentTimestampSQL;
    private final String writeStateSQL;
    private final String readStateSQL;
    private final String writeNodeIdSQL;
    private final String readNodeIdSQL;
    protected final SQLProvider.DatabaseStoreType databaseStoreType;

    protected GenericSQLProvider(String tableName, SQLProvider.DatabaseStoreType databaseStoreType) {
        this.tableName = tableName;
        this.databaseStoreType = databaseStoreType;
        this.createFileTableSQL = "CREATE TABLE " + tableName + "(ID BIGINT AUTO_INCREMENT, FILENAME VARCHAR(255), EXTENSION VARCHAR(10), DATA BLOB, PRIMARY KEY(ID))";
        this.insertFileSQL = "INSERT INTO " + tableName + " (FILENAME, EXTENSION, DATA) VALUES (?,?,?)";
        this.selectFileNamesByExtensionSQL = "SELECT FILENAME, ID FROM " + tableName + " WHERE EXTENSION=?";
        this.selectIdByFileNameSQL = "SELECT ID, FILENAME, EXTENSION, DATA FROM " + tableName + " WHERE fileName=?";
        this.appendToFileSQL = "SELECT DATA FROM " + tableName + " WHERE ID=? FOR UPDATE";
        this.readLargeObjectSQL = "SELECT DATA FROM " + tableName + " WHERE ID=?";
        this.deleteFileSQL = "DELETE FROM " + tableName + " WHERE ID=?";
        this.updateFileNameByIdSQL = "UPDATE " + tableName + " SET FILENAME=? WHERE ID=?";
        this.cloneFileRecordSQL = "INSERT INTO " + tableName + "(FILENAME, EXTENSION, DATA) " + "(SELECT FILENAME, EXTENSION, DATA FROM " + tableName + " WHERE ID=?)";
        this.copyFileRecordByIdSQL = "UPDATE " + tableName + " SET DATA = (SELECT DATA FROM " + tableName + " WHERE ID=?) WHERE ID=?";
        this.dropFileTableSQL = "DROP TABLE " + tableName;
        this.createJournalTableSQL = new String[]{"CREATE TABLE " + tableName + "(id BIGINT,recordType SMALLINT,compactCount SMALLINT,txId BIGINT,userRecordType SMALLINT,variableSize INTEGER,record BLOB,txDataSize INTEGER,txData BLOB,txCheckNoRecords INTEGER,seq BIGINT NOT NULL, PRIMARY KEY(seq))", "CREATE INDEX " + tableName + "_IDX ON " + tableName + " (id)"};
        this.insertJournalRecordsSQL = "INSERT INTO " + tableName + "(id,recordType,compactCount,txId,userRecordType,variableSize,record,txDataSize,txData,txCheckNoRecords,seq) " + "VALUES (?,?,?,?,?,?,?,?,?,?,?)";
        this.selectJournalRecordsSQL = "SELECT id,recordType,compactCount,txId,userRecordType,variableSize,record,txDataSize,txData,txCheckNoRecords,seq FROM " + tableName + " ORDER BY seq ASC";
        this.deleteJournalRecordsSQL = "DELETE FROM " + tableName + " WHERE id = ?";
        this.deleteJournalTxRecordsSQL = "DELETE FROM " + tableName + " WHERE txId=?";
        this.countJournalRecordsSQL = "SELECT COUNT(*) FROM " + tableName;
        this.createNodeManagerStoreTableSQL = "CREATE TABLE " + tableName + " ( ID INT NOT NULL, HOLDER_ID VARCHAR(128), HOLDER_EXPIRATION_TIME TIMESTAMP, NODE_ID CHAR(36),STATE CHAR(1), PRIMARY KEY(ID))";
        this.createStateSQL = "INSERT INTO " + tableName + " (ID) VALUES (" + 0 + ")";
        this.createNodeIdSQL = "INSERT INTO " + tableName + " (ID) VALUES (" + 3 + ")";
        this.createLiveLockSQL = "INSERT INTO " + tableName + " (ID) VALUES (" + 1 + ")";
        this.createBackupLockSQL = "INSERT INTO " + tableName + " (ID) VALUES (" + 2 + ")";
        this.tryAcquireLiveLockSQL = "UPDATE " + tableName + " SET HOLDER_ID = ?, HOLDER_EXPIRATION_TIME = ? WHERE (HOLDER_EXPIRATION_TIME IS NULL OR HOLDER_EXPIRATION_TIME < CURRENT_TIMESTAMP) AND ID = " + 1;
        this.tryAcquireBackupLockSQL = "UPDATE " + tableName + " SET HOLDER_ID = ?, HOLDER_EXPIRATION_TIME = ? WHERE (HOLDER_EXPIRATION_TIME IS NULL OR HOLDER_EXPIRATION_TIME < CURRENT_TIMESTAMP) AND ID = " + 2;
        this.tryReleaseLiveLockSQL = "UPDATE " + tableName + " SET HOLDER_ID = NULL, HOLDER_EXPIRATION_TIME = NULL WHERE HOLDER_ID = ? AND ID = " + 1;
        this.tryReleaseBackupLockSQL = "UPDATE " + tableName + " SET HOLDER_ID = NULL, HOLDER_EXPIRATION_TIME = NULL WHERE HOLDER_ID = ? AND ID = " + 2;
        this.isLiveLockedSQL = "SELECT HOLDER_ID, HOLDER_EXPIRATION_TIME FROM " + tableName + " WHERE ID = " + 1;
        this.isBackupLockedSQL = "SELECT HOLDER_ID, HOLDER_EXPIRATION_TIME FROM " + tableName + " WHERE ID = " + 2;
        this.renewLiveLockSQL = "UPDATE " + tableName + " SET HOLDER_EXPIRATION_TIME = ? WHERE HOLDER_ID = ? AND ID = " + 1;
        this.renewBackupLockSQL = "UPDATE " + tableName + " SET HOLDER_EXPIRATION_TIME = ? WHERE HOLDER_ID = ? AND ID = " + 2;
        this.currentTimestampSQL = "SELECT CURRENT_TIMESTAMP FROM " + tableName;
        this.writeStateSQL = "UPDATE " + tableName + " SET STATE = ? WHERE ID = " + 0;
        this.readStateSQL = "SELECT STATE FROM " + tableName + " WHERE ID = " + 0;
        this.writeNodeIdSQL = "UPDATE " + tableName + " SET NODE_ID = ? WHERE ID = " + 3;
        this.readNodeIdSQL = "SELECT NODE_ID FROM " + tableName + " WHERE ID = " + 3;
    }

    @Override
    public long getMaxBlobSize() {
        return 64512L;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public String[] getCreateJournalTableSQL() {
        return this.createJournalTableSQL;
    }

    @Override
    public String getInsertJournalRecordsSQL() {
        return this.insertJournalRecordsSQL;
    }

    @Override
    public String getSelectJournalRecordsSQL() {
        return this.selectJournalRecordsSQL;
    }

    @Override
    public String getDeleteJournalRecordsSQL() {
        return this.deleteJournalRecordsSQL;
    }

    @Override
    public String getDeleteJournalTxRecordsSQL() {
        return this.deleteJournalTxRecordsSQL;
    }

    @Override
    public String getCountJournalRecordsSQL() {
        return this.countJournalRecordsSQL;
    }

    @Override
    public String getCreateFileTableSQL() {
        return this.createFileTableSQL;
    }

    @Override
    public String getInsertFileSQL() {
        return this.insertFileSQL;
    }

    @Override
    public String getSelectFileByFileName() {
        return this.selectIdByFileNameSQL;
    }

    @Override
    public String getSelectFileNamesByExtensionSQL() {
        return this.selectFileNamesByExtensionSQL;
    }

    @Override
    public String getAppendToLargeObjectSQL() {
        return this.appendToFileSQL;
    }

    @Override
    public String getReadLargeObjectSQL() {
        return this.readLargeObjectSQL;
    }

    @Override
    public String getDeleteFileSQL() {
        return this.deleteFileSQL;
    }

    @Override
    public String getUpdateFileNameByIdSQL() {
        return this.updateFileNameByIdSQL;
    }

    @Override
    public String getCopyFileRecordByIdSQL() {
        return this.copyFileRecordByIdSQL;
    }

    @Override
    public String getCloneFileRecordByIdSQL() {
        return this.cloneFileRecordSQL;
    }

    @Override
    public String getDropFileTableSQL() {
        return this.dropFileTableSQL;
    }

    @Override
    public String createNodeManagerStoreTableSQL() {
        return this.createNodeManagerStoreTableSQL;
    }

    @Override
    public String createStateSQL() {
        return this.createStateSQL;
    }

    @Override
    public String createNodeIdSQL() {
        return this.createNodeIdSQL;
    }

    @Override
    public String createLiveLockSQL() {
        return this.createLiveLockSQL;
    }

    @Override
    public String createBackupLockSQL() {
        return this.createBackupLockSQL;
    }

    @Override
    public String tryAcquireLiveLockSQL() {
        return this.tryAcquireLiveLockSQL;
    }

    @Override
    public String tryAcquireBackupLockSQL() {
        return this.tryAcquireBackupLockSQL;
    }

    @Override
    public String tryReleaseLiveLockSQL() {
        return this.tryReleaseLiveLockSQL;
    }

    @Override
    public String tryReleaseBackupLockSQL() {
        return this.tryReleaseBackupLockSQL;
    }

    @Override
    public String isLiveLockedSQL() {
        return this.isLiveLockedSQL;
    }

    @Override
    public String isBackupLockedSQL() {
        return this.isBackupLockedSQL;
    }

    @Override
    public String renewLiveLockSQL() {
        return this.renewLiveLockSQL;
    }

    @Override
    public String renewBackupLockSQL() {
        return this.renewBackupLockSQL;
    }

    @Override
    public String currentTimestampSQL() {
        return this.currentTimestampSQL;
    }

    @Override
    public String writeStateSQL() {
        return this.writeStateSQL;
    }

    @Override
    public String readStateSQL() {
        return this.readStateSQL;
    }

    @Override
    public String writeNodeIdSQL() {
        return this.writeNodeIdSQL;
    }

    @Override
    public String readNodeIdSQL() {
        return this.readNodeIdSQL;
    }

    @Override
    public boolean closeConnectionOnShutdown() {
        return true;
    }

    public static class Factory
    implements SQLProvider.Factory {
        @Override
        public SQLProvider create(String tableName, SQLProvider.DatabaseStoreType storeType) {
            return new GenericSQLProvider(tableName, storeType);
        }
    }
}

