/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.blocks.cs;

import org.apache.activemq.artemis.shaded.org.jgroups.Address;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.cs.BaseServer;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.cs.TcpConnection;
import org.apache.activemq.artemis.shaded.org.jgroups.util.DefaultSocketFactory;
import org.apache.activemq.artemis.shaded.org.jgroups.util.SocketFactory;
import org.apache.activemq.artemis.shaded.org.jgroups.util.ThreadFactory;

public abstract class TcpBaseServer
extends BaseServer {
    protected SocketFactory socket_factory = new DefaultSocketFactory();
    protected volatile boolean use_send_queues = true;
    protected int send_queue_size = 2000;
    protected int peer_addr_read_timeout = 2000;

    protected TcpBaseServer(ThreadFactory f) {
        super(f);
    }

    @Override
    protected TcpConnection createConnection(Address dest) throws Exception {
        return new TcpConnection(dest, this);
    }

    public int peerAddressReadTimeout() {
        return this.peer_addr_read_timeout;
    }

    public TcpBaseServer peerAddressReadTimeout(int timeout) {
        this.peer_addr_read_timeout = timeout;
        return this;
    }

    public int sendQueueSize() {
        return this.send_queue_size;
    }

    public TcpBaseServer sendQueueSize(int send_queue_size) {
        this.send_queue_size = send_queue_size;
        return this;
    }

    public boolean useSendQueues() {
        return this.use_send_queues;
    }

    public TcpBaseServer useSendQueues(boolean flag) {
        this.use_send_queues = flag;
        return this;
    }

    public SocketFactory socketFactory() {
        return this.socket_factory;
    }

    public TcpBaseServer socketFactory(SocketFactory factory) {
        this.socket_factory = factory;
        return this;
    }
}

