/*
 * JBoss, Home of Professional Open Source.
 *
 * Copyright 2010 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.activemq.artemis.shaded.org.jboss.logging;

import java.io.Serializable;

final class SerializedLogger implements Serializable {

    private static final long serialVersionUID = 508779982439435831L;

    private final String name;

    SerializedLogger(final String name) {
        this.name = name;
    }

    protected Object readResolve() {
        return Logger.getLogger(name);
    }
}
