/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.core.management;

import javax.json.JsonObject;
import org.apache.activemq.artemis.api.core.JsonUtil;

public final class AddressSettingsInfo {
    private final String addressFullMessagePolicy;
    private final long maxSizeBytes;
    private final int pageSizeBytes;
    private int pageCacheMaxSize;
    private final int maxDeliveryAttempts;
    private final double redeliveryMultiplier;
    private final long maxRedeliveryDelay;
    private final long redeliveryDelay;
    private final String deadLetterAddress;
    private final String expiryAddress;
    private final boolean lastValueQueue;
    private final long redistributionDelay;
    private final boolean sendToDLAOnNoRoute;
    private final long slowConsumerThreshold;
    private final long slowConsumerCheckPeriod;
    private final String slowConsumerPolicy;
    private final boolean autoCreateJmsQueues;
    private final boolean autoDeleteJmsQueues;
    private final boolean autoCreateJmsTopics;
    private final boolean autoDeleteJmsTopics;
    private final boolean autoCreateQueues;
    private final boolean autoDeleteQueues;
    private final boolean autoCreateAddresses;
    private final boolean autoDeleteAddresses;
    private final String configDeleteQueues;
    private final String configDeleteAddresses;
    private final long maxSizeBytesRejectThreshold;
    private final String defaultLastValueKey;
    private final boolean defaultNonDestructive;
    private final boolean defaultExclusiveQueue;
    private final boolean defaultGroupRebalance;
    private final int defaultGroupBuckets;
    private final String defaultGroupFirstKey;
    private final int defaultMaxConsumers;
    private final boolean defaultPurgeOnNoConsumers;
    private final int defaultConsumersBeforeDispatch;
    private final long defaultDelayBeforeDispatch;
    private final String defaultQueueRoutingType;
    private final String defaultAddressRoutingType;
    private final int defaultConsumerWindowSize;
    private final long defaultRingSize;
    private final boolean autoDeleteCreatedQueues;
    private final long autoDeleteQueuesDelay;
    private final long autoDeleteQueuesMessageCount;
    private final long autoDeleteAddressesDelay;
    private final double redeliveryCollisionAvoidanceFactor;
    private final long retroactiveMessageCount;

    public static AddressSettingsInfo from(String jsonString) {
        JsonObject object = JsonUtil.readJsonObject(jsonString);
        return new AddressSettingsInfo(object.getString("addressFullMessagePolicy"), object.getJsonNumber("maxSizeBytes").longValue(), object.getInt("pageSizeBytes"), object.getInt("pageCacheMaxSize"), object.getInt("maxDeliveryAttempts"), object.getJsonNumber("redeliveryDelay").longValue(), object.getJsonNumber("redeliveryMultiplier").doubleValue(), object.getJsonNumber("maxRedeliveryDelay").longValue(), object.getString("DLA"), object.getString("expiryAddress"), object.getBoolean("lastValueQueue"), object.getJsonNumber("redistributionDelay").longValue(), object.getBoolean("sendToDLAOnNoRoute"), object.getJsonNumber("slowConsumerThreshold").longValue(), object.getJsonNumber("slowConsumerCheckPeriod").longValue(), object.getString("slowConsumerPolicy"), object.getBoolean("autoCreateJmsQueues"), object.getBoolean("autoCreateJmsTopics"), object.getBoolean("autoDeleteJmsQueues"), object.getBoolean("autoDeleteJmsTopics"), object.getBoolean("autoCreateQueues"), object.getBoolean("autoDeleteQueues"), object.getBoolean("autoCreateAddresses"), object.getBoolean("autoDeleteAddresses"), object.getString("configDeleteQueues"), object.getString("configDeleteAddresses"), object.getJsonNumber("maxSizeBytesRejectThreshold").longValue(), object.getString("defaultLastValueKey"), object.getBoolean("defaultNonDestructive"), object.getBoolean("defaultExclusiveQueue"), object.getBoolean("defaultGroupRebalance"), object.getInt("defaultGroupBuckets"), object.getString("defaultGroupFirstKey"), object.getInt("defaultMaxConsumers"), object.getBoolean("defaultPurgeOnNoConsumers"), object.getInt("defaultConsumersBeforeDispatch"), object.getJsonNumber("defaultDelayBeforeDispatch").longValue(), object.getString("defaultQueueRoutingType"), object.getString("defaultAddressRoutingType"), object.getInt("defaultConsumerWindowSize"), object.getJsonNumber("defaultRingSize").longValue(), object.getBoolean("autoDeleteCreatedQueues"), object.getJsonNumber("autoDeleteQueuesDelay").longValue(), object.getJsonNumber("autoDeleteQueuesMessageCount").longValue(), object.getJsonNumber("autoDeleteAddressesDelay").longValue(), object.getJsonNumber("redeliveryCollisionAvoidanceFactor").doubleValue(), object.getJsonNumber("retroactiveMessageCount").longValue());
    }

    public AddressSettingsInfo(String addressFullMessagePolicy, long maxSizeBytes, int pageSizeBytes, int pageCacheMaxSize, int maxDeliveryAttempts, long redeliveryDelay, double redeliveryMultiplier, long maxRedeliveryDelay, String deadLetterAddress, String expiryAddress, boolean lastValueQueue, long redistributionDelay, boolean sendToDLAOnNoRoute, long slowConsumerThreshold, long slowConsumerCheckPeriod, String slowConsumerPolicy, boolean autoCreateJmsQueues, boolean autoCreateJmsTopics, boolean autoDeleteJmsQueues, boolean autoDeleteJmsTopics, boolean autoCreateQueues, boolean autoDeleteQueues, boolean autoCreateAddresses, boolean autoDeleteAddresses, String configDeleteQueues, String configDeleteAddresses, long maxSizeBytesRejectThreshold, String defaultLastValueKey, boolean defaultNonDestructive, boolean defaultExclusiveQueue, boolean defaultGroupRebalance, int defaultGroupBuckets, String defaultGroupFirstKey, int defaultMaxConsumers, boolean defaultPurgeOnNoConsumers, int defaultConsumersBeforeDispatch, long defaultDelayBeforeDispatch, String defaultQueueRoutingType, String defaultAddressRoutingType, int defaultConsumerWindowSize, long defaultRingSize, boolean autoDeleteCreatedQueues, long autoDeleteQueuesDelay, long autoDeleteQueuesMessageCount, long autoDeleteAddressesDelay, double redeliveryCollisionAvoidanceFactor, long retroactiveMessageCount) {
        this.addressFullMessagePolicy = addressFullMessagePolicy;
        this.maxSizeBytes = maxSizeBytes;
        this.pageSizeBytes = pageSizeBytes;
        this.pageCacheMaxSize = pageCacheMaxSize;
        this.maxDeliveryAttempts = maxDeliveryAttempts;
        this.redeliveryDelay = redeliveryDelay;
        this.redeliveryMultiplier = redeliveryMultiplier;
        this.maxRedeliveryDelay = maxRedeliveryDelay;
        this.deadLetterAddress = deadLetterAddress;
        this.expiryAddress = expiryAddress;
        this.lastValueQueue = lastValueQueue;
        this.redistributionDelay = redistributionDelay;
        this.sendToDLAOnNoRoute = sendToDLAOnNoRoute;
        this.slowConsumerThreshold = slowConsumerThreshold;
        this.slowConsumerCheckPeriod = slowConsumerCheckPeriod;
        this.slowConsumerPolicy = slowConsumerPolicy;
        this.autoCreateJmsQueues = autoCreateJmsQueues;
        this.autoDeleteJmsQueues = autoDeleteJmsQueues;
        this.autoCreateJmsTopics = autoCreateJmsTopics;
        this.autoDeleteJmsTopics = autoDeleteJmsTopics;
        this.autoCreateQueues = autoCreateQueues;
        this.autoDeleteQueues = autoDeleteQueues;
        this.autoCreateAddresses = autoCreateAddresses;
        this.autoDeleteAddresses = autoDeleteAddresses;
        this.configDeleteQueues = configDeleteQueues;
        this.configDeleteAddresses = configDeleteAddresses;
        this.maxSizeBytesRejectThreshold = maxSizeBytesRejectThreshold;
        this.defaultLastValueKey = defaultLastValueKey;
        this.defaultNonDestructive = defaultNonDestructive;
        this.defaultExclusiveQueue = defaultExclusiveQueue;
        this.defaultGroupRebalance = defaultGroupRebalance;
        this.defaultGroupBuckets = defaultGroupBuckets;
        this.defaultGroupFirstKey = defaultGroupFirstKey;
        this.defaultMaxConsumers = defaultMaxConsumers;
        this.defaultPurgeOnNoConsumers = defaultPurgeOnNoConsumers;
        this.defaultConsumersBeforeDispatch = defaultConsumersBeforeDispatch;
        this.defaultDelayBeforeDispatch = defaultDelayBeforeDispatch;
        this.defaultQueueRoutingType = defaultQueueRoutingType;
        this.defaultAddressRoutingType = defaultAddressRoutingType;
        this.defaultConsumerWindowSize = defaultConsumerWindowSize;
        this.defaultRingSize = defaultRingSize;
        this.autoDeleteCreatedQueues = autoDeleteCreatedQueues;
        this.autoDeleteQueuesDelay = autoDeleteQueuesDelay;
        this.autoDeleteQueuesMessageCount = autoDeleteQueuesMessageCount;
        this.autoDeleteAddressesDelay = autoDeleteAddressesDelay;
        this.redeliveryCollisionAvoidanceFactor = redeliveryCollisionAvoidanceFactor;
        this.retroactiveMessageCount = retroactiveMessageCount;
    }

    public int getPageCacheMaxSize() {
        return this.pageCacheMaxSize;
    }

    public void setPageCacheMaxSize(int pageCacheMaxSize) {
        this.pageCacheMaxSize = pageCacheMaxSize;
    }

    public String getAddressFullMessagePolicy() {
        return this.addressFullMessagePolicy;
    }

    public long getMaxSizeBytes() {
        return this.maxSizeBytes;
    }

    public int getPageSizeBytes() {
        return this.pageSizeBytes;
    }

    public int getMaxDeliveryAttempts() {
        return this.maxDeliveryAttempts;
    }

    public long getRedeliveryDelay() {
        return this.redeliveryDelay;
    }

    public String getDeadLetterAddress() {
        return this.deadLetterAddress;
    }

    public String getExpiryAddress() {
        return this.expiryAddress;
    }

    public boolean isLastValueQueue() {
        return this.lastValueQueue;
    }

    public long getRedistributionDelay() {
        return this.redistributionDelay;
    }

    public boolean isSendToDLAOnNoRoute() {
        return this.sendToDLAOnNoRoute;
    }

    public double getRedeliveryMultiplier() {
        return this.redeliveryMultiplier;
    }

    public long getMaxRedeliveryDelay() {
        return this.maxRedeliveryDelay;
    }

    public long getSlowConsumerThreshold() {
        return this.slowConsumerThreshold;
    }

    public long getSlowConsumerCheckPeriod() {
        return this.slowConsumerCheckPeriod;
    }

    public String getSlowConsumerPolicy() {
        return this.slowConsumerPolicy;
    }

    @Deprecated
    public boolean isAutoCreateJmsQueues() {
        return this.autoCreateJmsQueues;
    }

    @Deprecated
    public boolean isAutoDeleteJmsQueues() {
        return this.autoDeleteJmsQueues;
    }

    @Deprecated
    public boolean isAutoCreateJmsTopics() {
        return this.autoCreateJmsTopics;
    }

    @Deprecated
    public boolean isAutoDeleteJmsTopics() {
        return this.autoDeleteJmsTopics;
    }

    public boolean isAutoCreateQueues() {
        return this.autoCreateQueues;
    }

    public boolean isAutoDeleteQueues() {
        return this.autoDeleteQueues;
    }

    public boolean isAutoCreateAddresses() {
        return this.autoCreateAddresses;
    }

    public boolean isAutoDeleteAddresses() {
        return this.autoDeleteAddresses;
    }

    public String getConfigDeleteQueues() {
        return this.configDeleteQueues;
    }

    public String getConfigDeleteAddresses() {
        return this.configDeleteAddresses;
    }

    public long getMaxSizeBytesRejectThreshold() {
        return this.maxSizeBytesRejectThreshold;
    }

    public String getDefaultLastValueKey() {
        return this.defaultLastValueKey;
    }

    public boolean isDefaultNonDestructive() {
        return this.defaultNonDestructive;
    }

    public boolean isDefaultExclusiveQueue() {
        return this.defaultExclusiveQueue;
    }

    public boolean isDefaultGroupRebalance() {
        return this.defaultGroupRebalance;
    }

    public int getDefaultGroupBuckets() {
        return this.defaultGroupBuckets;
    }

    public String getDefaultGroupFirstKey() {
        return this.defaultGroupFirstKey;
    }

    public int getDefaultMaxConsumers() {
        return this.defaultMaxConsumers;
    }

    public boolean isDefaultPurgeOnNoConsumers() {
        return this.defaultPurgeOnNoConsumers;
    }

    public int getDefaultConsumersBeforeDispatch() {
        return this.defaultConsumersBeforeDispatch;
    }

    public long getDefaultDelayBeforeDispatch() {
        return this.defaultDelayBeforeDispatch;
    }

    public String getDefaultQueueRoutingType() {
        return this.defaultQueueRoutingType;
    }

    public String getDefaultAddressRoutingType() {
        return this.defaultAddressRoutingType;
    }

    public int getDefaultConsumerWindowSize() {
        return this.defaultConsumerWindowSize;
    }

    public long getDefaultRingSize() {
        return this.defaultRingSize;
    }

    public boolean isAutoDeleteCreatedQueues() {
        return this.autoDeleteCreatedQueues;
    }

    public long getAutoDeleteQueuesDelay() {
        return this.autoDeleteQueuesDelay;
    }

    public long getAutoDeleteQueuesMessageCount() {
        return this.autoDeleteQueuesMessageCount;
    }

    public long getAutoDeleteAddressesDelay() {
        return this.autoDeleteAddressesDelay;
    }

    public double getRedeliveryCollisionAvoidanceFactor() {
        return this.redeliveryCollisionAvoidanceFactor;
    }

    public long getRetroactiveMessageCount() {
        return this.retroactiveMessageCount;
    }
}

