/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.client.impl;

import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQConnectionTimedOutException;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQInterruptedException;
import org.apache.activemq.artemis.api.core.ActiveMQNotConnectedException;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.FailoverEventListener;
import org.apache.activemq.artemis.api.core.client.FailoverEventType;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.client.SessionFailureListener;
import org.apache.activemq.artemis.core.client.ActiveMQClientLogger;
import org.apache.activemq.artemis.core.client.ActiveMQClientMessageBundle;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.client.impl.ClientSessionImpl;
import org.apache.activemq.artemis.core.client.impl.ClientSessionInternal;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorInternal;
import org.apache.activemq.artemis.core.protocol.core.CoreRemotingConnection;
import org.apache.activemq.artemis.core.protocol.core.impl.ActiveMQSessionContext;
import org.apache.activemq.artemis.core.remoting.FailureListener;
import org.apache.activemq.artemis.core.remoting.impl.TransportConfigurationUtil;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnector;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.shaded.org.jboss.logging.Logger;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.BufferHandler;
import org.apache.activemq.artemis.spi.core.remoting.ClientConnectionLifeCycleListener;
import org.apache.activemq.artemis.spi.core.remoting.ClientProtocolManager;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.artemis.spi.core.remoting.Connector;
import org.apache.activemq.artemis.spi.core.remoting.ConnectorFactory;
import org.apache.activemq.artemis.spi.core.remoting.SessionContext;
import org.apache.activemq.artemis.spi.core.remoting.TopologyResponseHandler;
import org.apache.activemq.artemis.utils.ClassloadingUtil;
import org.apache.activemq.artemis.utils.ConfirmationWindowWarning;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.apache.activemq.artemis.utils.actors.OrderedExecutorFactory;
import org.apache.activemq.artemis.utils.collections.ConcurrentHashSet;

public class ClientSessionFactoryImpl
implements ClientSessionFactoryInternal,
ClientConnectionLifeCycleListener {
    private static final Logger logger = Logger.getLogger(ClientSessionFactoryImpl.class);
    private final ServerLocatorInternal serverLocator;
    private final ClientProtocolManager clientProtocolManager;
    private TransportConfiguration connectorConfig;
    private TransportConfiguration currentConnectorConfig;
    private volatile TransportConfiguration backupConfig;
    private ConnectorFactory connectorFactory;
    private transient boolean finalizeCheck = true;
    private final long callTimeout;
    private final long callFailoverTimeout;
    private final long clientFailureCheckPeriod;
    private final long connectionTTL;
    private final Set<ClientSessionInternal> sessions = new ConcurrentHashSet<ClientSessionInternal>();
    private final Object createSessionLock = new Object();
    private final Lock newFailoverLock = new ReentrantLock();
    private final Object connectionLock = new Object();
    private final ExecutorFactory orderedExecutorFactory;
    private final Executor threadPool;
    private final ScheduledExecutorService scheduledThreadPool;
    private final Executor closeExecutor;
    private RemotingConnection connection;
    private final long retryInterval;
    private final double retryIntervalMultiplier;
    private final CountDownLatch latchFinalTopology = new CountDownLatch(1);
    private final long maxRetryInterval;
    private int reconnectAttempts;
    private final Set<SessionFailureListener> listeners = new ConcurrentHashSet<SessionFailureListener>();
    private final Set<FailoverEventListener> failoverListeners = new ConcurrentHashSet<FailoverEventListener>();
    private Connector connector;
    private Future<?> pingerFuture;
    private PingRunnable pingRunnable;
    private final List<Interceptor> incomingInterceptors;
    private final List<Interceptor> outgoingInterceptors;
    private volatile boolean stopPingingAfterOne;
    private volatile boolean closed;
    public final Exception createTrace;
    public static final Set<CloseRunnable> CLOSE_RUNNABLES = Collections.synchronizedSet(new HashSet());
    private final ConfirmationWindowWarning confirmationWindowWarning;
    private String liveNodeID;
    private boolean connectionReadyForWrites;
    private final Object connectionReadyLock = new Object();

    public ClientSessionFactoryImpl(ServerLocatorInternal serverLocator, TransportConfiguration connectorConfig, long callTimeout, long callFailoverTimeout, long clientFailureCheckPeriod, long connectionTTL, long retryInterval, double retryIntervalMultiplier, long maxRetryInterval, int reconnectAttempts, Executor threadPool, ScheduledExecutorService scheduledThreadPool, List<Interceptor> incomingInterceptors, List<Interceptor> outgoingInterceptors) {
        this.createTrace = new Exception();
        this.serverLocator = serverLocator;
        this.clientProtocolManager = serverLocator.newProtocolManager();
        this.clientProtocolManager.setSessionFactory(this);
        this.currentConnectorConfig = connectorConfig;
        this.connectorFactory = this.instantiateConnectorFactory(connectorConfig.getFactoryClassName());
        this.checkTransportKeys(this.connectorFactory, connectorConfig);
        this.callTimeout = callTimeout;
        this.callFailoverTimeout = callFailoverTimeout;
        if (this.connectorFactory.isReliable() && clientFailureCheckPeriod == ActiveMQClient.DEFAULT_CLIENT_FAILURE_CHECK_PERIOD && connectionTTL == ActiveMQClient.DEFAULT_CONNECTION_TTL) {
            this.clientFailureCheckPeriod = -1L;
            this.connectionTTL = -1L;
        } else {
            this.clientFailureCheckPeriod = clientFailureCheckPeriod;
            this.connectionTTL = connectionTTL;
        }
        this.retryInterval = retryInterval;
        this.retryIntervalMultiplier = retryIntervalMultiplier;
        this.maxRetryInterval = maxRetryInterval;
        this.reconnectAttempts = reconnectAttempts;
        this.scheduledThreadPool = scheduledThreadPool;
        this.threadPool = threadPool;
        this.orderedExecutorFactory = new OrderedExecutorFactory(threadPool);
        this.closeExecutor = this.orderedExecutorFactory.getExecutor();
        this.incomingInterceptors = incomingInterceptors;
        this.outgoingInterceptors = outgoingInterceptors;
        this.confirmationWindowWarning = new ConfirmationWindowWarning(serverLocator.getConfirmationWindowSize() < 0);
        this.connectionReadyForWrites = true;
    }

    @Override
    public void disableFinalizeCheck() {
        this.finalizeCheck = false;
    }

    @Override
    public Lock lockFailover() {
        this.newFailoverLock.lock();
        return this.newFailoverLock;
    }

    @Override
    public void connect(int initialConnectAttempts) throws ActiveMQException {
        this.getConnectionWithRetry(initialConnectAttempts, null);
        if (this.connection == null) {
            StringBuilder msg = new StringBuilder("Unable to connect to server using configuration ").append(this.currentConnectorConfig);
            if (this.backupConfig != null) {
                msg.append(" and backup configuration ").append(this.backupConfig);
            }
            throw new ActiveMQNotConnectedException(msg.toString());
        }
    }

    @Override
    @Deprecated
    public void connect(int initialConnectAttempts, boolean failoverOnInitialConnection) throws ActiveMQException {
        this.connect(initialConnectAttempts);
    }

    @Override
    public TransportConfiguration getConnectorConfiguration() {
        return this.currentConnectorConfig;
    }

    @Override
    public void setBackupConnector(TransportConfiguration live, TransportConfiguration backUp) {
        Connector localConnector = this.connector;
        if (localConnector == null) {
            localConnector = this.connectorFactory.createConnector(this.currentConnectorConfig.getParams(), new DelegatingBufferHandler(), this, this.closeExecutor, this.threadPool, this.scheduledThreadPool, this.clientProtocolManager);
        }
        if (localConnector.isEquivalent(live.getParams()) && backUp != null && !localConnector.isEquivalent(backUp.getParams())) {
            if (logger.isDebugEnabled()) {
                logger.debug("Setting up backup config = " + backUp + " for live = " + live);
            }
            this.backupConfig = backUp;
        } else if (logger.isDebugEnabled()) {
            logger.debug("ClientSessionFactoryImpl received backup update for live/backup pair = " + live + " / " + backUp + " but it didn't belong to " + this.currentConnectorConfig);
        }
    }

    @Override
    public Object getBackupConnector() {
        return this.backupConfig;
    }

    @Override
    public ClientSession createSession(String username, String password, boolean xa, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge, int ackBatchSize) throws ActiveMQException {
        return this.createSessionInternal(username, password, xa, autoCommitSends, autoCommitAcks, preAcknowledge, ackBatchSize);
    }

    @Override
    public ClientSession createSession(boolean autoCommitSends, boolean autoCommitAcks, int ackBatchSize) throws ActiveMQException {
        return this.createSessionInternal(null, null, false, autoCommitSends, autoCommitAcks, this.serverLocator.isPreAcknowledge(), ackBatchSize);
    }

    @Override
    public ClientSession createXASession() throws ActiveMQException {
        return this.createSessionInternal(null, null, true, false, false, this.serverLocator.isPreAcknowledge(), this.serverLocator.getAckBatchSize());
    }

    @Override
    public ClientSession createTransactedSession() throws ActiveMQException {
        return this.createSessionInternal(null, null, false, false, false, this.serverLocator.isPreAcknowledge(), this.serverLocator.getAckBatchSize());
    }

    @Override
    public ClientSession createSession() throws ActiveMQException {
        return this.createSessionInternal(null, null, false, true, true, this.serverLocator.isPreAcknowledge(), this.serverLocator.getAckBatchSize());
    }

    @Override
    public ClientSession createSession(boolean autoCommitSends, boolean autoCommitAcks) throws ActiveMQException {
        return this.createSessionInternal(null, null, false, autoCommitSends, autoCommitAcks, this.serverLocator.isPreAcknowledge(), this.serverLocator.getAckBatchSize());
    }

    @Override
    public ClientSession createSession(boolean xa, boolean autoCommitSends, boolean autoCommitAcks) throws ActiveMQException {
        return this.createSessionInternal(null, null, xa, autoCommitSends, autoCommitAcks, this.serverLocator.isPreAcknowledge(), this.serverLocator.getAckBatchSize());
    }

    @Override
    public ClientSession createSession(boolean xa, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge) throws ActiveMQException {
        return this.createSessionInternal(null, null, xa, autoCommitSends, autoCommitAcks, preAcknowledge, this.serverLocator.getAckBatchSize());
    }

    @Override
    public void connectionCreated(ActiveMQComponent component, Connection connection, ClientProtocolManager protocol) {
    }

    @Override
    public void connectionDestroyed(final Object connectionID) {
        final ActiveMQNotConnectedException ex = ActiveMQClientMessageBundle.BUNDLE.channelDisconnected();
        this.closeExecutor.execute(new Runnable(){

            @Override
            public void run() {
                ClientSessionFactoryImpl.this.handleConnectionFailure(connectionID, ex);
            }
        });
    }

    @Override
    public void connectionException(Object connectionID, ActiveMQException me) {
        this.handleConnectionFailure(connectionID, me);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSession(ClientSessionInternal session, boolean failingOver) {
        Set<ClientSessionInternal> set = this.sessions;
        synchronized (set) {
            this.sessions.remove(session);
        }
    }

    @Override
    public void connectionReadyForWrites(Object connectionID, boolean ready) {
    }

    @Override
    public synchronized int numConnections() {
        return this.connection != null ? 1 : 0;
    }

    @Override
    public int numSessions() {
        return this.sessions.size();
    }

    @Override
    public void addFailureListener(SessionFailureListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public boolean removeFailureListener(SessionFailureListener listener) {
        return this.listeners.remove(listener);
    }

    @Override
    public ClientSessionFactoryImpl addFailoverListener(FailoverEventListener listener) {
        this.failoverListeners.add(listener);
        return this;
    }

    @Override
    public boolean removeFailoverListener(FailoverEventListener listener) {
        return this.failoverListeners.remove(listener);
    }

    @Override
    public void causeExit() {
        this.clientProtocolManager.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interruptConnectAndCloseAllSessions(boolean close) {
        this.clientProtocolManager.stop();
        Object object = this.createSessionLock;
        synchronized (object) {
            this.closeCleanSessions(close);
            this.closed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeCleanSessions(boolean close) {
        HashSet<ClientSessionInternal> sessionsToClose;
        Set<ClientSessionInternal> set = this.sessions;
        synchronized (set) {
            sessionsToClose = new HashSet<ClientSessionInternal>(this.sessions);
        }
        for (ClientSessionInternal session : sessionsToClose) {
            try {
                if (close) {
                    session.close();
                    continue;
                }
                session.cleanUp(false);
            }
            catch (Exception e1) {
                ActiveMQClientLogger.LOGGER.unableToCloseSession(e1);
            }
        }
        this.checkCloseConnection();
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.interruptConnectAndCloseAllSessions(true);
        this.serverLocator.factoryClosed(this);
    }

    @Override
    public void cleanup() {
        if (this.closed) {
            return;
        }
        this.interruptConnectAndCloseAllSessions(false);
    }

    @Override
    public boolean waitForTopology(long timeout, TimeUnit unit) {
        try {
            return this.latchFinalTopology.await(timeout, unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            ActiveMQClientLogger.LOGGER.unableToReceiveClusterTopology(e);
            return false;
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed || this.serverLocator.isClosed();
    }

    @Override
    public ServerLocator getServerLocator() {
        return this.serverLocator;
    }

    public void stopPingingAfterOne() {
        this.stopPingingAfterOne = true;
    }

    private void handleConnectionFailure(Object connectionID, ActiveMQException me) {
        this.handleConnectionFailure(connectionID, me, null);
    }

    private void handleConnectionFailure(Object connectionID, ActiveMQException me, String scaleDownTargetNodeID) {
        try {
            this.failoverOrReconnect(connectionID, me, scaleDownTargetNodeID);
        }
        catch (ActiveMQInterruptedException e1) {
            logger.debug((Object)e1.getMessage(), e1);
        }
        catch (Throwable t) {
            ActiveMQClientLogger.LOGGER.unableToHandleConnectionFailure(t);
            this.close();
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void failoverOrReconnect(Object connectionID, ActiveMQException me, String scaleDownTargetNodeID) {
        HashSet<ClientSessionInternal> sessionsToClose;
        block25: {
            ActiveMQClientLogger.LOGGER.failoverOrReconnect(connectionID, me);
            for (ClientSessionInternal session : this.sessions) {
                ActiveMQSessionContext sessionContext;
                SessionContext context = session.getSessionContext();
                if (!(context instanceof ActiveMQSessionContext) || !(sessionContext = (ActiveMQSessionContext)context).isKilled()) continue;
                this.setReconnectAttempts(0);
            }
            sessionsToClose = null;
            if (!this.clientProtocolManager.isAlive()) {
                return;
            }
            Lock localFailoverLock = this.lockFailover();
            try {
                if (this.connection == null || !this.connection.getID().equals(connectionID) || !this.clientProtocolManager.isAlive()) {
                    return;
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("Client Connection failed, calling failure listeners and trying to reconnect, reconnectAttempts=" + this.reconnectAttempts);
                }
                this.callFailoverListeners(FailoverEventType.FAILURE_DETECTED);
                this.callSessionFailureListeners(me, false, false, scaleDownTargetNodeID);
                if (this.reconnectAttempts != 0) {
                    if (this.clientProtocolManager.cleanupBeforeFailover(me)) {
                        RemotingConnection oldConnection = this.connection;
                        this.connection = null;
                        Connector localConnector = this.connector;
                        if (localConnector != null) {
                            try {
                                localConnector.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        this.cancelScheduledTasks();
                        this.connector = null;
                        this.reconnectSessions(oldConnection, this.reconnectAttempts, me);
                        if (oldConnection != null) {
                            oldConnection.destroy();
                        }
                        if (this.connection != null) {
                            this.callFailoverListeners(FailoverEventType.FAILOVER_COMPLETED);
                        }
                    }
                } else {
                    RemotingConnection connectionToDestory = this.connection;
                    if (connectionToDestory != null) {
                        connectionToDestory.destroy();
                    }
                    this.connection = null;
                }
                if (this.connection != null) break block25;
                Set<ClientSessionInternal> set = this.sessions;
                synchronized (set) {
                    sessionsToClose = new HashSet<ClientSessionInternal>(this.sessions);
                }
                this.callFailoverListeners(FailoverEventType.FAILOVER_FAILED);
                this.callSessionFailureListeners(me, true, false, scaleDownTargetNodeID);
            }
            finally {
                localFailoverLock.unlock();
            }
        }
        if (this.connection != null) {
            this.callSessionFailureListeners(me, true, true);
        }
        if (sessionsToClose != null) {
            for (ClientSessionInternal session : sessionsToClose) {
                try {
                    session.cleanUp(true);
                }
                catch (Exception cause) {
                    ActiveMQClientLogger.LOGGER.failedToCleanupSession(cause);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientSession createSessionInternal(String username, String password, boolean xa, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge, int ackBatchSize) throws ActiveMQException {
        String name = UUIDGenerator.getInstance().generateStringUUID();
        SessionContext context = this.createSessionChannel(name, username, password, xa, autoCommitSends, autoCommitAcks, preAcknowledge);
        ClientSessionImpl session = new ClientSessionImpl(this, name, username, password, xa, autoCommitSends, autoCommitAcks, preAcknowledge, this.serverLocator.isBlockOnAcknowledge(), this.serverLocator.isAutoGroup(), ackBatchSize, this.serverLocator.getConsumerWindowSize(), this.serverLocator.getConsumerMaxRate(), this.serverLocator.getConfirmationWindowSize(), this.serverLocator.getProducerWindowSize(), this.serverLocator.getProducerMaxRate(), this.serverLocator.isBlockOnNonDurableSend(), this.serverLocator.isBlockOnDurableSend(), this.serverLocator.isCacheLargeMessagesClient(), this.serverLocator.getMinLargeMessageSize(), this.serverLocator.isCompressLargeMessage(), this.serverLocator.getInitialMessagePacketSize(), this.serverLocator.getGroupID(), context, this.orderedExecutorFactory.getExecutor(), this.orderedExecutorFactory.getExecutor(), this.orderedExecutorFactory.getExecutor());
        Set<ClientSessionInternal> set = this.sessions;
        synchronized (set) {
            if (this.closed || !this.clientProtocolManager.isAlive()) {
                session.close();
                return null;
            }
            this.sessions.add(session);
        }
        return session;
    }

    private void callSessionFailureListeners(ActiveMQException me, boolean afterReconnect, boolean failedOver) {
        this.callSessionFailureListeners(me, afterReconnect, failedOver, null);
    }

    private void callSessionFailureListeners(ActiveMQException me, boolean afterReconnect, boolean failedOver, String scaleDownTargetNodeID) {
        ArrayList<SessionFailureListener> listenersClone = new ArrayList<SessionFailureListener>(this.listeners);
        for (SessionFailureListener listener : listenersClone) {
            try {
                if (afterReconnect) {
                    listener.connectionFailed(me, failedOver, scaleDownTargetNodeID);
                    continue;
                }
                listener.beforeReconnect(me);
            }
            catch (Throwable t) {
                ActiveMQClientLogger.LOGGER.failedToExecuteListener(t);
            }
        }
    }

    private void callFailoverListeners(FailoverEventType type) {
        ArrayList<FailoverEventListener> listenersClone = new ArrayList<FailoverEventListener>(this.failoverListeners);
        for (FailoverEventListener listener : listenersClone) {
            try {
                listener.failoverEvent(type);
            }
            catch (Throwable t) {
                ActiveMQClientLogger.LOGGER.failedToExecuteListener(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconnectSessions(RemotingConnection oldConnection, int reconnectAttempts, ActiveMQException cause) {
        HashSet<ClientSessionInternal> sessionsToFailover;
        Set<ClientSessionInternal> set = this.sessions;
        synchronized (set) {
            sessionsToFailover = new HashSet<ClientSessionInternal>(this.sessions);
        }
        for (ClientSessionInternal session : sessionsToFailover) {
            session.preHandleFailover(this.connection);
        }
        this.getConnectionWithRetry(reconnectAttempts, oldConnection);
        if (this.connection == null) {
            if (!this.clientProtocolManager.isAlive()) {
                ActiveMQClientLogger.LOGGER.failedToConnectToServer();
            }
            return;
        }
        List<FailureListener> oldListeners = oldConnection.getFailureListeners();
        ArrayList<FailureListener> newListeners = new ArrayList<FailureListener>(this.connection.getFailureListeners());
        for (FailureListener listener : oldListeners) {
            if (listener instanceof DelegatingFailureListener) continue;
            newListeners.add(listener);
        }
        this.connection.setFailureListeners(newListeners);
        ((CoreRemotingConnection)this.connection).syncIDGeneratorSequence(((CoreRemotingConnection)oldConnection).getIDGeneratorSequence());
        for (ClientSessionInternal session : sessionsToFailover) {
            if (session.handleFailover(this.connection, cause)) continue;
            this.connection.destroy();
            this.connection = null;
            return;
        }
    }

    private void getConnectionWithRetry(int reconnectAttempts, RemotingConnection oldConnection) {
        if (!this.clientProtocolManager.isAlive()) {
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("getConnectionWithRetry::" + reconnectAttempts + " with retryInterval = " + this.retryInterval + " multiplier = " + this.retryIntervalMultiplier), new Exception("trace"));
        }
        long interval = this.retryInterval;
        int count = 0;
        while (this.clientProtocolManager.isAlive()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Trying reconnection attempt " + count + "/" + reconnectAttempts);
            }
            if (this.getConnection() != null) {
                if (oldConnection != null && oldConnection instanceof CoreRemotingConnection) {
                    ((CoreRemotingConnection)this.connection).setChannelVersion(((CoreRemotingConnection)oldConnection).getChannelVersion());
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Reconnection successful");
                }
                return;
            }
            if (reconnectAttempts != 0) {
                if (reconnectAttempts != -1 && ++count == reconnectAttempts) {
                    if (reconnectAttempts != 1) {
                        ActiveMQClientLogger.LOGGER.failedToConnectToServer(reconnectAttempts);
                    }
                    return;
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("Waiting " + interval + " milliseconds before next retry. RetryInterval=" + this.retryInterval + " and multiplier=" + this.retryIntervalMultiplier);
                }
                if (this.waitForRetry(interval)) {
                    return;
                }
                long newInterval = (long)((double)interval * this.retryIntervalMultiplier);
                if (newInterval > this.maxRetryInterval) {
                    newInterval = this.maxRetryInterval;
                }
                interval = newInterval;
                continue;
            }
            logger.debug("Could not connect to any server. Didn't have reconnection configured on the ClientSessionFactory");
            return;
        }
    }

    @Override
    public boolean waitForRetry(long interval) {
        try {
            if (this.clientProtocolManager.waitOnLatch(interval)) {
                return true;
            }
        }
        catch (InterruptedException ignore) {
            throw new ActiveMQInterruptedException(this.createTrace);
        }
        return false;
    }

    private void cancelScheduledTasks() {
        PingRunnable pingRunnableLocal;
        Future<?> pingerFutureLocal = this.pingerFuture;
        if (pingerFutureLocal != null) {
            pingerFutureLocal.cancel(false);
        }
        if ((pingRunnableLocal = this.pingRunnable) != null) {
            pingRunnableLocal.cancel();
        }
        this.pingerFuture = null;
        this.pingRunnable = null;
    }

    private void checkCloseConnection() {
        RemotingConnection connectionInUse = this.connection;
        Connector connectorInUse = this.connector;
        if (connectionInUse != null && this.sessions.size() == 0) {
            this.cancelScheduledTasks();
            try {
                connectionInUse.destroy();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.connection = null;
            try {
                if (connectorInUse != null) {
                    connectorInUse.close();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.connector = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemotingConnection getConnection() {
        if (this.closed) {
            throw new IllegalStateException("ClientSessionFactory is closed!");
        }
        if (!this.clientProtocolManager.isAlive()) {
            return null;
        }
        Object object = this.connectionLock;
        synchronized (object) {
            RemotingConnection connection;
            if (this.connection != null) {
                return this.connection;
            }
            this.connection = connection = this.establishNewConnection();
            if (connection != null && this.liveNodeID != null) {
                try {
                    if (!this.clientProtocolManager.checkForFailover(this.liveNodeID)) {
                        connection.destroy();
                        this.connection = null;
                        return null;
                    }
                }
                catch (ActiveMQException e) {
                    connection.destroy();
                    this.connection = null;
                    return null;
                }
            }
            if (connection != null && this.serverLocator.getAfterConnectInternalListener() != null) {
                this.serverLocator.getAfterConnectInternalListener().onConnection(this);
            }
            if (this.serverLocator.getTopology() != null) {
                if (connection != null) {
                    if (logger.isTraceEnabled()) {
                        logger.trace(this + "::Subscribing Topology");
                    }
                    this.clientProtocolManager.sendSubscribeTopology(this.serverLocator.isClusterConnection());
                }
            } else {
                logger.debug("serverLocator@" + System.identityHashCode(this.serverLocator + " had no topology"));
            }
            return connection;
        }
    }

    protected void schedulePing() {
        if (this.pingerFuture == null) {
            this.pingRunnable = new PingRunnable();
            if (this.clientFailureCheckPeriod != -1L) {
                this.pingerFuture = this.scheduledThreadPool.scheduleWithFixedDelay(new ActualScheduledPinger(this.pingRunnable), 0L, this.clientFailureCheckPeriod, TimeUnit.MILLISECONDS);
            }
            this.pingRunnable.send();
        } else {
            this.pingRunnable.run();
        }
    }

    protected void finalize() throws Throwable {
        if (!this.closed && this.finalizeCheck) {
            ActiveMQClientLogger.LOGGER.factoryLeftOpen(this.createTrace, System.identityHashCode(this));
            this.close();
        }
        super.finalize();
    }

    protected ConnectorFactory instantiateConnectorFactory(final String connectorFactoryClassName) {
        ConnectorFactory cachedFactory = this.connectorFactory;
        if (cachedFactory != null && cachedFactory.getClass().getName().equals(connectorFactoryClassName)) {
            return cachedFactory;
        }
        return AccessController.doPrivileged(new PrivilegedAction<ConnectorFactory>(){

            @Override
            public ConnectorFactory run() {
                return (ConnectorFactory)ClassloadingUtil.newInstanceFromClassLoader(ClientSessionFactoryImpl.class, connectorFactoryClassName);
            }
        });
    }

    @Override
    public void setReconnectAttempts(int attempts) {
        this.reconnectAttempts = attempts;
    }

    public int getReconnectAttempts() {
        return this.reconnectAttempts;
    }

    @Override
    public Object getConnector() {
        return this.connector;
    }

    @Override
    public ConfirmationWindowWarning getConfirmationWindowWarning() {
        return this.confirmationWindowWarning;
    }

    protected Connection openTransportConnection(Connector connector) {
        connector.start();
        Connection transportConnection = connector.createConnection();
        if (transportConnection == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Connector towards " + connector + " failed");
            }
            try {
                connector.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return transportConnection;
    }

    protected Connector createConnector(ConnectorFactory connectorFactory, TransportConfiguration configuration) {
        NettyConnector nettyConnector;
        Connector connector = connectorFactory.createConnector(configuration.getParams(), new DelegatingBufferHandler(), this, this.closeExecutor, this.threadPool, this.scheduledThreadPool, this.clientProtocolManager);
        if (connector instanceof NettyConnector && (nettyConnector = (NettyConnector)connector).getConnectTimeoutMillis() < 0) {
            nettyConnector.setConnectTimeoutMillis((int)this.serverLocator.getConnectionTTL());
        }
        return connector;
    }

    private void checkTransportKeys(ConnectorFactory factory, TransportConfiguration tc) {
    }

    protected Connection createTransportConnection() {
        Connection transportConnection = null;
        try {
            Connector liveConnector;
            if (logger.isDebugEnabled()) {
                logger.debug("Trying to connect with connectorFactory = " + this.connectorFactory + ", connectorConfig=" + this.currentConnectorConfig);
            }
            if ((transportConnection = this.openTransportConnection(liveConnector = this.createConnector(this.connectorFactory, this.currentConnectorConfig))) != null) {
                this.connector = liveConnector;
                return transportConnection;
            }
            if (this.backupConfig != null) {
                ConnectorFactory backupConnectorFactory;
                Connector backupConnector;
                if (logger.isDebugEnabled()) {
                    logger.debug("Trying backup config = " + this.backupConfig);
                }
                if ((transportConnection = this.openTransportConnection(backupConnector = this.createConnector(backupConnectorFactory = this.instantiateConnectorFactory(this.backupConfig.getFactoryClassName()), this.backupConfig))) != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Connected to the backup at " + this.backupConfig);
                    }
                    this.connector = backupConnector;
                    this.connectorConfig = this.currentConnectorConfig;
                    this.currentConnectorConfig = this.backupConfig;
                    this.connectorFactory = backupConnectorFactory;
                    return transportConnection;
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Backup is not active, trying original connection configuration now.");
            }
            if (this.currentConnectorConfig.equals(this.connectorConfig) || this.connectorConfig == null) {
                return null;
            }
            ConnectorFactory lastConnectorFactory = this.instantiateConnectorFactory(this.connectorConfig.getFactoryClassName());
            Connector lastConnector = this.createConnector(lastConnectorFactory, this.connectorConfig);
            transportConnection = this.openTransportConnection(lastConnector);
            if (transportConnection != null) {
                logger.debug("Returning into original connector");
                this.connector = lastConnector;
                TransportConfiguration temp = this.currentConnectorConfig;
                this.currentConnectorConfig = this.connectorConfig;
                this.connectorConfig = temp;
                return transportConnection;
            }
            logger.debug("no connection been made, returning null");
            return null;
        }
        catch (Exception cause) {
            ActiveMQClientLogger.LOGGER.createConnectorException(cause);
            if (transportConnection != null) {
                try {
                    transportConnection.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (this.connector != null) {
                try {
                    this.connector.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.connector = null;
            return null;
        }
    }

    protected RemotingConnection establishNewConnection() {
        Connection transportConnection = this.createTransportConnection();
        if (transportConnection == null) {
            if (logger.isTraceEnabled()) {
                logger.trace("Neither backup or live were active, will just give up now");
            }
            return null;
        }
        RemotingConnection newConnection = this.clientProtocolManager.connect(transportConnection, this.callTimeout, this.callFailoverTimeout, this.incomingInterceptors, this.outgoingInterceptors, new SessionFactoryTopologyHandler());
        newConnection.addFailureListener(new DelegatingFailureListener(newConnection.getID()));
        this.schedulePing();
        if (logger.isTraceEnabled()) {
            logger.trace("returning " + newConnection);
        }
        return newConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SessionContext createSessionChannel(String name, String username, String password, boolean xa, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge) throws ActiveMQException {
        Object object = this.createSessionLock;
        synchronized (object) {
            return this.clientProtocolManager.createSessionContext(name, username, password, xa, autoCommitSends, autoCommitAcks, preAcknowledge, this.serverLocator.getMinLargeMessageSize(), this.serverLocator.getConfirmationWindowSize());
        }
    }

    @Override
    public String getLiveNodeId() {
        return this.liveNodeID;
    }

    class SessionFactoryTopologyHandler
    implements TopologyResponseHandler {
        SessionFactoryTopologyHandler() {
        }

        @Override
        public void nodeDisconnected(RemotingConnection conn, String nodeID, String scaleDownTargetNodeID) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Disconnect being called on client: server locator = " + ClientSessionFactoryImpl.this.serverLocator + " notifying node " + nodeID + " as down"), new Exception("trace"));
            }
            ClientSessionFactoryImpl.this.serverLocator.notifyNodeDown(System.currentTimeMillis(), nodeID);
            ClientSessionFactoryImpl.this.closeExecutor.execute(new CloseRunnable(conn, scaleDownTargetNodeID));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notifyNodeUp(long uniqueEventID, String nodeID, String backupGroupName, String scaleDownGroupName, Pair<TransportConfiguration, TransportConfiguration> connectorPair, boolean isLast) {
            try {
                if (connectorPair.getA() != null && TransportConfigurationUtil.isSameHost(connectorPair.getA(), ClientSessionFactoryImpl.this.currentConnectorConfig)) {
                    ClientSessionFactoryImpl.this.liveNodeID = nodeID;
                }
                ClientSessionFactoryImpl.this.serverLocator.notifyNodeUp(uniqueEventID, nodeID, backupGroupName, scaleDownGroupName, connectorPair, isLast);
            }
            finally {
                if (isLast) {
                    ClientSessionFactoryImpl.this.latchFinalTopology.countDown();
                }
            }
        }

        @Override
        public void notifyNodeDown(long eventTime, String nodeID) {
            ClientSessionFactoryImpl.this.serverLocator.notifyNodeDown(eventTime, nodeID);
        }
    }

    private final class PingRunnable
    implements Runnable {
        private boolean cancelled;
        private boolean first;
        private long lastCheck = System.currentTimeMillis();

        private PingRunnable() {
        }

        @Override
        public synchronized void run() {
            if (this.cancelled || ClientSessionFactoryImpl.this.stopPingingAfterOne && !this.first) {
                return;
            }
            this.first = false;
            long now = System.currentTimeMillis();
            final RemotingConnection connectionInUse = ClientSessionFactoryImpl.this.connection;
            if (connectionInUse != null && ClientSessionFactoryImpl.this.clientFailureCheckPeriod != -1L && ClientSessionFactoryImpl.this.connectionTTL != -1L && now >= this.lastCheck + ClientSessionFactoryImpl.this.connectionTTL) {
                if (!connectionInUse.checkDataReceived()) {
                    final ActiveMQConnectionTimedOutException me = ActiveMQClientMessageBundle.BUNDLE.connectionTimedOut(ClientSessionFactoryImpl.this.connection.getTransportConnection());
                    this.cancelled = true;
                    ClientSessionFactoryImpl.this.threadPool.execute(new Runnable(){

                        @Override
                        public void run() {
                            connectionInUse.fail(me);
                        }
                    });
                    return;
                }
                this.lastCheck = now;
            }
            this.send();
        }

        public void send() {
            ClientSessionFactoryImpl.this.clientProtocolManager.ping(ClientSessionFactoryImpl.this.connectionTTL);
        }

        public synchronized void cancel() {
            this.cancelled = true;
        }
    }

    private static final class ActualScheduledPinger
    implements Runnable {
        private final WeakReference<PingRunnable> pingRunnable;

        ActualScheduledPinger(PingRunnable runnable) {
            this.pingRunnable = new WeakReference<PingRunnable>(runnable);
        }

        @Override
        public void run() {
            PingRunnable runnable = (PingRunnable)this.pingRunnable.get();
            if (runnable != null) {
                runnable.run();
            }
        }
    }

    private final class DelegatingFailureListener
    implements FailureListener {
        private final Object connectionID;

        DelegatingFailureListener(Object connectionID) {
            this.connectionID = connectionID;
        }

        @Override
        public void connectionFailed(ActiveMQException me, boolean failedOver) {
            this.connectionFailed(me, failedOver, null);
        }

        @Override
        public void connectionFailed(ActiveMQException me, boolean failedOver, String scaleDownTargetNodeID) {
            ClientSessionFactoryImpl.this.handleConnectionFailure(this.connectionID, me, scaleDownTargetNodeID);
        }

        public String toString() {
            return DelegatingFailureListener.class.getSimpleName() + "('reconnectsOrFailover', hash=" + super.hashCode() + ")";
        }
    }

    private class DelegatingBufferHandler
    implements BufferHandler {
        private DelegatingBufferHandler() {
        }

        @Override
        public void bufferReceived(Object connectionID, ActiveMQBuffer buffer) {
            final RemotingConnection theConn = ClientSessionFactoryImpl.this.connection;
            if (theConn != null && connectionID.equals(theConn.getID())) {
                try {
                    theConn.bufferReceived(connectionID, buffer);
                }
                catch (RuntimeException e) {
                    ActiveMQClientLogger.LOGGER.disconnectOnErrorDecoding(e);
                    ClientSessionFactoryImpl.this.threadPool.execute(new Runnable(){

                        @Override
                        public void run() {
                            theConn.fail(new ActiveMQException(e.getMessage()));
                        }
                    });
                }
            } else {
                logger.debug("TheConn == null on ClientSessionFactoryImpl::DelegatingBufferHandler, ignoring packet");
            }
        }
    }

    public class CloseRunnable
    implements Runnable {
        private final RemotingConnection conn;
        private final String scaleDownTargetNodeID;

        public CloseRunnable(RemotingConnection conn, String scaleDownTargetNodeID) {
            this.conn = conn;
            this.scaleDownTargetNodeID = scaleDownTargetNodeID;
        }

        @Override
        public void run() {
            try {
                CLOSE_RUNNABLES.add(this);
                if (this.scaleDownTargetNodeID == null) {
                    this.conn.fail(ActiveMQClientMessageBundle.BUNDLE.disconnected());
                } else {
                    this.conn.fail(ActiveMQClientMessageBundle.BUNDLE.disconnected(), this.scaleDownTargetNodeID);
                }
            }
            finally {
                CLOSE_RUNNABLES.remove(this);
            }
        }

        public ClientSessionFactoryImpl stop() {
            ClientSessionFactoryImpl.this.causeExit();
            CLOSE_RUNNABLES.remove(this);
            return ClientSessionFactoryImpl.this;
        }
    }
}

