/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.client.impl;

import io.netty.buffer.ByteBuf;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.client.ActiveMQClientLogger;
import org.apache.activemq.artemis.core.client.impl.LargeMessageController;
import org.apache.activemq.artemis.utils.ActiveMQBufferInputStream;
import org.apache.activemq.artemis.utils.InflaterReader;
import org.apache.activemq.artemis.utils.InflaterWriter;
import org.apache.activemq.artemis.utils.UTF8Util;

final class CompressedLargeMessageControllerImpl
implements LargeMessageController {
    private static final String OPERATION_NOT_SUPPORTED = "Operation not supported";
    private final LargeMessageController bufferDelegate;
    DataInputStream dataInput = null;

    CompressedLargeMessageControllerImpl(LargeMessageController bufferDelegate) {
        this.bufferDelegate = bufferDelegate;
    }

    @Override
    public void discardUnusedPackets() {
        this.bufferDelegate.discardUnusedPackets();
    }

    @Override
    public void addPacket(byte[] chunk, int flowControlSize, boolean isContinues) {
        this.bufferDelegate.addPacket(chunk, flowControlSize, isContinues);
    }

    @Override
    public synchronized void cancel() {
        this.bufferDelegate.cancel();
    }

    @Override
    public synchronized void close() {
        this.bufferDelegate.cancel();
    }

    @Override
    public void setOutputStream(OutputStream output) throws ActiveMQException {
        this.bufferDelegate.setOutputStream(new InflaterWriter(output));
    }

    @Override
    public synchronized void saveBuffer(OutputStream output) throws ActiveMQException {
        this.setOutputStream(output);
        this.waitCompletion(0L);
    }

    @Override
    public synchronized boolean waitCompletion(long timeWait) throws ActiveMQException {
        return this.bufferDelegate.waitCompletion(timeWait);
    }

    @Override
    public int capacity() {
        return -1;
    }

    private DataInputStream getStream() {
        if (this.dataInput == null) {
            try {
                ActiveMQBufferInputStream input = new ActiveMQBufferInputStream(this.bufferDelegate);
                this.dataInput = new DataInputStream(new InflaterReader(input));
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return this.dataInput;
    }

    private void positioningNotSupported() {
        throw new IllegalStateException("Position not supported over compressed large messages");
    }

    @Override
    public byte readByte() {
        try {
            return this.getStream().readByte();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public byte getByte(int index) {
        this.positioningNotSupported();
        return 0;
    }

    @Override
    public void getBytes(int index, ActiveMQBuffer dst, int dstIndex, int length) {
        this.positioningNotSupported();
    }

    @Override
    public void getBytes(int index, byte[] dst, int dstIndex, int length) {
        this.positioningNotSupported();
    }

    @Override
    public void getBytes(int index, ByteBuffer dst) {
        this.positioningNotSupported();
    }

    @Override
    public int getInt(int index) {
        this.positioningNotSupported();
        return 0;
    }

    @Override
    public long getLong(int index) {
        this.positioningNotSupported();
        return 0L;
    }

    @Override
    public short getShort(int index) {
        this.positioningNotSupported();
        return 0;
    }

    @Override
    public void setByte(int index, byte value) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void setBytes(int index, ActiveMQBuffer src, int srcIndex, int length) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void setBytes(int index, byte[] src, int srcIndex, int length) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void setBytes(int index, ByteBuffer src) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void setInt(int index, int value) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void setLong(int index, long value) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void setShort(int index, short value) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    @Override
    public ByteBuffer toByteBuffer(int index, int length) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void release() {
    }

    @Override
    public int readerIndex() {
        return 0;
    }

    @Override
    public void readerIndex(int readerIndex) {
    }

    @Override
    public int writerIndex() {
        return 0;
    }

    @Override
    public long getSize() {
        return this.bufferDelegate.getSize();
    }

    @Override
    public void writerIndex(int writerIndex) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void setIndex(int readerIndex, int writerIndex) {
        this.positioningNotSupported();
    }

    @Override
    public void clear() {
    }

    @Override
    public boolean readable() {
        return true;
    }

    @Override
    public boolean writable() {
        return false;
    }

    @Override
    public int readableBytes() {
        return 1;
    }

    @Override
    public int writableBytes() {
        return 0;
    }

    @Override
    public void markReaderIndex() {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void resetReaderIndex() {
    }

    @Override
    public void markWriterIndex() {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void resetWriterIndex() {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void discardReadBytes() {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    @Override
    public short getUnsignedByte(int index) {
        return (short)(this.getByte(index) & 0xFF);
    }

    @Override
    public int getUnsignedShort(int index) {
        return this.getShort(index) & 0xFFFF;
    }

    @Override
    public long getUnsignedInt(int index) {
        return (long)this.getInt(index) & 0xFFFFFFFFL;
    }

    @Override
    public void getBytes(int index, byte[] dst) {
        for (int i = 0; i < dst.length; ++i) {
            dst[i] = this.getByte(index++);
        }
    }

    @Override
    public void getBytes(int index, ActiveMQBuffer dst) {
        this.getBytes(index, dst, dst.writableBytes());
    }

    @Override
    public void getBytes(int index, ActiveMQBuffer dst, int length) {
        if (length > dst.writableBytes()) {
            throw new IndexOutOfBoundsException();
        }
        this.getBytes(index, dst, dst.writerIndex(), length);
        dst.writerIndex(dst.writerIndex() + length);
    }

    @Override
    public void setBytes(int index, byte[] src) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void setBytes(int index, ActiveMQBuffer src) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void setBytes(int index, ActiveMQBuffer src, int length) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    @Override
    public int readUnsignedByte() {
        try {
            return this.getStream().readUnsignedByte();
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public short readShort() {
        try {
            return this.getStream().readShort();
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public int readUnsignedShort() {
        try {
            return this.getStream().readUnsignedShort();
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public int readInt() {
        try {
            return this.getStream().readInt();
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public Integer readNullableInt() {
        byte b = this.readByte();
        if (b == 0) {
            return null;
        }
        return this.readInt();
    }

    @Override
    public long readUnsignedInt() {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    @Override
    public long readLong() {
        try {
            return this.getStream().readLong();
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public Long readNullableLong() {
        byte b = this.readByte();
        if (b == 0) {
            return null;
        }
        return this.readLong();
    }

    @Override
    public void readBytes(byte[] dst, int dstIndex, int length) {
        try {
            int nReadBytes = this.getStream().read(dst, dstIndex, length);
            if (nReadBytes < length) {
                ActiveMQClientLogger.LOGGER.compressedLargeMessageError(length, nReadBytes);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public void readBytes(byte[] dst) {
        this.readBytes(dst, 0, dst.length);
    }

    @Override
    public void readBytes(ActiveMQBuffer dst) {
        this.readBytes(dst, dst.writableBytes());
    }

    @Override
    public void readBytes(ActiveMQBuffer dst, int length) {
        if (length > dst.writableBytes()) {
            throw new IndexOutOfBoundsException();
        }
        this.readBytes(dst, dst.writerIndex(), length);
        dst.writerIndex(dst.writerIndex() + length);
    }

    @Override
    public void readBytes(ActiveMQBuffer dst, int dstIndex, int length) {
        byte[] destBytes = new byte[length];
        this.readBytes(destBytes);
        dst.setBytes(dstIndex, destBytes);
    }

    @Override
    public void readBytes(ByteBuffer dst) {
        byte[] bytesToGet = new byte[dst.remaining()];
        this.readBytes(bytesToGet);
        dst.put(bytesToGet);
    }

    @Override
    public int skipBytes(int length) {
        try {
            for (int i = 0; i < length; ++i) {
                this.getStream().read();
            }
            return length;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readBytes(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.readBytes(b, off, len);
    }

    @Override
    public String readLine() throws IOException {
        return this.getStream().readLine();
    }

    @Override
    public void writeByte(byte value) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void writeShort(short value) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void writeInt(int value) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void writeNullableInt(Integer value) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void writeLong(long value) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void writeNullableLong(Long value) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void writeBytes(byte[] src, int srcIndex, int length) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void writeBytes(byte[] src) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void writeBytes(ActiveMQBuffer src, int length) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void writeBytes(ByteBuffer src) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void writeBytes(ByteBuf src, int srcIndex, int length) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    @Override
    public ByteBuffer toByteBuffer() {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    public Object getUnderlyingBuffer() {
        return this;
    }

    @Override
    public boolean readBoolean() {
        return this.readByte() != 0;
    }

    @Override
    public Boolean readNullableBoolean() {
        byte b = this.readByte();
        if (b == 0) {
            return null;
        }
        return this.readBoolean();
    }

    @Override
    public char readChar() {
        return (char)this.readShort();
    }

    @Override
    public char getChar(int index) {
        return (char)this.getShort(index);
    }

    @Override
    public double getDouble(int index) {
        return Double.longBitsToDouble(this.getLong(index));
    }

    @Override
    public float getFloat(int index) {
        return Float.intBitsToFloat(this.getInt(index));
    }

    @Override
    public ActiveMQBuffer readBytes(int length) {
        byte[] bytesToGet = new byte[length];
        this.readBytes(bytesToGet);
        return ActiveMQBuffers.wrappedBuffer(bytesToGet);
    }

    @Override
    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public SimpleString readNullableSimpleString() {
        byte b = this.readByte();
        if (b == 0) {
            return null;
        }
        return this.readSimpleString();
    }

    @Override
    public String readNullableString() {
        byte b = this.readByte();
        if (b == 0) {
            return null;
        }
        return this.readString();
    }

    @Override
    public SimpleString readSimpleString() {
        int len = this.readInt();
        byte[] data = new byte[len];
        this.readBytes(data);
        return new SimpleString(data);
    }

    @Override
    public String readString() {
        int len = this.readInt();
        if (len < 9) {
            char[] chars = new char[len];
            for (int i = 0; i < len; ++i) {
                chars[i] = (char)this.readShort();
            }
            return new String(chars);
        }
        if (len < 4095) {
            return this.readUTF();
        }
        return this.readSimpleString().toString();
    }

    @Override
    public String readUTF() {
        return UTF8Util.readUTF(this);
    }

    @Override
    public void writeBoolean(boolean val) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void writeNullableBoolean(Boolean val) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void writeChar(char val) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void writeDouble(double val) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void writeFloat(float val) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void writeNullableSimpleString(SimpleString val) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void writeNullableString(String val) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void writeSimpleString(SimpleString val) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void writeString(String val) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void writeUTF(String utf) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    @Override
    public ActiveMQBuffer copy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ActiveMQBuffer slice(int index, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuf byteBuf() {
        return null;
    }

    @Override
    public ActiveMQBuffer copy(int index, int length) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    @Override
    public ActiveMQBuffer duplicate() {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    @Override
    public ActiveMQBuffer readSlice(int length) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void setChar(int index, char value) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void setDouble(int index, double value) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void setFloat(int index, float value) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    @Override
    public ActiveMQBuffer slice() {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }

    @Override
    public void writeBytes(ActiveMQBuffer src, int srcIndex, int length) {
        throw new IllegalAccessError(OPERATION_NOT_SUPPORTED);
    }
}

