/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.util;

import java.util.HashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

public class Pool<T> {
    protected final T[] pool;
    protected final Lock[] locks;
    protected final Creator<T> creator;

    public Pool(int capacity, Creator<T> creator) {
        this.creator = creator;
        this.pool = new Object[Util.getNextHigherPowerOfTwo(capacity)];
        this.locks = new Lock[this.pool.length];
        for (int i = 0; i < this.locks.length; ++i) {
            this.locks[i] = new ReentrantLock();
        }
    }

    public T[] getElements() {
        return this.pool;
    }

    public int getNumLocked() {
        int retval = 0;
        for (Lock lock : this.locks) {
            if (!((ReentrantLock)lock).isLocked()) continue;
            ++retval;
        }
        return retval;
    }

    public Element<T> get() {
        int starting_index = (int)(Math.random() * (double)this.pool.length) & this.pool.length - 1;
        for (int i = 0; i < this.locks.length; ++i) {
            int index = starting_index + i & this.pool.length - 1;
            Lock lock = this.locks[index];
            if (!lock.tryLock()) continue;
            if (this.pool[index] != null) {
                return new Element<T>(this.pool[index], lock);
            }
            this.pool[index] = this.creator.create();
            return new Element<T>(this.pool[index], lock);
        }
        return new Element<T>(this.creator.create(), null);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int locked = this.getNumLocked();
        sb.append("capacity=" + this.pool.length + ", locked=" + locked + ", available=" + (this.pool.length - locked));
        return sb.toString();
    }

    public static void main(String[] args) {
        int length = 8;
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>(8);
        for (int i = 0; i < 100; ++i) {
            int index = (int)(Math.random() * 8.0) & 7;
            System.out.println("index = " + index);
            Integer count = (Integer)map.get(index);
            if (count == null) {
                map.put(index, 1);
                continue;
            }
            count = count + 1;
            map.put(index, count);
        }
        System.out.println("map = " + map);
    }

    public class Element<T> {
        protected final T element;
        protected final Lock lock;

        public Element(T element, Lock lock) {
            this.element = element;
            this.lock = lock;
        }

        public T getElement() {
            return this.element;
        }

        public Lock getLock() {
            return this.lock;
        }

        public String toString() {
            return this.element + ", " + this.lock;
        }
    }

    public static interface Creator<T> {
        public T create();
    }
}

