/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.protocols;

import org.apache.activemq.artemis.shaded.org.jgroups.Event;
import org.apache.activemq.artemis.shaded.org.jgroups.Message;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.MBean;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.Property;
import org.apache.activemq.artemis.shaded.org.jgroups.stack.Protocol;
import org.apache.activemq.artemis.shaded.org.jgroups.util.MessageBatch;

@MBean(description="Prints the headers of all sent and/or received messages")
public class HDRS
extends Protocol {
    @Property(description="Enables printing of down messages")
    protected volatile boolean print_down = true;
    @Property(description="Enables printing of up (received) messages")
    protected volatile boolean print_up = true;

    @Override
    public Object up(Event evt) {
        if (this.print_up && evt.getType() == 1) {
            Message msg = (Message)evt.getArg();
            System.out.printf("-- [s] from %s (%d bytes): %s\n", msg.src(), msg.getLength(), msg.printHeaders());
        }
        return this.up_prot.up(evt);
    }

    @Override
    public void up(MessageBatch batch) {
        if (this.print_up) {
            for (Message msg : batch) {
                System.out.printf("-- [b] from %s (%d bytes): %s\n", msg.src(), msg.getLength(), msg.printHeaders());
            }
        }
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }

    @Override
    public Object down(Event evt) {
        if (this.print_down && evt.getType() == 1) {
            Message msg = (Message)evt.getArg();
            System.out.printf("-- to %s (%d bytes): %s\n", msg.dest(), msg.getLength(), msg.printHeaders());
        }
        return this.down_prot.down(evt);
    }
}

