/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.critical;

import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.apache.activemq.artemis.shaded.org.jboss.logging.Logger;
import org.apache.activemq.artemis.utils.critical.CriticalAnalyzer;
import org.apache.activemq.artemis.utils.critical.CriticalComponent;

public class CriticalMeasure {
    private static final Logger logger = Logger.getLogger(CriticalMeasure.class);
    private volatile Exception traceEnter;
    static final AtomicLongFieldUpdater<CriticalMeasure> TIME_ENTER_UPDATER = AtomicLongFieldUpdater.newUpdater(CriticalMeasure.class, "timeEnter");
    static final AtomicLongFieldUpdater<CriticalMeasure> TIME_LEFT_UPDATER = AtomicLongFieldUpdater.newUpdater(CriticalMeasure.class, "timeLeft");
    private volatile long timeEnter;
    private volatile long timeLeft;
    private final int id;
    private final CriticalComponent component;

    public CriticalMeasure(CriticalComponent component, int id) {
        this.id = id;
        this.component = component;
        long time = System.nanoTime();
        TIME_LEFT_UPDATER.set(this, time);
        TIME_ENTER_UPDATER.set(this, time);
    }

    public void enterCritical() {
        TIME_ENTER_UPDATER.lazySet(this, System.nanoTime());
        if (logger.isTraceEnabled()) {
            this.traceEnter = new Exception("entered");
        }
    }

    public void leaveCritical() {
        if (logger.isTraceEnabled()) {
            long nanoTimeout;
            CriticalAnalyzer analyzer;
            CriticalAnalyzer criticalAnalyzer = analyzer = this.component != null ? this.component.getCriticalAnalyzer() : null;
            if (analyzer != null && this.checkExpiration(nanoTimeout = analyzer.getTimeoutNanoSeconds(), false)) {
                logger.trace((Object)("Path " + this.id + " on component " + this.getComponentName() + " is taking too long, leaving at"), new Exception("entered"));
                logger.trace((Object)("Path " + this.id + " on component " + this.getComponentName() + " is taking too long, entered at"), this.traceEnter);
            }
            this.traceEnter = null;
        }
        TIME_LEFT_UPDATER.lazySet(this, System.nanoTime());
    }

    protected String getComponentName() {
        if (this.component == null) {
            return "null";
        }
        return this.component.getClass().getName();
    }

    public boolean checkExpiration(long timeout, boolean reset) {
        long timeEnter;
        long time = System.nanoTime();
        long timeLeft = TIME_LEFT_UPDATER.get(this);
        if (timeLeft - (timeEnter = TIME_ENTER_UPDATER.get(this)) < 0L) {
            boolean expired;
            boolean bl = expired = System.nanoTime() - timeEnter > timeout;
            if (expired) {
                Exception lastTraceEnter = this.traceEnter;
                if (lastTraceEnter != null) {
                    logger.warn((Object)("Component " + this.getComponentName() + " is expired on path " + this.id), lastTraceEnter);
                } else {
                    logger.warn("Component " + this.getComponentName() + " is expired on path " + this.id);
                }
                if (reset) {
                    TIME_LEFT_UPDATER.lazySet(this, time);
                    TIME_ENTER_UPDATER.lazySet(this, time);
                }
            }
            return expired;
        }
        return false;
    }

    public long enterTime() {
        return TIME_ENTER_UPDATER.get(this);
    }

    public long leaveTime() {
        return TIME_LEFT_UPDATER.get(this);
    }
}

