package org.apache.activemq.artemis.logs;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.Generated;
import org.apache.activemq.artemis.shaded.org.jboss.logging.DelegatingBasicLogger;
import org.apache.activemq.artemis.shaded.org.jboss.logging.BasicLogger;
import java.lang.String;
import org.apache.activemq.artemis.shaded.org.jboss.logging.Logger;
import java.lang.Exception;


import static org.apache.activemq.artemis.shaded.org.jboss.logging.Logger.Level.INFO;
import static org.apache.activemq.artemis.shaded.org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.apache.activemq.artemis.shaded.org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2020-08-24T20:29:06+0200")
public class ActiveMQUtilLogger_$logger extends DelegatingBasicLogger implements ActiveMQUtilLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ActiveMQUtilLogger_$logger.class.getName();
    public ActiveMQUtilLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void startingService(final String component) {
        super.log.logv(FQCN, INFO, null, startingService$str(), component);
    }
    protected String startingService$str() {
        return "AMQ201000: Network is healthy, starting service {0}";
    }
    @Override
    public final void stoppingService(final String component) {
        super.log.logv(FQCN, INFO, null, stoppingService$str(), component);
    }
    protected String stoppingService$str() {
        return "AMQ201001: Network is unhealthy, stopping service {0}";
    }
    @Override
    public final void missingPrivsForClassloader() {
        super.log.logv(FQCN, WARN, null, missingPrivsForClassloader$str());
    }
    protected String missingPrivsForClassloader$str() {
        return "AMQ202000: Missing privileges to set Thread Context Class Loader on Thread Factory. Using current Thread Context Class Loader";
    }
    @Override
    public final void addressloopback(final String address) {
        super.log.logv(FQCN, WARN, null, addressloopback$str(), address);
    }
    protected String addressloopback$str() {
        return "AMQ202001: {0} is a loopback address and will be discarded.";
    }
    @Override
    public final void addressWasntReacheable(final String address) {
        super.log.logv(FQCN, WARN, null, addressWasntReacheable$str(), address);
    }
    protected String addressWasntReacheable$str() {
        return "AMQ202002: Ping Address {0} wasn't reacheable.";
    }
    @Override
    public final void urlWasntReacheable(final String url) {
        super.log.logv(FQCN, WARN, null, urlWasntReacheable$str(), url);
    }
    protected String urlWasntReacheable$str() {
        return "AMQ202003: Ping Url {0} wasn't reacheable.";
    }
    @Override
    public final void errorStartingComponent(final Exception e, final String component) {
        super.log.logv(FQCN, WARN, e, errorStartingComponent$str(), component);
    }
    protected String errorStartingComponent$str() {
        return "AMQ202004: Error starting component {0} ";
    }
    @Override
    public final void errorStoppingComponent(final Exception e, final String component) {
        super.log.logv(FQCN, WARN, e, errorStoppingComponent$str(), component);
    }
    protected String errorStoppingComponent$str() {
        return "AMQ202005: Error stopping component {0} ";
    }
    @Override
    public final void failedToCheckURL(final Exception e, final String url) {
        super.log.logv(FQCN, WARN, e, failedToCheckURL$str(), url);
    }
    protected String failedToCheckURL$str() {
        return "AMQ202006: Failed to check Url {0}.";
    }
    @Override
    public final void failedToCheckAddress(final Exception e, final String address) {
        super.log.logv(FQCN, WARN, e, failedToCheckAddress$str(), address);
    }
    protected String failedToCheckAddress$str() {
        return "AMQ202007: Failed to check Address {0}.";
    }
    @Override
    public final void failedToParseAddressList(final Exception e, final String addressList) {
        super.log.logv(FQCN, WARN, e, failedToParseAddressList$str(), addressList);
    }
    protected String failedToParseAddressList$str() {
        return "AMQ202008: Failed to check Address list {0}.";
    }
    @Override
    public final void failedToParseUrlList(final Exception e, final String urlList) {
        super.log.logv(FQCN, WARN, e, failedToParseUrlList$str(), urlList);
    }
    protected String failedToParseUrlList$str() {
        return "AMQ202009: Failed to check Url list {0}.";
    }
    @Override
    public final void failedToSetNIC(final Exception e, final String nic) {
        super.log.logv(FQCN, WARN, e, failedToSetNIC$str(), nic);
    }
    protected String failedToSetNIC$str() {
        return "AMQ202010: Failed to set NIC {0}.";
    }
    @Override
    public final void failedToReadFromStream(final String stream) {
        super.log.logv(FQCN, WARN, null, failedToReadFromStream$str(), stream);
    }
    protected String failedToReadFromStream$str() {
        return "AMQ202011: Failed to read from stream {0}.";
    }
    @Override
    public final void failedToSerializeObject(final Exception e) {
        super.log.logv(FQCN, WARN, e, failedToSerializeObject$str());
    }
    protected String failedToSerializeObject$str() {
        return "AMQ202012: Object cannot be serialized.";
    }
    @Override
    public final void failedToDeserializeObject(final Exception e) {
        super.log.logv(FQCN, WARN, e, failedToDeserializeObject$str());
    }
    protected String failedToDeserializeObject$str() {
        return "AMQ202013: Unable to deserialize object.";
    }
    @Override
    public final void failedToEncodeByteArrayToBase64Notation(final Exception e) {
        super.log.logv(FQCN, WARN, e, failedToEncodeByteArrayToBase64Notation$str());
    }
    protected String failedToEncodeByteArrayToBase64Notation$str() {
        return "AMQ202014: Unable to encode byte array into Base64 notation.";
    }
    @Override
    public final void failedToCleanupFile(final String file) {
        super.log.logv(FQCN, WARN, null, failedToCleanupFile$str(), file);
    }
    protected String failedToCleanupFile$str() {
        return "AMQ202015: Failed to clean up file {0}";
    }
    @Override
    public final void failedListFilesToCleanup(final String path) {
        super.log.logv(FQCN, WARN, null, failedListFilesToCleanup$str(), path);
    }
    protected String failedListFilesToCleanup$str() {
        return "AMQ202016: Could not list files to clean up in {0}";
    }
}
