/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.logs;

import java.security.AccessController;
import java.security.Principal;
import java.util.Arrays;
import java.util.Set;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import org.apache.activemq.artemis.shaded.org.jboss.logging.BasicLogger;
import org.apache.activemq.artemis.shaded.org.jboss.logging.Logger;
import org.apache.activemq.artemis.shaded.org.jboss.logging.annotations.Cause;
import org.apache.activemq.artemis.shaded.org.jboss.logging.annotations.LogMessage;
import org.apache.activemq.artemis.shaded.org.jboss.logging.annotations.Message;
import org.apache.activemq.artemis.shaded.org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="AMQ")
public interface AuditLogger
extends BasicLogger {
    public static final AuditLogger LOGGER = Logger.getMessageLogger(AuditLogger.class, "org.apache.activemq.audit.base");
    public static final AuditLogger RESOURCE_LOGGER = Logger.getMessageLogger(AuditLogger.class, "org.apache.activemq.audit.resource");
    public static final AuditLogger MESSAGE_LOGGER = Logger.getMessageLogger(AuditLogger.class, "org.apache.activemq.audit.message");
    public static final ThreadLocal<String> remoteUrl = new ThreadLocal();
    public static final ThreadLocal<Subject> currentCaller = new ThreadLocal();

    public static boolean isAnyLoggingEnabled() {
        return AuditLogger.isEnabled() || AuditLogger.isMessageEnabled() || AuditLogger.isResourceLoggingEnabled();
    }

    public static boolean isEnabled() {
        return LOGGER.isEnabled(Logger.Level.INFO);
    }

    public static boolean isResourceLoggingEnabled() {
        return RESOURCE_LOGGER.isEnabled(Logger.Level.INFO);
    }

    public static boolean isMessageEnabled() {
        return MESSAGE_LOGGER.isEnabled(Logger.Level.INFO);
    }

    public static String getCaller() {
        Subject subject = Subject.getSubject(AccessController.getContext());
        if (subject == null) {
            subject = currentCaller.get();
        }
        return AuditLogger.getCaller(subject);
    }

    public static String getCaller(String user) {
        Subject subject = Subject.getSubject(AccessController.getContext());
        if (subject == null) {
            subject = currentCaller.get();
        }
        if (subject == null) {
            return user + (remoteUrl.get() == null ? "@unknown" : remoteUrl.get());
        }
        return AuditLogger.getCaller(subject);
    }

    public static String getCaller(Subject subject) {
        String url;
        String user = "anonymous";
        String roles = "";
        String string = url = remoteUrl.get() == null ? "@unknown" : remoteUrl.get();
        if (subject != null) {
            Set<Principal> principals = subject.getPrincipals();
            for (Principal principal : principals) {
                if (principal.getClass().getName().endsWith("UserPrincipal")) {
                    user = principal.getName();
                    continue;
                }
                if (!principal.getClass().getName().endsWith("RolePrincipal")) continue;
                roles = "(" + principal.getName() + ")";
            }
        }
        return user + roles + url;
    }

    public static void setCurrentCaller(Subject caller) {
        currentCaller.set(caller);
    }

    public static void setRemoteAddress(String remoteAddress) {
        String actualAddress = remoteAddress.startsWith("/") ? "@" + remoteAddress.substring(1) : "@" + remoteAddress;
        remoteUrl.set(actualAddress);
    }

    public static String getRemoteAddress() {
        return remoteUrl.get();
    }

    public static String arrayToString(Object value) {
        if (value == null) {
            return "";
        }
        String prefix = "with parameters: ";
        if (value instanceof long[]) {
            return "with parameters: " + Arrays.toString((long[])value);
        }
        if (value instanceof int[]) {
            return "with parameters: " + Arrays.toString((int[])value);
        }
        if (value instanceof char[]) {
            return "with parameters: " + Arrays.toString((char[])value);
        }
        if (value instanceof byte[]) {
            return "with parameters: " + Arrays.toString((byte[])value);
        }
        if (value instanceof float[]) {
            return "with parameters: " + Arrays.toString((float[])value);
        }
        if (value instanceof short[]) {
            return "with parameters: " + Arrays.toString((short[])value);
        }
        if (value instanceof double[]) {
            return "with parameters: " + Arrays.toString((double[])value);
        }
        if (value instanceof boolean[]) {
            return "with parameters: " + Arrays.toString((boolean[])value);
        }
        if (value instanceof Object[]) {
            return "with parameters: " + Arrays.toString((Object[])value);
        }
        return "with parameters: " + value.toString();
    }

    public static void getRoutingTypes(Object source) {
        LOGGER.getRoutingTypes(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601000, value="User {0} is getting routing type property on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getRoutingTypes(String var1, Object var2, Object ... var3);

    public static void getRoutingTypesAsJSON(Object source) {
        LOGGER.getRoutingTypesAsJSON(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601001, value="User {0} is getting routing type property as json on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getRoutingTypesAsJSON(String var1, Object var2, Object ... var3);

    public static void getQueueNames(Object source, Object ... args) {
        LOGGER.getQueueNames(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601002, value="User {0} is getting queue names on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getQueueNames(String var1, Object var2, Object ... var3);

    public static void getBindingNames(Object source) {
        LOGGER.getBindingNames(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601003, value="User {0} is getting binding names on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getBindingNames(String var1, Object var2, Object ... var3);

    public static void getRoles(Object source, Object ... args) {
        LOGGER.getRoles(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601004, value="User {0} is getting roles on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getRoles(String var1, Object var2, Object ... var3);

    public static void getRolesAsJSON(Object source, Object ... args) {
        LOGGER.getRolesAsJSON(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601005, value="User {0} is getting roles as json on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getRolesAsJSON(String var1, Object var2, Object ... var3);

    public static void getNumberOfBytesPerPage(Object source) {
        LOGGER.getNumberOfBytesPerPage(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601006, value="User {0} is getting number of bytes per page on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getNumberOfBytesPerPage(String var1, Object var2, Object ... var3);

    public static void getAddressSize(Object source) {
        LOGGER.getAddressSize(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601007, value="User {0} is getting address size on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getAddressSize(String var1, Object var2, Object ... var3);

    public static void getNumberOfMessages(Object source) {
        LOGGER.getNumberOfMessages(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601008, value="User {0} is getting number of messages on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getNumberOfMessages(String var1, Object var2, Object ... var3);

    public static void isPaging(Object source) {
        LOGGER.isPaging(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601009, value="User {0} is getting isPaging on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void isPaging(String var1, Object var2, Object ... var3);

    public static void getNumberOfPages(Object source) {
        LOGGER.getNumberOfPages(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601010, value="User {0} is getting number of pages on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getNumberOfPages(String var1, Object var2, Object ... var3);

    public static void getRoutedMessageCount(Object source) {
        LOGGER.getRoutedMessageCount(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601011, value="User {0} is getting routed message count on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getRoutedMessageCount(String var1, Object var2, Object ... var3);

    public static void getUnRoutedMessageCount(Object source) {
        LOGGER.getUnRoutedMessageCount(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601012, value="User {0} is getting unrouted message count on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getUnRoutedMessageCount(String var1, Object var2, Object ... var3);

    public static void sendMessage(Object source, String user, Object ... args) {
        LOGGER.sendMessage(AuditLogger.getCaller(user), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601013, value="User {0} is sending a message on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void sendMessage(String var1, Object var2, Object ... var3);

    public static void getName(Object source) {
        LOGGER.getName(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601014, value="User {0} is getting name on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getName(String var1, Object var2, Object ... var3);

    public static void getAddress(Object source) {
        LOGGER.getAddress(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601015, value="User {0} is getting address on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getAddress(String var1, Object var2, Object ... var3);

    public static void getFilter(Object source) {
        LOGGER.getFilter(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601016, value="User {0} is getting filter on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getFilter(String var1, Object var2, Object ... var3);

    public static void isDurable(Object source) {
        LOGGER.isDurable(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601017, value="User {0} is getting durable property on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void isDurable(String var1, Object var2, Object ... var3);

    public static void getMessageCount(Object source) {
        LOGGER.getMessageCount(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601018, value="User {0} is getting message count on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getMessageCount(String var1, Object var2, Object ... var3);

    public static void getMBeanInfo(Object source) {
        LOGGER.getMBeanInfo(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601019, value="User {0} is getting mbean info on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getMBeanInfo(String var1, Object var2, Object ... var3);

    public static void getFactoryClassName(Object source) {
        LOGGER.getFactoryClassName(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601020, value="User {0} is getting factory class name on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getFactoryClassName(String var1, Object var2, Object ... var3);

    public static void getParameters(Object source) {
        LOGGER.getParameters(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601021, value="User {0} is getting parameters on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getParameters(String var1, Object var2, Object ... var3);

    public static void reload(Object source) {
        LOGGER.reload(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601022, value="User {0} is doing reload on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void reload(String var1, Object var2, Object ... var3);

    public static void isStarted(Object source) {
        LOGGER.isStarted(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601023, value="User {0} is querying isStarted on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void isStarted(String var1, Object var2, Object ... var3);

    public static void startAcceptor(Object source) {
        LOGGER.startAcceptor(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601024, value="User {0} is starting an acceptor on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void startAcceptor(String var1, Object var2, Object ... var3);

    public static void stopAcceptor(Object source) {
        LOGGER.stopAcceptor(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601025, value="User {0} is stopping an acceptor on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void stopAcceptor(String var1, Object var2, Object ... var3);

    public static void getVersion(Object source) {
        LOGGER.getVersion(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601026, value="User {0} is getting version on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getVersion(String var1, Object var2, Object ... var3);

    public static void isBackup(Object source) {
        LOGGER.isBackup(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601027, value="User {0} is querying isBackup on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void isBackup(String var1, Object var2, Object ... var3);

    public static void isSharedStore(Object source) {
        LOGGER.isSharedStore(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601028, value="User {0} is querying isSharedStore on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void isSharedStore(String var1, Object var2, Object ... var3);

    public static void getBindingsDirectory(Object source) {
        LOGGER.getBindingsDirectory(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601029, value="User {0} is getting bindings directory on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getBindingsDirectory(String var1, Object var2, Object ... var3);

    public static void getIncomingInterceptorClassNames(Object source) {
        LOGGER.getIncomingInterceptorClassNames(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601030, value="User {0} is getting incoming interceptor class names on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getIncomingInterceptorClassNames(String var1, Object var2, Object ... var3);

    public static void getOutgoingInterceptorClassNames(Object source) {
        LOGGER.getOutgoingInterceptorClassNames(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601031, value="User {0} is getting outgoing interceptor class names on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getOutgoingInterceptorClassNames(String var1, Object var2, Object ... var3);

    public static void getJournalBufferSize(Object source) {
        LOGGER.getJournalBufferSize(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601032, value="User {0} is getting journal buffer size on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getJournalBufferSize(String var1, Object var2, Object ... var3);

    public static void getJournalBufferTimeout(Object source) {
        LOGGER.getJournalBufferTimeout(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601033, value="User {0} is getting journal buffer timeout on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getJournalBufferTimeout(String var1, Object var2, Object ... var3);

    public static void setFailoverOnServerShutdown(Object source, Object ... args) {
        LOGGER.setFailoverOnServerShutdown(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601034, value="User {0} is setting failover on server shutdown on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void setFailoverOnServerShutdown(String var1, Object var2, Object ... var3);

    public static void isFailoverOnServerShutdown(Object source) {
        LOGGER.isFailoverOnServerShutdown(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601035, value="User {0} is querying is-failover-on-server-shutdown on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void isFailoverOnServerShutdown(String var1, Object var2, Object ... var3);

    public static void getJournalMaxIO(Object source) {
        LOGGER.getJournalMaxIO(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601036, value="User {0} is getting journal's max io on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getJournalMaxIO(String var1, Object var2, Object ... var3);

    public static void getJournalDirectory(Object source) {
        LOGGER.getJournalDirectory(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601037, value="User {0} is getting journal directory on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getJournalDirectory(String var1, Object var2, Object ... var3);

    public static void getJournalFileSize(Object source) {
        LOGGER.getJournalFileSize(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601038, value="User {0} is getting journal file size on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getJournalFileSize(String var1, Object var2, Object ... var3);

    public static void getJournalMinFiles(Object source) {
        LOGGER.getJournalMinFiles(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601039, value="User {0} is getting journal min files on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getJournalMinFiles(String var1, Object var2, Object ... var3);

    public static void getJournalCompactMinFiles(Object source) {
        LOGGER.getJournalCompactMinFiles(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601040, value="User {0} is getting journal compact min files on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getJournalCompactMinFiles(String var1, Object var2, Object ... var3);

    public static void getJournalCompactPercentage(Object source) {
        LOGGER.getJournalCompactPercentage(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601041, value="User {0} is getting journal compact percentage on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getJournalCompactPercentage(String var1, Object var2, Object ... var3);

    public static void isPersistenceEnabled(Object source) {
        LOGGER.isPersistenceEnabled(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601042, value="User {0} is querying persistence enabled on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void isPersistenceEnabled(String var1, Object var2, Object ... var3);

    public static void getJournalType(Object source) {
        LOGGER.getJournalType(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601043, value="User {0} is getting journal type on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getJournalType(String var1, Object var2, Object ... var3);

    public static void getPagingDirectory(Object source) {
        LOGGER.getPagingDirectory(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601044, value="User {0} is getting paging directory on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getPagingDirectory(String var1, Object var2, Object ... var3);

    public static void getScheduledThreadPoolMaxSize(Object source) {
        LOGGER.getScheduledThreadPoolMaxSize(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601045, value="User {0} is getting scheduled threadpool max size on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getScheduledThreadPoolMaxSize(String var1, Object var2, Object ... var3);

    public static void getThreadPoolMaxSize(Object source) {
        LOGGER.getThreadPoolMaxSize(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601046, value="User {0} is getting threadpool max size on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getThreadPoolMaxSize(String var1, Object var2, Object ... var3);

    public static void getSecurityInvalidationInterval(Object source) {
        LOGGER.getSecurityInvalidationInterval(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601047, value="User {0} is getting security invalidation interval on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getSecurityInvalidationInterval(String var1, Object var2, Object ... var3);

    public static void isClustered(Object source) {
        LOGGER.isClustered(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601048, value="User {0} is querying is-clustered on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void isClustered(String var1, Object var2, Object ... var3);

    public static void isCreateBindingsDir(Object source) {
        LOGGER.isCreateBindingsDir(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601049, value="User {0} is querying is-create-bindings-dir on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void isCreateBindingsDir(String var1, Object var2, Object ... var3);

    public static void isCreateJournalDir(Object source) {
        LOGGER.isCreateJournalDir(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601050, value="User {0} is querying is-create-journal-dir on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void isCreateJournalDir(String var1, Object var2, Object ... var3);

    public static void isJournalSyncNonTransactional(Object source) {
        LOGGER.isJournalSyncNonTransactional(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601051, value="User {0} is querying is-journal-sync-non-transactional on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void isJournalSyncNonTransactional(String var1, Object var2, Object ... var3);

    public static void isJournalSyncTransactional(Object source) {
        LOGGER.isJournalSyncTransactional(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601052, value="User {0} is querying is-journal-sync-transactional on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void isJournalSyncTransactional(String var1, Object var2, Object ... var3);

    public static void isSecurityEnabled(Object source) {
        LOGGER.isSecurityEnabled(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601053, value="User {0} is querying is-security-enabled on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void isSecurityEnabled(String var1, Object var2, Object ... var3);

    public static void isAsyncConnectionExecutionEnabled(Object source) {
        LOGGER.isAsyncConnectionExecutionEnabled(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601054, value="User {0} is query is-async-connection-execution-enabled on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void isAsyncConnectionExecutionEnabled(String var1, Object var2, Object ... var3);

    public static void getDiskScanPeriod(Object source) {
        LOGGER.getDiskScanPeriod(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601055, value="User {0} is getting disk scan period on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getDiskScanPeriod(String var1, Object var2, Object ... var3);

    public static void getMaxDiskUsage(Object source) {
        LOGGER.getMaxDiskUsage(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601056, value="User {0} is getting max disk usage on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getMaxDiskUsage(String var1, Object var2, Object ... var3);

    public static void getGlobalMaxSize(Object source) {
        LOGGER.getGlobalMaxSize(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601057, value="User {0} is getting global max size on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getGlobalMaxSize(String var1, Object var2, Object ... var3);

    public static void getAddressMemoryUsage(Object source) {
        LOGGER.getAddressMemoryUsage(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601058, value="User {0} is getting address memory usage on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getAddressMemoryUsage(String var1, Object var2, Object ... var3);

    public static void getAddressMemoryUsagePercentage(Object source) {
        LOGGER.getAddressMemoryUsagePercentage(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601059, value="User {0} is getting address memory usage percentage on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getAddressMemoryUsagePercentage(String var1, Object var2, Object ... var3);

    public static void freezeReplication(Object source) {
        LOGGER.freezeReplication(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601060, value="User {0} is freezing replication on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void freezeReplication(String var1, Object var2, Object ... var3);

    public static void createAddress(Object source, Object ... args) {
        LOGGER.createAddress(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601061, value="User {0} is creating an address on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void createAddress(String var1, Object var2, Object ... var3);

    public static void updateAddress(Object source, Object ... args) {
        LOGGER.updateAddress(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601062, value="User {0} is updating an address on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void updateAddress(String var1, Object var2, Object ... var3);

    public static void deleteAddress(Object source, Object ... args) {
        LOGGER.deleteAddress(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601063, value="User {0} is deleting an address on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void deleteAddress(String var1, Object var2, Object ... var3);

    public static void deployQueue(Object source, Object ... args) {
        LOGGER.deployQueue(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601064, value="User {0} is creating a queue on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void deployQueue(String var1, Object var2, Object ... var3);

    public static void createQueue(Object source, String user, Object ... args) {
        RESOURCE_LOGGER.createQueue(AuditLogger.getCaller(user), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601065, value="User {0} is creating a queue on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void createQueue(String var1, Object var2, Object ... var3);

    public static void updateQueue(Object source, Object ... args) {
        LOGGER.updateQueue(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601066, value="User {0} is updating a queue on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void updateQueue(String var1, Object var2, Object ... var3);

    public static void getClusterConnectionNames(Object source) {
        LOGGER.getClusterConnectionNames(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601067, value="User {0} is getting cluster connection names on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getClusterConnectionNames(String var1, Object var2, Object ... var3);

    public static void getUptime(Object source) {
        LOGGER.getUptime(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601068, value="User {0} is getting uptime on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getUptime(String var1, Object var2, Object ... var3);

    public static void getUptimeMillis(Object source) {
        LOGGER.getUptimeMillis(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601069, value="User {0} is getting uptime in milliseconds on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getUptimeMillis(String var1, Object var2, Object ... var3);

    public static void isReplicaSync(Object source) {
        LOGGER.isReplicaSync(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601070, value="User {0} is querying is-replica-sync on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void isReplicaSync(String var1, Object var2, Object ... var3);

    public static void getAddressNames(Object source) {
        LOGGER.getAddressNames(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601071, value="User {0} is getting address names on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getAddressNames(String var1, Object var2, Object ... var3);

    public static void destroyQueue(Object source, String user, Object ... args) {
        LOGGER.destroyQueue(AuditLogger.getCaller(user), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601072, value="User {0} is deleting a queue on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void destroyQueue(String var1, Object var2, Object ... var3);

    public static void getAddressInfo(Object source, Object ... args) {
        LOGGER.getAddressInfo(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601073, value="User {0} is getting address info on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getAddressInfo(String var1, Object var2, Object ... var3);

    public static void listBindingsForAddress(Object source, Object ... args) {
        LOGGER.listBindingsForAddress(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601074, value="User {0} is listing bindings for address on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void listBindingsForAddress(String var1, Object var2, Object ... var3);

    public static void listAddresses(Object source, Object ... args) {
        LOGGER.listAddresses(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601075, value="User {0} is listing addresses on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void listAddresses(String var1, Object var2, Object ... var3);

    public static void getConnectionCount(Object source, Object ... args) {
        LOGGER.getConnectionCount(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601076, value="User {0} is getting connection count on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getConnectionCount(String var1, Object var2, Object ... var3);

    public static void getTotalConnectionCount(Object source) {
        LOGGER.getTotalConnectionCount(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601077, value="User {0} is getting total connection count on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getTotalConnectionCount(String var1, Object var2, Object ... var3);

    public static void getTotalMessageCount(Object source) {
        LOGGER.getTotalMessageCount(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601078, value="User {0} is getting total message count on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getTotalMessageCount(String var1, Object var2, Object ... var3);

    public static void getTotalMessagesAdded(Object source) {
        LOGGER.getTotalMessagesAdded(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601079, value="User {0} is getting total messages added on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getTotalMessagesAdded(String var1, Object var2, Object ... var3);

    public static void getTotalMessagesAcknowledged(Object source) {
        LOGGER.getTotalMessagesAcknowledged(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601080, value="User {0} is getting total messages acknowledged on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getTotalMessagesAcknowledged(String var1, Object var2, Object ... var3);

    public static void getTotalConsumerCount(Object source) {
        LOGGER.getTotalConsumerCount(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601081, value="User {0} is getting total consumer count on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getTotalConsumerCount(String var1, Object var2, Object ... var3);

    public static void enableMessageCounters(Object source) {
        LOGGER.enableMessageCounters(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601082, value="User {0} is enabling message counters on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void enableMessageCounters(String var1, Object var2, Object ... var3);

    public static void disableMessageCounters(Object source) {
        LOGGER.disableMessageCounters(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601083, value="User {0} is disabling message counters on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void disableMessageCounters(String var1, Object var2, Object ... var3);

    public static void resetAllMessageCounters(Object source) {
        LOGGER.resetAllMessageCounters(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601084, value="User {0} is resetting all message counters on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void resetAllMessageCounters(String var1, Object var2, Object ... var3);

    public static void resetAllMessageCounterHistories(Object source) {
        LOGGER.resetAllMessageCounterHistories(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601085, value="User {0} is resetting all message counter histories on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void resetAllMessageCounterHistories(String var1, Object var2, Object ... var3);

    public static void isMessageCounterEnabled(Object source) {
        LOGGER.isMessageCounterEnabled(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601086, value="User {0} is querying is-message-counter-enabled on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void isMessageCounterEnabled(String var1, Object var2, Object ... var3);

    public static void getMessageCounterSamplePeriod(Object source) {
        LOGGER.getMessageCounterSamplePeriod(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601087, value="User {0} is getting message counter sample period on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getMessageCounterSamplePeriod(String var1, Object var2, Object ... var3);

    public static void setMessageCounterSamplePeriod(Object source, Object ... args) {
        LOGGER.setMessageCounterSamplePeriod(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601088, value="User {0} is setting message counter sample period on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void setMessageCounterSamplePeriod(String var1, Object var2, Object ... var3);

    public static void getMessageCounterMaxDayCount(Object source) {
        LOGGER.getMessageCounterMaxDayCount(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601089, value="User {0} is getting message counter max day count on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getMessageCounterMaxDayCount(String var1, Object var2, Object ... var3);

    public static void setMessageCounterMaxDayCount(Object source, Object ... args) {
        LOGGER.setMessageCounterMaxDayCount(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601090, value="User {0} is setting message counter max day count on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void setMessageCounterMaxDayCount(String var1, Object var2, Object ... var3);

    public static void listPreparedTransactions(Object source) {
        LOGGER.listPreparedTransactions(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601091, value="User {0} is listing prepared transactions on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void listPreparedTransactions(String var1, Object var2, Object ... var3);

    public static void listPreparedTransactionDetailsAsJSON(Object source) {
        LOGGER.listPreparedTransactionDetailsAsJSON(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601092, value="User {0} is listing prepared transaction details as json on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void listPreparedTransactionDetailsAsJSON(String var1, Object var2, Object ... var3);

    public static void listPreparedTransactionDetailsAsHTML(Object source, Object ... args) {
        LOGGER.listPreparedTransactionDetailsAsHTML(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601093, value="User {0} is listing prepared transaction details as HTML on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void listPreparedTransactionDetailsAsHTML(String var1, Object var2, Object ... var3);

    public static void listHeuristicCommittedTransactions(Object source) {
        LOGGER.listHeuristicCommittedTransactions(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601094, value="User {0} is listing heuristic committed transactions on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void listHeuristicCommittedTransactions(String var1, Object var2, Object ... var3);

    public static void listHeuristicRolledBackTransactions(Object source) {
        LOGGER.listHeuristicRolledBackTransactions(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601095, value="User {0} is listing heuristic rolled back transactions on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void listHeuristicRolledBackTransactions(String var1, Object var2, Object ... var3);

    public static void commitPreparedTransaction(Object source, Object ... args) {
        LOGGER.commitPreparedTransaction(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601096, value="User {0} is commiting prepared transaction on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void commitPreparedTransaction(String var1, Object var2, Object ... var3);

    public static void rollbackPreparedTransaction(Object source, Object ... args) {
        LOGGER.rollbackPreparedTransaction(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601097, value="User {0} is rolling back prepared transaction on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void rollbackPreparedTransaction(String var1, Object var2, Object ... var3);

    public static void listRemoteAddresses(Object source, Object ... args) {
        LOGGER.listRemoteAddresses(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601098, value="User {0} is listing remote addresses on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void listRemoteAddresses(String var1, Object var2, Object ... var3);

    public static void closeConnectionsForAddress(Object source, Object ... args) {
        LOGGER.closeConnectionsForAddress(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601099, value="User {0} is closing connections for address on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void closeConnectionsForAddress(String var1, Object var2, Object ... var3);

    public static void closeConsumerConnectionsForAddress(Object source, Object ... args) {
        LOGGER.closeConsumerConnectionsForAddress(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601100, value="User {0} is closing consumer connections for address on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void closeConsumerConnectionsForAddress(String var1, Object var2, Object ... var3);

    public static void closeConnectionsForUser(Object source, Object ... args) {
        LOGGER.closeConnectionsForUser(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601101, value="User {0} is closing connections for user on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void closeConnectionsForUser(String var1, Object var2, Object ... var3);

    public static void closeConnectionWithID(Object source, Object ... args) {
        LOGGER.closeConnectionWithID(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601102, value="User {0} is closing a connection by ID on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void closeConnectionWithID(String var1, Object var2, Object ... var3);

    public static void closeSessionWithID(Object source, Object ... args) {
        LOGGER.closeSessionWithID(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601103, value="User {0} is closing session with id on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void closeSessionWithID(String var1, Object var2, Object ... var3);

    public static void closeConsumerWithID(Object source, Object ... args) {
        LOGGER.closeConsumerWithID(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601104, value="User {0} is closing consumer with id on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void closeConsumerWithID(String var1, Object var2, Object ... var3);

    public static void listConnectionIDs(Object source) {
        LOGGER.listConnectionIDs(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601105, value="User {0} is listing connection IDs on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void listConnectionIDs(String var1, Object var2, Object ... var3);

    public static void listSessions(Object source, Object ... args) {
        LOGGER.listSessions(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601106, value="User {0} is listing sessions on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void listSessions(String var1, Object var2, Object ... var3);

    public static void listProducersInfoAsJSON(Object source) {
        LOGGER.listProducersInfoAsJSON(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601107, value="User {0} is listing producers info as json on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void listProducersInfoAsJSON(String var1, Object var2, Object ... var3);

    public static void listConnections(Object source, Object ... args) {
        LOGGER.listConnections(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601108, value="User {0} is listing connections on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void listConnections(String var1, Object var2, Object ... var3);

    public static void listConsumers(Object source, Object ... args) {
        LOGGER.listConsumers(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601109, value="User {0} is listing consumers on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void listConsumers(String var1, Object var2, Object ... var3);

    public static void listQueues(Object source, Object ... args) {
        LOGGER.listQueues(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601110, value="User {0} is listing queues on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void listQueues(String var1, Object var2, Object ... var3);

    public static void listProducers(Object source, Object ... args) {
        LOGGER.listProducers(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601111, value="User {0} is listing producers on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void listProducers(String var1, Object var2, Object ... var3);

    public static void listConnectionsAsJSON(Object source) {
        LOGGER.listConnectionsAsJSON(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601112, value="User {0} is listing connections as json on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void listConnectionsAsJSON(String var1, Object var2, Object ... var3);

    public static void listSessionsAsJSON(Object source, Object ... args) {
        LOGGER.listSessionsAsJSON(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601113, value="User {0} is listing sessions as json on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void listSessionsAsJSON(String var1, Object var2, Object ... var3);

    public static void listAllSessionsAsJSON(Object source) {
        LOGGER.listAllSessionsAsJSON(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601114, value="User {0} is listing all sessions as json on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void listAllSessionsAsJSON(String var1, Object var2, Object ... var3);

    public static void listConsumersAsJSON(Object source, Object ... args) {
        LOGGER.listConsumersAsJSON(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601115, value="User {0} is listing consumers as json on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void listConsumersAsJSON(String var1, Object var2, Object ... var3);

    public static void listAllConsumersAsJSON(Object source) {
        LOGGER.listAllConsumersAsJSON(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601116, value="User {0} is listing all consumers as json on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void listAllConsumersAsJSON(String var1, Object var2, Object ... var3);

    public static void getConnectors(Object source) {
        LOGGER.getConnectors(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601117, value="User {0} is getting connectors on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getConnectors(String var1, Object var2, Object ... var3);

    public static void getConnectorsAsJSON(Object source) {
        LOGGER.getConnectorsAsJSON(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601118, value="User {0} is getting connectors as json on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getConnectorsAsJSON(String var1, Object var2, Object ... var3);

    public static void addSecuritySettings(Object source, Object ... args) {
        LOGGER.addSecuritySettings(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601119, value="User {0} is adding security settings on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void addSecuritySettings(String var1, Object var2, Object ... var3);

    public static void removeSecuritySettings(Object source, Object ... args) {
        LOGGER.removeSecuritySettings(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601120, value="User {0} is removing security settings on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void removeSecuritySettings(String var1, Object var2, Object ... var3);

    public static void getAddressSettingsAsJSON(Object source, Object ... args) {
        LOGGER.getAddressSettingsAsJSON(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601121, value="User {0} is getting address settings as json on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getAddressSettingsAsJSON(String var1, Object var2, Object ... var3);

    public static void addAddressSettings(Object source, Object ... args) {
        LOGGER.addAddressSettings(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601122, value="User {0} is adding addressSettings on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void addAddressSettings(String var1, Object var2, Object ... var3);

    public static void removeAddressSettings(Object source, Object ... args) {
        LOGGER.removeAddressSettings(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601123, value="User {0} is removing address settings on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void removeAddressSettings(String var1, Object var2, Object ... var3);

    public static void getDivertNames(Object source) {
        LOGGER.getDivertNames(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601124, value="User {0} is getting divert names on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getDivertNames(String var1, Object var2, Object ... var3);

    public static void createDivert(Object source, Object ... args) {
        LOGGER.createDivert(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601125, value="User {0} is creating a divert on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void createDivert(String var1, Object var2, Object ... var3);

    public static void destroyDivert(Object source, Object ... args) {
        LOGGER.destroyDivert(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601126, value="User {0} is destroying a divert on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void destroyDivert(String var1, Object var2, Object ... var3);

    public static void getBridgeNames(Object source) {
        LOGGER.getBridgeNames(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601127, value="User {0} is getting bridge names on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getBridgeNames(String var1, Object var2, Object ... var3);

    public static void createBridge(Object source, Object ... args) {
        LOGGER.createBridge(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601128, value="User {0} is creating a bridge on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void createBridge(String var1, Object var2, Object ... var3);

    public static void destroyBridge(Object source, Object ... args) {
        LOGGER.destroyBridge(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601129, value="User {0} is destroying a bridge on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void destroyBridge(String var1, Object var2, Object ... var3);

    public static void createConnectorService(Object source, Object ... args) {
        LOGGER.createConnectorService(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601130, value="User {0} is creating connector service on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void createConnectorService(String var1, Object var2, Object ... var3);

    public static void destroyConnectorService(Object source, Object ... args) {
        LOGGER.destroyConnectorService(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601131, value="User {0} is destroying connector service on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void destroyConnectorService(String var1, Object var2, Object ... var3);

    public static void getConnectorServices(Object source, Object ... args) {
        LOGGER.getConnectorServices(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601132, value="User {0} is getting connector services on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getConnectorServices(String var1, Object var2, Object ... var3);

    public static void forceFailover(Object source) {
        LOGGER.forceFailover(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601133, value="User {0} is forceing a failover on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void forceFailover(String var1, Object var2, Object ... var3);

    public static void scaleDown(Object source, Object ... args) {
        LOGGER.scaleDown(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601134, value="User {0} is performing scale down on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void scaleDown(String var1, Object var2, Object ... var3);

    public static void listNetworkTopology(Object source) {
        LOGGER.listNetworkTopology(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601135, value="User {0} is listing network topology on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void listNetworkTopology(String var1, Object var2, Object ... var3);

    public static void removeNotificationListener(Object source, Object ... args) {
        LOGGER.removeNotificationListener(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601136, value="User {0} is removing notification listener on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void removeNotificationListener(String var1, Object var2, Object ... var3);

    public static void addNotificationListener(Object source, Object ... args) {
        LOGGER.addNotificationListener(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601137, value="User {0} is adding notification listener on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void addNotificationListener(String var1, Object var2, Object ... var3);

    public static void getNotificationInfo(Object source) {
        LOGGER.getNotificationInfo(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601138, value="User {0} is getting notification info on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getNotificationInfo(String var1, Object var2, Object ... var3);

    public static void getConnectionTTLOverride(Object source) {
        LOGGER.getConnectionTTLOverride(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601139, value="User {0} is getting connection ttl override on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getConnectionTTLOverride(String var1, Object var2, Object ... var3);

    public static void getIDCacheSize(Object source) {
        LOGGER.getIDCacheSize(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601140, value="User {0} is getting ID cache size on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getIDCacheSize(String var1, Object var2, Object ... var3);

    public static void getLargeMessagesDirectory(Object source) {
        LOGGER.getLargeMessagesDirectory(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601141, value="User {0} is getting large message directory on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getLargeMessagesDirectory(String var1, Object var2, Object ... var3);

    public static void getManagementAddress(Object source) {
        LOGGER.getManagementAddress(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601142, value="User {0} is getting management address on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getManagementAddress(String var1, Object var2, Object ... var3);

    public static void getNodeID(Object source) {
        LOGGER.getNodeID(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601143, value="User {0} is getting node ID on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getNodeID(String var1, Object var2, Object ... var3);

    public static void getManagementNotificationAddress(Object source) {
        LOGGER.getManagementNotificationAddress(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601144, value="User {0} is getting management notification address on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getManagementNotificationAddress(String var1, Object var2, Object ... var3);

    public static void getMessageExpiryScanPeriod(Object source) {
        LOGGER.getMessageExpiryScanPeriod(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601145, value="User {0} is getting message expiry scan period on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getMessageExpiryScanPeriod(String var1, Object var2, Object ... var3);

    public static void getMessageExpiryThreadPriority(Object source) {
        LOGGER.getMessageExpiryThreadPriority(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601146, value="User {0} is getting message expiry thread priority on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getMessageExpiryThreadPriority(String var1, Object var2, Object ... var3);

    public static void getTransactionTimeout(Object source) {
        LOGGER.getTransactionTimeout(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601147, value="User {0} is getting transaction timeout on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getTransactionTimeout(String var1, Object var2, Object ... var3);

    public static void getTransactionTimeoutScanPeriod(Object source) {
        LOGGER.getTransactionTimeoutScanPeriod(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601148, value="User {0} is getting transaction timeout scan period on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getTransactionTimeoutScanPeriod(String var1, Object var2, Object ... var3);

    public static void isPersistDeliveryCountBeforeDelivery(Object source) {
        LOGGER.isPersistDeliveryCountBeforeDelivery(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601149, value="User {0} is querying is-persist-delivery-before-delivery on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void isPersistDeliveryCountBeforeDelivery(String var1, Object var2, Object ... var3);

    public static void isPersistIDCache(Object source) {
        LOGGER.isPersistIDCache(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601150, value="User {0} is querying is-persist-id-cache on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void isPersistIDCache(String var1, Object var2, Object ... var3);

    public static void isWildcardRoutingEnabled(Object source) {
        LOGGER.isWildcardRoutingEnabled(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601151, value="User {0} is querying is-wildcard-routing-enabled on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void isWildcardRoutingEnabled(String var1, Object var2, Object ... var3);

    public static void addUser(Object source, Object ... args) {
        LOGGER.addUser(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601152, value="User {0} is adding a user on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void addUser(String var1, Object var2, Object ... var3);

    public static void listUser(Object source, Object ... args) {
        LOGGER.listUser(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601153, value="User {0} is listing a user on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void listUser(String var1, Object var2, Object ... var3);

    public static void removeUser(Object source, Object ... args) {
        LOGGER.removeUser(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601154, value="User {0} is removing a user on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void removeUser(String var1, Object var2, Object ... var3);

    public static void resetUser(Object source, Object ... args) {
        LOGGER.resetUser(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601155, value="User {0} is resetting a user on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void resetUser(String var1, Object var2, Object ... var3);

    public static void getUser(Object source) {
        LOGGER.getUser(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601156, value="User {0} is getting user property on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getUser(String var1, Object var2, Object ... var3);

    public static void getRoutingType(Object source) {
        LOGGER.getRoutingType(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601157, value="User {0} is getting routing type property on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getRoutingType(String var1, Object var2, Object ... var3);

    public static void isTemporary(Object source) {
        LOGGER.isTemporary(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601158, value="User {0} is getting temporary property on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void isTemporary(String var1, Object var2, Object ... var3);

    public static void getPersistentSize(Object source) {
        LOGGER.getPersistentSize(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601159, value="User {0} is getting persistent size on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getPersistentSize(String var1, Object var2, Object ... var3);

    public static void getDurableMessageCount(Object source) {
        LOGGER.getDurableMessageCount(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601160, value="User {0} is getting durable message count on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getDurableMessageCount(String var1, Object var2, Object ... var3);

    public static void getDurablePersistSize(Object source) {
        LOGGER.getDurablePersistSize(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601161, value="User {0} is getting durable persist size on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getDurablePersistSize(String var1, Object var2, Object ... var3);

    public static void getConsumerCount(Object source) {
        LOGGER.getConsumerCount(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601162, value="User {0} is getting consumer count on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getConsumerCount(String var1, Object var2, Object ... var3);

    public static void getDeliveringCount(Object source) {
        LOGGER.getDeliveringCount(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601163, value="User {0} is getting delivering count on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getDeliveringCount(String var1, Object var2, Object ... var3);

    public static void getDeliveringSize(Object source) {
        LOGGER.getDeliveringSize(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601164, value="User {0} is getting delivering size on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getDeliveringSize(String var1, Object var2, Object ... var3);

    public static void getDurableDeliveringCount(Object source) {
        LOGGER.getDurableDeliveringCount(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601165, value="User {0} is getting durable delivering count on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getDurableDeliveringCount(String var1, Object var2, Object ... var3);

    public static void getDurableDeliveringSize(Object source) {
        LOGGER.getDurableDeliveringSize(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601166, value="User {0} is getting durable delivering size on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getDurableDeliveringSize(String var1, Object var2, Object ... var3);

    public static void getMessagesAdded(Object source) {
        LOGGER.getMessagesAdded(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601167, value="User {0} is getting messages added on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getMessagesAdded(String var1, Object var2, Object ... var3);

    public static void getMessagesAcknowledged(Object source) {
        LOGGER.getMessagesAcknowledged(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601168, value="User {0} is getting messages acknowledged on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getMessagesAcknowledged(String var1, Object var2, Object ... var3);

    public static void getMessagesExpired(Object source) {
        LOGGER.getMessagesExpired(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601169, value="User {0} is getting messages expired on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getMessagesExpired(String var1, Object var2, Object ... var3);

    public static void getMessagesKilled(Object source) {
        LOGGER.getMessagesKilled(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601170, value="User {0} is getting messages killed on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getMessagesKilled(String var1, Object var2, Object ... var3);

    public static void getID(Object source) {
        LOGGER.getID(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601171, value="User {0} is getting ID on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getID(String var1, Object var2, Object ... var3);

    public static void getScheduledCount(Object source) {
        LOGGER.getScheduledCount(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601172, value="User {0} is getting scheduled count on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getScheduledCount(String var1, Object var2, Object ... var3);

    public static void getScheduledSize(Object source) {
        LOGGER.getScheduledSize(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601173, value="User {0} is getting scheduled size on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getScheduledSize(String var1, Object var2, Object ... var3);

    public static void getDurableScheduledCount(Object source) {
        LOGGER.getDurableScheduledCount(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601174, value="User {0} is getting durable scheduled count on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getDurableScheduledCount(String var1, Object var2, Object ... var3);

    public static void getDurableScheduledSize(Object source) {
        LOGGER.getDurableScheduledSize(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601175, value="User {0} is getting durable scheduled size on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getDurableScheduledSize(String var1, Object var2, Object ... var3);

    public static void getDeadLetterAddress(Object source) {
        LOGGER.getDeadLetterAddress(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601176, value="User {0} is getting dead letter address on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getDeadLetterAddress(String var1, Object var2, Object ... var3);

    public static void getExpiryAddress(Object source) {
        LOGGER.getExpiryAddress(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601177, value="User {0} is getting expiry address on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getExpiryAddress(String var1, Object var2, Object ... var3);

    public static void getMaxConsumers(Object source) {
        LOGGER.getMaxConsumers(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601178, value="User {0} is getting max consumers on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getMaxConsumers(String var1, Object var2, Object ... var3);

    public static void isPurgeOnNoConsumers(Object source) {
        LOGGER.isPurgeOnNoConsumers(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601179, value="User {0} is getting purge-on-consumers property on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void isPurgeOnNoConsumers(String var1, Object var2, Object ... var3);

    public static void isConfigurationManaged(Object source) {
        LOGGER.isConfigurationManaged(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601180, value="User {0} is getting configuration-managed property on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void isConfigurationManaged(String var1, Object var2, Object ... var3);

    public static void isExclusive(Object source) {
        LOGGER.isExclusive(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601181, value="User {0} is getting exclusive property on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void isExclusive(String var1, Object var2, Object ... var3);

    public static void isLastValue(Object source) {
        LOGGER.isLastValue(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601182, value="User {0} is getting last-value property on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void isLastValue(String var1, Object var2, Object ... var3);

    public static void listScheduledMessages(Object source) {
        LOGGER.listScheduledMessages(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601183, value="User {0} is listing scheduled messages on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void listScheduledMessages(String var1, Object var2, Object ... var3);

    public static void listScheduledMessagesAsJSON(Object source) {
        LOGGER.listScheduledMessagesAsJSON(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601184, value="User {0} is listing scheduled messages as json on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void listScheduledMessagesAsJSON(String var1, Object var2, Object ... var3);

    public static void listDeliveringMessages(Object source) {
        LOGGER.listDeliveringMessages(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601185, value="User {0} is listing delivering messages on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void listDeliveringMessages(String var1, Object var2, Object ... var3);

    public static void listDeliveringMessagesAsJSON(Object source) {
        LOGGER.listDeliveringMessagesAsJSON(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601186, value="User {0} is listing delivering messages as json on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void listDeliveringMessagesAsJSON(String var1, Object var2, Object ... var3);

    public static void listMessages(Object source, Object ... args) {
        LOGGER.listMessages(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601187, value="User {0} is listing messages on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void listMessages(String var1, Object var2, Object ... var3);

    public static void listMessagesAsJSON(Object source) {
        LOGGER.listMessagesAsJSON(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601188, value="User {0} is listing messages as json on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void listMessagesAsJSON(String var1, Object var2, Object ... var3);

    public static void getFirstMessage(Object source) {
        LOGGER.getFirstMessage(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601189, value="User {0} is getting first message on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getFirstMessage(String var1, Object var2, Object ... var3);

    public static void getFirstMessageAsJSON(Object source) {
        LOGGER.getFirstMessageAsJSON(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601190, value="User {0} is getting first message as json on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getFirstMessageAsJSON(String var1, Object var2, Object ... var3);

    public static void getFirstMessageTimestamp(Object source) {
        LOGGER.getFirstMessageTimestamp(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601191, value="User {0} is getting first message's timestamp on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getFirstMessageTimestamp(String var1, Object var2, Object ... var3);

    public static void getFirstMessageAge(Object source) {
        LOGGER.getFirstMessageAge(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601192, value="User {0} is getting first message's age on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getFirstMessageAge(String var1, Object var2, Object ... var3);

    public static void countMessages(Object source, Object ... args) {
        LOGGER.countMessages(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601193, value="User {0} is counting messages on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void countMessages(String var1, Object var2, Object ... var3);

    public static void countDeliveringMessages(Object source, Object ... args) {
        LOGGER.countDeliveringMessages(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601194, value="User {0} is counting delivery messages on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void countDeliveringMessages(String var1, Object var2, Object ... var3);

    public static void removeMessage(Object source, Object ... args) {
        LOGGER.removeMessage(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601195, value="User {0} is removing a message on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void removeMessage(String var1, Object var2, Object ... var3);

    public static void removeMessages(Object source, Object ... args) {
        LOGGER.removeMessages(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601196, value="User {0} is removing messages on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void removeMessages(String var1, Object var2, Object ... var3);

    public static void expireMessage(Object source, Object ... args) {
        LOGGER.expireMessage(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601197, value="User {0} is expiring messages on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void expireMessage(String var1, Object var2, Object ... var3);

    public static void expireMessages(Object source, Object ... args) {
        LOGGER.expireMessages(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601198, value="User {0} is expiring messages on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void expireMessages(String var1, Object var2, Object ... var3);

    public static void retryMessage(Object source, Object ... args) {
        LOGGER.retryMessage(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601199, value="User {0} is retry sending message on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void retryMessage(String var1, Object var2, Object ... var3);

    public static void retryMessages(Object source) {
        LOGGER.retryMessages(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601200, value="User {0} is retry sending messages on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void retryMessages(String var1, Object var2, Object ... var3);

    public static void moveMessage(Object source, Object ... args) {
        LOGGER.moveMessage(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601201, value="User {0} is moving a message to another queue on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void moveMessage(String var1, Object var2, Object ... var3);

    public static void moveMessages(Object source, Object ... args) {
        LOGGER.moveMessages(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601202, value="User {0} is moving messages to another queue on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void moveMessages(String var1, Object var2, Object ... var3);

    public static void sendMessagesToDeadLetterAddress(Object source, Object ... args) {
        LOGGER.sendMessagesToDeadLetterAddress(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601203, value="User {0} is sending messages to dead letter address on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void sendMessagesToDeadLetterAddress(String var1, Object var2, Object ... var3);

    public static void sendMessageToDeadLetterAddress(Object source, Object ... args) {
        LOGGER.sendMessageToDeadLetterAddress(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601204, value="User {0} is sending messages to dead letter address on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void sendMessageToDeadLetterAddress(String var1, Object var2, Object ... var3);

    public static void changeMessagesPriority(Object source, Object ... args) {
        LOGGER.changeMessagesPriority(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601205, value="User {0} is changing message's priority on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void changeMessagesPriority(String var1, Object var2, Object ... var3);

    public static void changeMessagePriority(Object source, Object ... args) {
        LOGGER.changeMessagePriority(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601206, value="User {0} is changing a message's priority on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void changeMessagePriority(String var1, Object var2, Object ... var3);

    public static void listMessageCounter(Object source) {
        LOGGER.listMessageCounter(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601207, value="User {0} is listing message counter on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void listMessageCounter(String var1, Object var2, Object ... var3);

    public static void resetMessageCounter(Object source) {
        LOGGER.resetMessageCounter(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601208, value="User {0} is resetting message counter on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void resetMessageCounter(String var1, Object var2, Object ... var3);

    public static void listMessageCounterAsHTML(Object source) {
        LOGGER.listMessageCounterAsHTML(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601209, value="User {0} is listing message counter as HTML on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void listMessageCounterAsHTML(String var1, Object var2, Object ... var3);

    public static void listMessageCounterHistory(Object source) {
        LOGGER.listMessageCounterHistory(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601210, value="User {0} is listing message counter history on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void listMessageCounterHistory(String var1, Object var2, Object ... var3);

    public static void listMessageCounterHistoryAsHTML(Object source) {
        LOGGER.listMessageCounterHistoryAsHTML(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601211, value="User {0} is listing message counter history as HTML on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void listMessageCounterHistoryAsHTML(String var1, Object var2, Object ... var3);

    public static void pause(Object source, Object ... args) {
        LOGGER.pause(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601212, value="User {0} is pausing on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void pause(String var1, Object var2, Object ... var3);

    public static void resume(Object source) {
        LOGGER.resume(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601213, value="User {0} is resuming on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void resume(String var1, Object var2, Object ... var3);

    public static void isPaused(Object source) {
        LOGGER.isPaused(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601214, value="User {0} is getting paused property on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void isPaused(String var1, Object var2, Object ... var3);

    public static void browse(Object source, Object ... args) {
        LOGGER.browse(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601215, value="User {0} is browsing a queue on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void browse(String var1, Object var2, Object ... var3);

    public static void flushExecutor(Object source) {
        LOGGER.flushExecutor(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601216, value="User {0} is flushing executor on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void flushExecutor(String var1, Object var2, Object ... var3);

    public static void resetAllGroups(Object source) {
        LOGGER.resetAllGroups(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601217, value="User {0} is resetting all groups on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void resetAllGroups(String var1, Object var2, Object ... var3);

    public static void resetGroup(Object source, Object ... args) {
        LOGGER.resetGroup(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601218, value="User {0} is resetting group on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void resetGroup(String var1, Object var2, Object ... var3);

    public static void getGroupCount(Object source, Object ... args) {
        LOGGER.getGroupCount(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601219, value="User {0} is getting group count on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getGroupCount(String var1, Object var2, Object ... var3);

    public static void listGroupsAsJSON(Object source) {
        LOGGER.listGroupsAsJSON(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601220, value="User {0} is listing groups as json on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void listGroupsAsJSON(String var1, Object var2, Object ... var3);

    public static void resetMessagesAdded(Object source) {
        LOGGER.resetMessagesAdded(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601221, value="User {0} is resetting added messages on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void resetMessagesAdded(String var1, Object var2, Object ... var3);

    public static void resetMessagesAcknowledged(Object source) {
        LOGGER.resetMessagesAcknowledged(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601222, value="User {0} is resetting acknowledged messages on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void resetMessagesAcknowledged(String var1, Object var2, Object ... var3);

    public static void resetMessagesExpired(Object source) {
        LOGGER.resetMessagesExpired(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601223, value="User {0} is resetting expired messages on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void resetMessagesExpired(String var1, Object var2, Object ... var3);

    public static void resetMessagesKilled(Object source) {
        LOGGER.resetMessagesKilled(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601224, value="User {0} is resetting killed messages on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void resetMessagesKilled(String var1, Object var2, Object ... var3);

    public static void getStaticConnectors(Object source) {
        LOGGER.getStaticConnectors(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601225, value="User {0} is getting static connectors on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getStaticConnectors(String var1, Object var2, Object ... var3);

    public static void getForwardingAddress(Object source) {
        LOGGER.getForwardingAddress(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601226, value="User {0} is getting forwarding address on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getForwardingAddress(String var1, Object var2, Object ... var3);

    public static void getQueueName(Object source) {
        LOGGER.getQueueName(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601227, value="User {0} is getting the queue name on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getQueueName(String var1, Object var2, Object ... var3);

    public static void getDiscoveryGroupName(Object source) {
        LOGGER.getDiscoveryGroupName(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601228, value="User {0} is getting discovery group name on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getDiscoveryGroupName(String var1, Object var2, Object ... var3);

    public static void getFilterString(Object source) {
        LOGGER.getFilterString(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601229, value="User {0} is getting filter string on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getFilterString(String var1, Object var2, Object ... var3);

    public static void getReconnectAttempts(Object source) {
        LOGGER.getReconnectAttempts(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601230, value="User {0} is getting reconnect attempts on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getReconnectAttempts(String var1, Object var2, Object ... var3);

    public static void getRetryInterval(Object source) {
        LOGGER.getRetryInterval(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601231, value="User {0} is getting retry interval on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getRetryInterval(String var1, Object var2, Object ... var3);

    public static void getRetryIntervalMultiplier(Object source) {
        LOGGER.getRetryIntervalMultiplier(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601232, value="User {0} is getting retry interval multiplier on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getRetryIntervalMultiplier(String var1, Object var2, Object ... var3);

    public static void getTransformerClassName(Object source) {
        LOGGER.getTransformerClassName(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601233, value="User {0} is getting transformer class name on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getTransformerClassName(String var1, Object var2, Object ... var3);

    public static void getTransformerPropertiesAsJSON(Object source) {
        LOGGER.getTransformerPropertiesAsJSON(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601234, value="User {0} is getting transformer properties as json on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getTransformerPropertiesAsJSON(String var1, Object var2, Object ... var3);

    public static void getTransformerProperties(Object source) {
        LOGGER.getTransformerProperties(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601235, value="User {0} is getting transformer properties on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getTransformerProperties(String var1, Object var2, Object ... var3);

    public static void isStartedBridge(Object source) {
        LOGGER.isStartedBridge(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601236, value="User {0} is checking if bridge started on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void isStartedBridge(String var1, Object var2, Object ... var3);

    public static void isUseDuplicateDetection(Object source) {
        LOGGER.isUseDuplicateDetection(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601237, value="User {0} is querying use duplicate detection on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void isUseDuplicateDetection(String var1, Object var2, Object ... var3);

    public static void isHA(Object source) {
        LOGGER.isHA(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601238, value="User {0} is querying isHA on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void isHA(String var1, Object var2, Object ... var3);

    public static void startBridge(Object source) {
        LOGGER.startBridge(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601239, value="User {0} is starting a bridge on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void startBridge(String var1, Object var2, Object ... var3);

    public static void stopBridge(Object source) {
        LOGGER.stopBridge(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601240, value="User {0} is stopping a bridge on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void stopBridge(String var1, Object var2, Object ... var3);

    public static void getMessagesPendingAcknowledgement(Object source) {
        LOGGER.getMessagesPendingAcknowledgement(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601241, value="User {0} is getting messages pending acknowledgement on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getMessagesPendingAcknowledgement(String var1, Object var2, Object ... var3);

    public static void getMetrics(Object source) {
        LOGGER.getMetrics(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601242, value="User {0} is getting metrics on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getMetrics(String var1, Object var2, Object ... var3);

    public static void getBroadcastPeriod(Object source) {
        LOGGER.getBroadcastPeriod(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601243, value="User {0} is getting broadcast period on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getBroadcastPeriod(String var1, Object var2, Object ... var3);

    public static void getConnectorPairs(Object source) {
        LOGGER.getConnectorPairs(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601244, value="User {0} is getting connector pairs on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getConnectorPairs(String var1, Object var2, Object ... var3);

    public static void getConnectorPairsAsJSON(Object source) {
        LOGGER.getConnectorPairsAsJSON(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601245, value="User {0} is getting connector pairs as json on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getConnectorPairsAsJSON(String var1, Object var2, Object ... var3);

    public static void getGroupAddress(Object source) {
        LOGGER.getGroupAddress(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601246, value="User {0} is getting group address on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getGroupAddress(String var1, Object var2, Object ... var3);

    public static void getGroupPort(Object source) {
        LOGGER.getGroupPort(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601247, value="User {0} is getting group port on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getGroupPort(String var1, Object var2, Object ... var3);

    public static void getLocalBindPort(Object source) {
        LOGGER.getLocalBindPort(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601248, value="User {0} is getting local binding port on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getLocalBindPort(String var1, Object var2, Object ... var3);

    public static void startBroadcastGroup(Object source) {
        LOGGER.startBroadcastGroup(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601249, value="User {0} is starting broadcasting group on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void startBroadcastGroup(String var1, Object var2, Object ... var3);

    public static void stopBroadcastGroup(Object source) {
        LOGGER.stopBroadcastGroup(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601250, value="User {0} is stopping broadcasting group on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void stopBroadcastGroup(String var1, Object var2, Object ... var3);

    public static void getMaxHops(Object source) {
        LOGGER.getMaxHops(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601251, value="User {0} is getting max hops on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getMaxHops(String var1, Object var2, Object ... var3);

    public static void getStaticConnectorsAsJSON(Object source) {
        LOGGER.getStaticConnectorsAsJSON(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601252, value="User {0} is geting static connectors as json on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getStaticConnectorsAsJSON(String var1, Object var2, Object ... var3);

    public static void isDuplicateDetection(Object source) {
        LOGGER.isDuplicateDetection(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601253, value="User {0} is querying use duplicate detection on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void isDuplicateDetection(String var1, Object var2, Object ... var3);

    public static void getMessageLoadBalancingType(Object source) {
        LOGGER.getMessageLoadBalancingType(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601254, value="User {0} is getting message loadbalancing type on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getMessageLoadBalancingType(String var1, Object var2, Object ... var3);

    public static void getTopology(Object source) {
        LOGGER.getTopology(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601255, value="User {0} is getting topology on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getTopology(String var1, Object var2, Object ... var3);

    public static void getNodes(Object source) {
        LOGGER.getNodes(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601256, value="User {0} is getting nodes on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getNodes(String var1, Object var2, Object ... var3);

    public static void startClusterConnection(Object source) {
        LOGGER.startClusterConnection(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601257, value="User {0} is start cluster connection on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void startClusterConnection(String var1, Object var2, Object ... var3);

    public static void stopClusterConnection(Object source) {
        LOGGER.stopClusterConnection(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601258, value="User {0} is stop cluster connection on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void stopClusterConnection(String var1, Object var2, Object ... var3);

    public static void getBridgeMetrics(Object source, Object ... args) {
        LOGGER.getBridgeMetrics(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601259, value="User {0} is getting bridge metrics on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getBridgeMetrics(String var1, Object var2, Object ... var3);

    public static void getRoutingName(Object source) {
        LOGGER.getRoutingName(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601260, value="User {0} is getting routing name on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getRoutingName(String var1, Object var2, Object ... var3);

    public static void getUniqueName(Object source) {
        LOGGER.getUniqueName(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601261, value="User {0} is getting unique name on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getUniqueName(String var1, Object var2, Object ... var3);

    public static void serverSessionCreateAddress(Object source, String user, Object ... args) {
        LOGGER.serverSessionCreateAddress2(AuditLogger.getCaller(user), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601262, value="User {0} is creating address on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void serverSessionCreateAddress2(String var1, Object var2, Object ... var3);

    public static void handleManagementMessage(Object source, String user, Object ... args) {
        LOGGER.handleManagementMessage2(AuditLogger.getCaller(user), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601263, value="User {0} is handling a management message on target resource {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void handleManagementMessage2(String var1, Object var2, Object ... var3);

    public static void securityFailure(Exception cause) {
        LOGGER.securityFailure(AuditLogger.getCaller(), cause);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601264, value="User {0} gets security check failure", format=Message.Format.MESSAGE_FORMAT)
    public void securityFailure(String var1, @Cause Throwable var2);

    public static void createCoreConsumer(Object source, String user, Object ... args) {
        LOGGER.createCoreConsumer(AuditLogger.getCaller(user), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601265, value="User {0} is creating a core consumer on target resource {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void createCoreConsumer(String var1, Object var2, Object ... var3);

    public static void createSharedQueue(Object source, String user, Object ... args) {
        LOGGER.createSharedQueue(AuditLogger.getCaller(user), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601266, value="User {0} is creating a shared queue on target resource {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void createSharedQueue(String var1, Object var2, Object ... var3);

    public static void createCoreSession(Object source, Object ... args) {
        LOGGER.createCoreSession(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601267, value="User {0} is creating a core session on target resource {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void createCoreSession(String var1, Object var2, Object ... var3);

    public static void getProducedRate(Object source) {
        LOGGER.getProducedRate(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601268, value="User {0} is getting produced message rate on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getProducedRate(String var1, Object var2, Object ... var3);

    public static void getAcknowledgeAttempts(Object source) {
        LOGGER.getMessagesAcknowledged(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601269, value="User {0} is getting messages acknowledged attempts on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getAcknowledgeAttempts(String var1, Object var2, Object ... var3);

    public static void getRingSize(Object source, Object ... args) {
        LOGGER.getRingSize(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601270, value="User {0} is getting ring size on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getRingSize(String var1, Object var2, Object ... var3);

    public static void isRetroactiveResource(Object source) {
        LOGGER.isRetroactiveResource(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601271, value="User {0} is getting retroactiveResource property on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void isRetroactiveResource(String var1, Object var2, Object ... var3);

    public static void getDiskStoreUsage(Object source) {
        LOGGER.getDiskStoreUsage(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601272, value="User {0} is getting disk store usage on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getDiskStoreUsage(String var1, Object var2, Object ... var3);

    public static void getDiskStoreUsagePercentage(Object source) {
        LOGGER.getDiskStoreUsagePercentage(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601273, value="User {0} is getting disk store usage percentage on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getDiskStoreUsagePercentage(String var1, Object var2, Object ... var3);

    public static void isGroupRebalance(Object source) {
        LOGGER.isGroupRebalance(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601274, value="User {0} is getting group rebalance property on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void isGroupRebalance(String var1, Object var2, Object ... var3);

    public static void getGroupBuckets(Object source) {
        LOGGER.getGroupBuckets(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601275, value="User {0} is getting group buckets on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getGroupBuckets(String var1, Object var2, Object ... var3);

    public static void getGroupFirstKey(Object source) {
        LOGGER.getGroupFirstKey(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601276, value="User {0} is getting group first key on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getGroupFirstKey(String var1, Object var2, Object ... var3);

    public static void getCurrentDuplicateIdCacheSize(Object source) {
        LOGGER.getCurrentDuplicateIdCacheSize(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601509, value="User {0} is getting currentDuplicateIdCacheSize property on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getCurrentDuplicateIdCacheSize(String var1, Object var2, Object ... var3);

    public static void clearDuplicateIdCache(Object source) {
        LOGGER.clearDuplicateIdCache(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601510, value="User {0} is clearing duplicate ID cache on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void clearDuplicateIdCache(String var1, Object var2, Object ... var3);

    public static void getChannelName(Object source) {
        LOGGER.getChannelName(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601511, value="User {0} is getting channelName property on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getChannelName(String var1, Object var2, Object ... var3);

    public static void getFileContents(Object source) {
        LOGGER.getFileContents(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601512, value="User {0} is getting fileContents property on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getFileContents(String var1, Object var2, Object ... var3);

    public static void getFile(Object source) {
        LOGGER.getFile(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601513, value="User {0} is getting file property on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void getFile(String var1, Object var2, Object ... var3);

    public static void coreSendMessage(String user, Object context) {
        MESSAGE_LOGGER.sendMessage(AuditLogger.getCaller(user), context);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601500, value="User {0} is sending a core message with Context: {1}", format=Message.Format.MESSAGE_FORMAT)
    public void sendMessage(String var1, Object var2);

    public static void coreConsumeMessage(String queue) {
        MESSAGE_LOGGER.consumeMessage(AuditLogger.getCaller(), queue);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601501, value="User {0} is consuming a message from {1}", format=Message.Format.MESSAGE_FORMAT)
    public void consumeMessage(String var1, String var2);

    public static void createAddressSuccess(String name, String routingTypes) {
        RESOURCE_LOGGER.createAddressSuccess(AuditLogger.getCaller(), name, routingTypes);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601701, value="User {0} successfully created Address: {1} with routing types {2}", format=Message.Format.MESSAGE_FORMAT)
    public void createAddressSuccess(String var1, String var2, String var3);

    public static void createAddressFailure(String name, String routingTypes) {
        RESOURCE_LOGGER.createAddressFailure(AuditLogger.getCaller(), name, routingTypes);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601702, value="User {0} failed to created Address: {1} with routing types {2}", format=Message.Format.MESSAGE_FORMAT)
    public void createAddressFailure(String var1, String var2, String var3);

    public static void updateAddressSuccess(String name, String routingTypes) {
        RESOURCE_LOGGER.updateAddressSuccess(AuditLogger.getCaller(), name, routingTypes);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601703, value="User {0} successfully updated Address: {1} with routing types {2}", format=Message.Format.MESSAGE_FORMAT)
    public void updateAddressSuccess(String var1, String var2, String var3);

    public static void updateAddressFailure(String name, String routingTypes) {
        RESOURCE_LOGGER.updateAddressFailure(AuditLogger.getCaller(), name, routingTypes);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601704, value="User {0} successfully updated Address: {1} with routing types {2}", format=Message.Format.MESSAGE_FORMAT)
    public void updateAddressFailure(String var1, String var2, String var3);

    public static void deleteAddressSuccess(String name) {
        RESOURCE_LOGGER.deleteAddressSuccess(AuditLogger.getCaller(), name);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601705, value="User {0} successfully deleted Address: {1}", format=Message.Format.MESSAGE_FORMAT)
    public void deleteAddressSuccess(String var1, String var2);

    public static void deleteAddressFailure(String name) {
        RESOURCE_LOGGER.deleteAddressFailure(AuditLogger.getCaller(), name);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601706, value="User {0} failed to deleted Address: {1}", format=Message.Format.MESSAGE_FORMAT)
    public void deleteAddressFailure(String var1, String var2);

    public static void createQueueSuccess(String name, String address, String routingType) {
        RESOURCE_LOGGER.createQueueSuccess(AuditLogger.getCaller(), name, address, routingType);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601707, value="User {0} successfully created Queue: {1} on Address: {2} with routing type {3}", format=Message.Format.MESSAGE_FORMAT)
    public void createQueueSuccess(String var1, String var2, String var3, String var4);

    public static void createQueueFailure(String name, String address, String routingType) {
        RESOURCE_LOGGER.createQueueFailure(AuditLogger.getCaller(), name, address, routingType);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601708, value="User {0} failed to create Queue: {1} on Address: {2} with routing type {3}", format=Message.Format.MESSAGE_FORMAT)
    public void createQueueFailure(String var1, String var2, String var3, String var4);

    public static void updateQueueSuccess(String name, String routingType) {
        RESOURCE_LOGGER.updateQueueSuccess(AuditLogger.getCaller(), name, routingType);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601709, value="User {0} successfully updated Queue: {1} with routing type {2}", format=Message.Format.MESSAGE_FORMAT)
    public void updateQueueSuccess(String var1, String var2, String var3);

    public static void updateQueueFailure(String name, String routingType) {
        RESOURCE_LOGGER.updateQueueFailure(AuditLogger.getCaller(), name, routingType);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601710, value="User {0} failed to update Queue: {1} with routing type {2}", format=Message.Format.MESSAGE_FORMAT)
    public void updateQueueFailure(String var1, String var2, String var3);

    public static void destroyQueueSuccess(String name) {
        RESOURCE_LOGGER.destroyQueueSuccess(AuditLogger.getCaller(), name);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601711, value="User {0} successfully deleted Queue: {1}", format=Message.Format.MESSAGE_FORMAT)
    public void destroyQueueSuccess(String var1, String var2);

    public static void destroyQueueFailure(String name) {
        RESOURCE_LOGGER.destroyQueueFailure(AuditLogger.getCaller(), name);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601712, value="User {0} failed to delete Queue: {1}", format=Message.Format.MESSAGE_FORMAT)
    public void destroyQueueFailure(String var1, String var2);

    public static void removeMessagesSuccess(int removed, String queue) {
        RESOURCE_LOGGER.removeMessagesSuccess(AuditLogger.getCaller(), removed, queue);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601713, value="User {0} has removed {1} messages from Queue: {2}", format=Message.Format.MESSAGE_FORMAT)
    public void removeMessagesSuccess(String var1, int var2, String var3);

    public static void removeMessagesFailure(String queue) {
        RESOURCE_LOGGER.removeMessagesFailure(AuditLogger.getCaller(), queue);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601714, value="User {0} failed to remove messages from Queue: {1}", format=Message.Format.MESSAGE_FORMAT)
    public void removeMessagesFailure(String var1, String var2);

    public static void userSuccesfullyLoggedInAudit(Subject subject) {
        RESOURCE_LOGGER.userSuccesfullyLoggedIn(AuditLogger.getCaller(subject));
    }

    public static void userSuccesfullyLoggedInAudit() {
        RESOURCE_LOGGER.userSuccesfullyLoggedIn(AuditLogger.getCaller());
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601715, value="User {0} successfully authorized", format=Message.Format.MESSAGE_FORMAT)
    public void userSuccesfullyLoggedIn(String var1);

    public static void userFailedLoggedInAudit(String reason) {
        RESOURCE_LOGGER.userFailedLoggedIn(AuditLogger.getCaller(), reason);
    }

    public static void userFailedLoggedInAudit(Subject subject, String reason) {
        RESOURCE_LOGGER.userFailedLoggedIn(AuditLogger.getCaller(subject), reason);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601716, value="User {0} failed authorization, reason: {1}", format=Message.Format.MESSAGE_FORMAT)
    public void userFailedLoggedIn(String var1, String var2);

    public static void objectInvokedSuccessfully(ObjectName objectName, String operationName) {
        RESOURCE_LOGGER.objectInvokedSuccessfully(AuditLogger.getCaller(), objectName, operationName);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601717, value="User {0} accessed {2} on management object {1}", format=Message.Format.MESSAGE_FORMAT)
    public void objectInvokedSuccessfully(String var1, ObjectName var2, String var3);

    public static void objectInvokedFailure(ObjectName objectName, String operationName) {
        RESOURCE_LOGGER.objectInvokedFailure(AuditLogger.getCaller(), objectName, operationName);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601718, value="User {0} does not have correct role to access {2} on management object {1}", format=Message.Format.MESSAGE_FORMAT)
    public void objectInvokedFailure(String var1, ObjectName var2, String var3);

    public static void pauseQueueSuccess(String queueName) {
        RESOURCE_LOGGER.pauseQueueSuccess(AuditLogger.getCaller(), queueName);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601719, value="User {0} has paused queue {1}", format=Message.Format.MESSAGE_FORMAT)
    public void pauseQueueSuccess(String var1, String var2);

    public static void pauseQueueFailure(String queueName) {
        RESOURCE_LOGGER.pauseQueueFailure(AuditLogger.getCaller(), queueName);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601720, value="User {0} failed to pause queue {1}", format=Message.Format.MESSAGE_FORMAT)
    public void pauseQueueFailure(String var1, String var2);

    public static void resumeQueueSuccess(String queueName) {
        RESOURCE_LOGGER.resumeQueueSuccess(AuditLogger.getCaller(), queueName);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601721, value="User {0} has resumed queue {1}", format=Message.Format.MESSAGE_FORMAT)
    public void resumeQueueSuccess(String var1, String var2);

    public static void resumeQueueFailure(String queueName) {
        RESOURCE_LOGGER.pauseQueueFailure(AuditLogger.getCaller(), queueName);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601722, value="User {0} failed to resume queue {1}", format=Message.Format.MESSAGE_FORMAT)
    public void resumeQueueFailure(String var1, String var2);

    public static void sendMessageSuccess(String queueName, String user) {
        RESOURCE_LOGGER.sendMessageSuccess(AuditLogger.getCaller(), queueName, user);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601723, value="User {0} sent message to {1} as user {2}", format=Message.Format.MESSAGE_FORMAT)
    public void sendMessageSuccess(String var1, String var2, String var3);

    public static void sendMessageFailure(String queueName, String user) {
        RESOURCE_LOGGER.sendMessageFailure(AuditLogger.getCaller(), queueName, user);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601724, value="User {0} failed to send message to {1} as user {2}", format=Message.Format.MESSAGE_FORMAT)
    public void sendMessageFailure(String var1, String var2, String var3);

    public static void browseMessagesSuccess(String queueName, int numMessages) {
        RESOURCE_LOGGER.browseMessagesSuccess(AuditLogger.getCaller(), queueName, numMessages);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601725, value="User {0} browsed {2} messages from queue {1}", format=Message.Format.MESSAGE_FORMAT)
    public void browseMessagesSuccess(String var1, String var2, int var3);

    public static void browseMessagesFailure(String queueName) {
        RESOURCE_LOGGER.browseMessagesFailure(AuditLogger.getCaller(), queueName);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601726, value="User {0} failed to browse messages from queue {1}", format=Message.Format.MESSAGE_FORMAT)
    public void browseMessagesFailure(String var1, String var2);

    public static void updateDivert(Object source, Object ... args) {
        LOGGER.updateDivert(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601727, value="User {0} is updating a divert on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void updateDivert(String var1, Object var2, Object ... var3);

    public static void isEnabled(Object source) {
        LOGGER.isEnabled(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601728, value="User {0} is getting enabled property on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void isEnabled(String var1, Object var2, Object ... var3);

    public static void disable(Object source, Object ... args) {
        LOGGER.disable(AuditLogger.getCaller(), source, AuditLogger.arrayToString(args));
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601729, value="User {0} is disabling on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void disable(String var1, Object var2, Object ... var3);

    public static void enable(Object source) {
        LOGGER.resume(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601730, value="User {0} is enabling on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void enable(String var1, Object var2, Object ... var3);

    public static void pauseAddressSuccess(String queueName) {
        RESOURCE_LOGGER.pauseAddressSuccess(AuditLogger.getCaller(), queueName);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601731, value="User {0} has paused address {1}", format=Message.Format.MESSAGE_FORMAT)
    public void pauseAddressSuccess(String var1, String var2);

    public static void pauseAddressFailure(String queueName) {
        RESOURCE_LOGGER.pauseAddressFailure(AuditLogger.getCaller(), queueName);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601732, value="User {0} failed to pause address {1}", format=Message.Format.MESSAGE_FORMAT)
    public void pauseAddressFailure(String var1, String var2);

    public static void resumeAddressSuccess(String queueName) {
        RESOURCE_LOGGER.resumeAddressSuccess(AuditLogger.getCaller(), queueName);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601733, value="User {0} has resumed address {1}", format=Message.Format.MESSAGE_FORMAT)
    public void resumeAddressSuccess(String var1, String var2);

    public static void resumeAddressFailure(String queueName) {
        RESOURCE_LOGGER.resumeAddressFailure(AuditLogger.getCaller(), queueName);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601734, value="User {0} failed to resume address {1}", format=Message.Format.MESSAGE_FORMAT)
    public void resumeAddressFailure(String var1, String var2);

    public static void isGroupRebalancePauseDispatch(Object source) {
        LOGGER.isGroupRebalancePauseDispatch(AuditLogger.getCaller(), source, new Object[0]);
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=601735, value="User {0} is getting group rebalance pause dispatch property on target resource: {1} {2}", format=Message.Format.MESSAGE_FORMAT)
    public void isGroupRebalancePauseDispatch(String var1, Object var2, Object ... var3);
}

