/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.apache.johnzon.core;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.json.stream.JsonParsingException;
import org.apache.activemq.artemis.shaded.org.apache.johnzon.core.BufferStrategy;
import org.apache.activemq.artemis.shaded.org.apache.johnzon.core.JsonChars;
import org.apache.activemq.artemis.shaded.org.apache.johnzon.core.JsonLocationImpl;

class Strings
implements JsonChars {
    private static final BufferStrategy.BufferProvider<StringBuilder> BUILDER_CACHE = BufferStrategy.valueOf(System.getProperty("johnzon.string-builder.strategy", "QUEUE")).newStringBuilderProvider(Integer.getInteger("org.apache.activemq.artemis.shaded.org.apache.johnzon.default-string-builder", 1024));
    private static final String UNICODE_PREFIX = "\\u";
    private static final String UNICODE_PREFIX_HELPER = "000";
    private static final ConcurrentMap<Character, String> UNICODE_CACHE = new ConcurrentHashMap<Character, String>();

    static char asEscapedChar(char current) {
        switch (current) {
            case 'r': {
                return '\r';
            }
            case 't': {
                return '\t';
            }
            case 'b': {
                return '\b';
            }
            case 'f': {
                return '\f';
            }
            case 'n': {
                return '\n';
            }
            case '\"': {
                return '\"';
            }
            case '\\': {
                return '\\';
            }
            case '/': {
                return '/';
            }
        }
        if (Character.isHighSurrogate(current) || Character.isLowSurrogate(current)) {
            return current;
        }
        throw new JsonParsingException("Invalid escape sequence '" + current + "' (Codepoint: " + String.valueOf(current).codePointAt(0), JsonLocationImpl.UNKNOWN_LOCATION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String escape(String value) {
        if (value == null || value.length() == 0) {
            return value;
        }
        StringBuilder builder = BUILDER_CACHE.newBuffer();
        try {
            block13: for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                switch (c) {
                    case '\"': 
                    case '\\': {
                        builder.append('\\').append(c);
                        continue block13;
                    }
                    default: {
                        if (c < ' ') {
                            switch (c) {
                                case '\n': {
                                    builder.append("\\n");
                                    continue block13;
                                }
                                case '\r': {
                                    builder.append("\\r");
                                    continue block13;
                                }
                                case '\t': {
                                    builder.append("\\t");
                                    continue block13;
                                }
                                case '\b': {
                                    builder.append("\\b");
                                    continue block13;
                                }
                                case '\f': {
                                    builder.append("\\f");
                                    continue block13;
                                }
                            }
                            builder.append(Strings.toUnicode(c));
                            continue block13;
                        }
                        if (c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                            builder.append(Strings.toUnicode(c));
                            continue block13;
                        }
                        builder.append(c);
                    }
                }
            }
            String string = builder.toString();
            return string;
        }
        finally {
            BUILDER_CACHE.release(builder);
        }
    }

    private static String toUnicode(char c) {
        String found = (String)UNICODE_CACHE.get(Character.valueOf(c));
        if (found != null) {
            return found;
        }
        String hex = UNICODE_PREFIX_HELPER + Integer.toHexString(c);
        String s = UNICODE_PREFIX + hex.substring(hex.length() - 4);
        UNICODE_CACHE.putIfAbsent(Character.valueOf(c), s);
        return s;
    }

    private Strings() {
    }
}

