/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.protocols;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.shaded.org.jgroups.Address;
import org.apache.activemq.artemis.shaded.org.jgroups.Event;
import org.apache.activemq.artemis.shaded.org.jgroups.PhysicalAddress;
import org.apache.activemq.artemis.shaded.org.jgroups.View;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.MBean;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.ManagedAttribute;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.ManagedOperation;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.Property;
import org.apache.activemq.artemis.shaded.org.jgroups.stack.IpAddress;
import org.apache.activemq.artemis.shaded.org.jgroups.stack.Protocol;
import org.apache.activemq.artemis.shaded.org.jgroups.util.BoundedList;
import org.apache.activemq.artemis.shaded.org.jgroups.util.TimeScheduler;
import org.apache.activemq.artemis.shaded.org.jgroups.util.TimeService;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Tuple;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

@MBean(description="Failure detection protocol which detects crashes or hangs of entire hosts and suspects all cluster members on those hosts")
public class FD_HOST
extends Protocol {
    @Property(description="The command used to check a given host for liveness. Example: \"ping\". If null, InetAddress.isReachable() will be used by default")
    protected String cmd;
    @Property(description="Max time (in ms) after which a host is suspected if it failed all liveness checks")
    protected long timeout = 60000L;
    @Property(description="The interval (in ms) at which the hosts are checked for liveness")
    protected long interval = 20000L;
    @Property(description="Max time (in ms) that a liveness check for a single host can take")
    protected long check_timeout = 3000L;
    @Property(description="Uses TimeService to get the current time rather than System.currentTimeMillis. Might get removed soon, don't use !")
    protected boolean use_time_service = true;
    @ManagedAttribute(description="Number of liveness checks")
    protected int num_liveness_checks;
    @ManagedAttribute(description="Number of suspected events received")
    protected int num_suspect_events;
    protected final Set<Address> suspected_mbrs = new HashSet<Address>();
    @ManagedAttribute(description="Shows whether there are currently any suspected members")
    protected volatile boolean has_suspected_mbrs;
    protected final BoundedList<Tuple<InetAddress, Long>> suspect_history = new BoundedList(20);
    protected Address local_addr;
    protected InetAddress local_host;
    protected final List<Address> members = new ArrayList<Address>();
    protected PingCommand ping_command = new IsReachablePingCommand();
    protected final Map<InetAddress, List<Address>> hosts = new HashMap<InetAddress, List<Address>>();
    protected final ConcurrentMap<InetAddress, Long> timestamps = new ConcurrentHashMap<InetAddress, Long>();
    protected TimeScheduler timer;
    protected TimeService time_service;
    protected Future<?> ping_task_future;

    public FD_HOST pingCommand(PingCommand cmd) {
        this.ping_command = cmd;
        return this;
    }

    @Override
    public void resetStats() {
        this.num_liveness_checks = 0;
        this.num_suspect_events = 0;
        this.suspect_history.clear();
    }

    public void setCommand(String command) {
        this.cmd = command;
        this.ping_command = this.cmd != null ? new ExternalPingCommand(this.cmd) : new IsReachablePingCommand();
    }

    @ManagedOperation(description="Prints history of suspected hosts")
    public String printSuspectHistory() {
        StringBuilder sb = new StringBuilder();
        for (Tuple tuple : this.suspect_history) {
            sb.append(new Date((Long)tuple.getVal2())).append(": ").append(tuple.getVal1()).append("\n");
        }
        return sb.toString();
    }

    @ManagedOperation(description="Prints timestamps")
    public String printTimestamps() {
        return this._printTimestamps();
    }

    @ManagedAttribute(description="Whether the ping task is running")
    public boolean isPingerRunning() {
        Future<?> future = this.ping_task_future;
        return future != null && !future.isDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation(description="Prints the hosts and their associated cluster members")
    public String printHosts() {
        StringBuilder sb = new StringBuilder();
        Map<InetAddress, List<Address>> map = this.hosts;
        synchronized (map) {
            for (Map.Entry<InetAddress, List<Address>> entry : this.hosts.entrySet()) {
                sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
            }
        }
        return sb.toString();
    }

    @ManagedOperation(description="Checks whether the given host is alive")
    public boolean isAlive(String host) throws Exception {
        return this.ping_command != null && this.ping_command.isAlive(InetAddress.getByName(host), this.check_timeout);
    }

    @ManagedAttribute(description="Currently suspected members")
    public String getSuspectedMembers() {
        return this.suspected_mbrs.toString();
    }

    @Override
    public void init() throws Exception {
        if (this.interval >= this.timeout) {
            throw new IllegalArgumentException("interval (" + this.interval + ") has to be less than timeout (" + this.timeout + ")");
        }
        super.init();
        if (this.cmd != null) {
            this.ping_command = new ExternalPingCommand(this.cmd);
        }
        this.timer = this.getTransport().getTimer();
        if (this.timer == null) {
            throw new Exception("timer not set");
        }
        this.time_service = this.getTransport().getTimeService();
        if (this.time_service == null) {
            this.log.warn("%s: time service is not available, using System.currentTimeMillis() instead", this.local_addr);
        } else if (this.time_service.interval() > this.timeout) {
            this.log.warn("%s: interval of time service (%d) is greater than timeout (%d), disabling time service", this.local_addr, this.time_service.interval(), this.timeout);
            this.use_time_service = false;
        }
        this.suspected_mbrs.clear();
        this.has_suspected_mbrs = false;
    }

    @Override
    public void stop() {
        super.stop();
        this.stopPingerTask();
        this.suspected_mbrs.clear();
        this.has_suspected_mbrs = false;
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                View view = (View)evt.getArg();
                this.handleView(view);
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 2: 
            case 80: 
            case 92: 
            case 93: {
                this.local_host = this.getHostFor(this.local_addr);
                break;
            }
            case 4: {
                Object retval = this.down_prot.down(evt);
                this.local_host = null;
                return retval;
            }
            case 51: {
                Address mbr = (Address)evt.getArg();
                this.unsuspect(mbr);
            }
        }
        return this.down_prot.down(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleView(View view) {
        List<Address> view_mbrs = view.getMembers();
        boolean is_pinger = false;
        this.members.clear();
        this.members.addAll(view_mbrs);
        ArrayList<InetAddress> current_hosts = null;
        Map<InetAddress, List<Address>> map = this.hosts;
        synchronized (map) {
            this.hosts.clear();
            for (Address mbr : view_mbrs) {
                InetAddress key = this.getHostFor(mbr);
                if (key == null) continue;
                List<Address> mbrs = this.hosts.get(key);
                if (mbrs == null) {
                    mbrs = new ArrayList<Address>();
                    this.hosts.put(key, mbrs);
                }
                mbrs.add(mbr);
            }
            is_pinger = this.isPinger(this.local_addr);
            current_hosts = new ArrayList<InetAddress>(this.hosts.keySet());
        }
        if (this.suspected_mbrs.retainAll(view.getMembers())) {
            this.has_suspected_mbrs = !this.suspected_mbrs.isEmpty();
        }
        this.timestamps.keySet().retainAll(current_hosts);
        current_hosts.remove(this.local_host);
        for (InetAddress host : current_hosts) {
            this.timestamps.putIfAbsent(host, this.getTimestamp());
        }
        if (is_pinger) {
            this.startPingerTask();
        } else {
            this.stopPingerTask();
            this.timestamps.clear();
        }
    }

    protected PhysicalAddress getPhysicalAddress(Address logical_addr) {
        return (PhysicalAddress)this.down(new Event(87, logical_addr));
    }

    protected InetAddress getHostFor(Address mbr) {
        PhysicalAddress phys_addr = this.getPhysicalAddress(mbr);
        return phys_addr instanceof IpAddress ? ((IpAddress)phys_addr).getIpAddress() : null;
    }

    protected boolean isPinger(Address mbr) {
        InetAddress host = this.getHostFor(mbr);
        if (host == null) {
            return false;
        }
        List<Address> mbrs = this.hosts.get(host);
        return mbrs != null && !mbrs.isEmpty() && mbrs.get(0).equals(mbr);
    }

    protected void startPingerTask() {
        if (this.ping_task_future == null || this.ping_task_future.isDone()) {
            this.ping_task_future = this.timer.scheduleAtFixedRate(new PingTask(), this.interval, this.interval, TimeUnit.MILLISECONDS);
        }
    }

    protected void stopPingerTask() {
        if (this.ping_task_future != null) {
            this.ping_task_future.cancel(false);
            this.ping_task_future = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void suspect(InetAddress host) {
        ArrayList<Address> suspects;
        this.suspect_history.add(new Tuple<InetAddress, Long>(host, System.currentTimeMillis()));
        Map<InetAddress, List<Address>> map = this.hosts;
        synchronized (map) {
            List<Address> tmp = this.hosts.get(host);
            suspects = tmp != null ? new ArrayList<Address>(tmp) : null;
        }
        if (suspects != null) {
            this.log.debug("%s: suspecting host %s; suspected members: %s", this.local_addr, host, Util.printListWithDelimiter(suspects, ","));
            this.suspect(suspects);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void suspect(List<Address> suspects) {
        Address first;
        if (suspects == null || suspects.isEmpty()) {
            return;
        }
        this.num_suspect_events += suspects.size();
        ArrayList<Address> eligible_mbrs = new ArrayList<Address>();
        FD_HOST fD_HOST = this;
        synchronized (fD_HOST) {
            this.suspected_mbrs.addAll(suspects);
            eligible_mbrs.addAll(this.members);
            eligible_mbrs.removeAll(this.suspected_mbrs);
            this.has_suspected_mbrs = !this.suspected_mbrs.isEmpty();
        }
        if (this.local_addr != null && !eligible_mbrs.isEmpty() && this.local_addr.equals(first = (Address)eligible_mbrs.get(0))) {
            this.log.debug("%s: suspecting %s", this.local_addr, this.suspected_mbrs);
            for (Address suspect : suspects) {
                this.up_prot.up(new Event(9, suspect));
                this.down_prot.down(new Event(9, suspect));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean unsuspect(Address mbr) {
        boolean do_unsuspect;
        if (mbr == null) {
            return false;
        }
        FD_HOST fD_HOST = this;
        synchronized (fD_HOST) {
            boolean bl = do_unsuspect = !this.suspected_mbrs.isEmpty() && this.suspected_mbrs.remove(mbr);
            if (do_unsuspect) {
                this.has_suspected_mbrs = !this.suspected_mbrs.isEmpty();
            }
        }
        if (do_unsuspect) {
            this.up_prot.up(new Event(51, mbr));
            this.down_prot.down(new Event(51, mbr));
        }
        return do_unsuspect;
    }

    protected String _printTimestamps() {
        StringBuilder sb = new StringBuilder();
        long current_time = this.getTimestamp();
        for (Map.Entry entry : this.timestamps.entrySet()) {
            sb.append(entry.getKey()).append(": ");
            sb.append(TimeUnit.SECONDS.convert(current_time - (Long)entry.getValue(), TimeUnit.NANOSECONDS)).append(" secs old\n");
        }
        return sb.toString();
    }

    protected void updateTimestampFor(InetAddress host) {
        this.timestamps.put(host, this.getTimestamp());
    }

    protected long getAgeOf(InetAddress host) {
        Long ts = (Long)this.timestamps.get(host);
        return ts != null ? TimeUnit.SECONDS.convert(this.getTimestamp() - ts, TimeUnit.NANOSECONDS) : -1L;
    }

    protected long getTimestamp() {
        return this.use_time_service && this.time_service != null ? this.time_service.timestamp() : System.nanoTime();
    }

    public static class CommandExecutor2 {
        public static int execute(String command) throws Exception {
            Process p = Runtime.getRuntime().exec(command);
            return p.waitFor();
        }
    }

    public static class CommandExecutor {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static int execute(String command) throws Exception {
            Process p = Runtime.getRuntime().exec(command);
            InputStream in = p.getInputStream();
            InputStream err = p.getErrorStream();
            try {
                Reader in_reader = new Reader(in);
                Reader err_reader = new Reader(err);
                in_reader.start();
                err_reader.start();
                in_reader.join();
                err_reader.join();
                int n = p.exitValue();
                return n;
            }
            finally {
                Util.close((Closeable)in);
                Util.close((Closeable)err);
            }
        }

        static class Reader
        extends Thread {
            InputStreamReader in;

            Reader(InputStream in) {
                this.in = new InputStreamReader(in);
            }

            @Override
            public void run() {
                try {
                    int c;
                    while ((c = this.in.read()) != -1) {
                    }
                }
                catch (IOException e) {}
            }
        }
    }

    protected static class ExternalPingCommand
    implements PingCommand {
        protected final String cmd;

        public ExternalPingCommand(String cmd) {
            this.cmd = cmd;
        }

        @Override
        public boolean isAlive(InetAddress host, long timeout) throws Exception {
            return CommandExecutor2.execute(this.cmd + " " + host.getHostAddress()) == 0;
        }
    }

    public static class IsReachablePingCommand
    implements PingCommand {
        @Override
        public boolean isAlive(InetAddress host, long timeout) throws Exception {
            return host.isReachable((int)timeout);
        }
    }

    public static interface PingCommand {
        public boolean isAlive(InetAddress var1, long var2) throws Exception;
    }

    protected class PingTask
    implements Runnable {
        protected PingTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList<InetAddress> targets;
            Map<InetAddress, List<Address>> map = FD_HOST.this.hosts;
            synchronized (map) {
                targets = new ArrayList<InetAddress>(FD_HOST.this.hosts.keySet());
            }
            targets.remove(FD_HOST.this.local_host);
            for (InetAddress target : targets) {
                try {
                    long timestamp;
                    boolean is_alive = FD_HOST.this.ping_command.isAlive(target, FD_HOST.this.check_timeout);
                    ++FD_HOST.this.num_liveness_checks;
                    if (is_alive) {
                        FD_HOST.this.updateTimestampFor(target);
                        continue;
                    }
                    FD_HOST.this.log.trace("%s: %s is not alive (age=%d secs)", FD_HOST.this.local_addr, target, FD_HOST.this.getAgeOf(target));
                    long current_time = FD_HOST.this.getTimestamp();
                    long diff = TimeUnit.MILLISECONDS.convert(current_time - (timestamp = ((Long)FD_HOST.this.timestamps.get(target)).longValue()), TimeUnit.NANOSECONDS);
                    if (diff < FD_HOST.this.timeout) continue;
                    FD_HOST.this.suspect(target);
                }
                catch (Exception e) {
                    FD_HOST.this.log.error(FD_HOST.this.local_addr + ": ping command failed", e);
                }
            }
        }
    }
}

