/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.protocols;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.shaded.org.jgroups.Address;
import org.apache.activemq.artemis.shaded.org.jgroups.Event;
import org.apache.activemq.artemis.shaded.org.jgroups.Message;
import org.apache.activemq.artemis.shaded.org.jgroups.View;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.MBean;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.ManagedAttribute;
import org.apache.activemq.artemis.shaded.org.jgroups.stack.Protocol;
import org.apache.activemq.artemis.shaded.org.jgroups.util.MessageBatch;

@MBean(description="Protocol which exposes various statistics")
public class STATS
extends Protocol {
    long sent_msgs;
    long sent_bytes;
    long sent_ucasts;
    long sent_mcasts;
    long received_ucasts;
    long received_mcasts;
    long received_msgs;
    long received_bytes;
    long sent_ucast_bytes;
    long sent_mcast_bytes;
    long received_ucast_bytes;
    long received_mcast_bytes;
    HashMap sent = new HashMap();
    HashMap received = new HashMap();
    static final short UP = 1;
    static final short DOWN = 2;

    @Override
    public void resetStats() {
        this.received_mcasts = 0L;
        this.received_ucasts = 0L;
        this.sent_mcasts = 0L;
        this.sent_ucasts = 0L;
        this.sent_bytes = 0L;
        this.sent_msgs = 0L;
        this.received_mcast_bytes = 0L;
        this.received_ucast_bytes = 0L;
        this.sent_mcast_bytes = 0L;
        this.sent_ucast_bytes = 0L;
        this.received_bytes = 0L;
        this.received_msgs = 0L;
        this.sent.clear();
        this.received.clear();
    }

    @ManagedAttribute
    public long getSentMessages() {
        return this.sent_msgs;
    }

    @ManagedAttribute
    public long getSentBytes() {
        return this.sent_bytes;
    }

    @ManagedAttribute
    public long getSentUnicastMessages() {
        return this.sent_ucasts;
    }

    @ManagedAttribute
    public long getSentUnicastBytes() {
        return this.sent_ucast_bytes;
    }

    @ManagedAttribute
    public long getSentMcastMessages() {
        return this.sent_mcasts;
    }

    @ManagedAttribute
    public long getSentMcastBytes() {
        return this.sent_mcast_bytes;
    }

    @ManagedAttribute
    public long getReceivedMessages() {
        return this.received_msgs;
    }

    @ManagedAttribute
    public long getReceivedBytes() {
        return this.received_bytes;
    }

    @ManagedAttribute
    public long getReceivedUnicastMessages() {
        return this.received_ucasts;
    }

    @ManagedAttribute
    public long getReceivedUnicastBytes() {
        return this.received_ucast_bytes;
    }

    @ManagedAttribute
    public long getReceivedMcastMessages() {
        return this.received_mcasts;
    }

    @ManagedAttribute
    public long getReceivedMcastBytes() {
        return this.received_mcast_bytes;
    }

    @Override
    public Object up(Event evt) {
        if (evt.getType() == 1) {
            Message msg = (Message)evt.getArg();
            this.updateStats(msg, (short)1);
        } else if (evt.getType() == 6) {
            this.handleViewChange((View)evt.getArg());
        }
        return this.up_prot.up(evt);
    }

    @Override
    public void up(MessageBatch batch) {
        for (Message msg : batch) {
            this.updateStats(msg, (short)1);
        }
        this.up_prot.up(batch);
    }

    @Override
    public Object down(Event evt) {
        if (evt.getType() == 1) {
            Message msg = (Message)evt.getArg();
            this.updateStats(msg, (short)2);
        } else if (evt.getType() == 6) {
            this.handleViewChange((View)evt.getArg());
        }
        return this.down_prot.down(evt);
    }

    @Override
    public String printStats() {
        Object val;
        Object key;
        StringBuilder sb = new StringBuilder();
        sb.append("sent:\n");
        for (Map.Entry entry : this.sent.entrySet()) {
            key = entry.getKey();
            if (key == null) {
                key = "<mcast dest>";
            }
            val = entry.getValue();
            sb.append(key).append(": ").append(val).append("\n");
        }
        sb.append("\nreceived:\n");
        for (Map.Entry entry : this.received.entrySet()) {
            key = entry.getKey();
            val = entry.getValue();
            sb.append(key).append(": ").append(val).append("\n");
        }
        return sb.toString();
    }

    private void handleViewChange(View view) {
        List<Address> members = view.getMembers();
        LinkedHashSet<Address> tmp = new LinkedHashSet<Address>(members);
        tmp.add(null);
        this.sent.keySet().retainAll(tmp);
        this.received.keySet().retainAll(tmp);
    }

    private void updateStats(Message msg, short direction) {
        boolean mcast2;
        if (msg == null) {
            return;
        }
        int length = msg.getLength();
        Address dest = msg.getDest();
        Address src = msg.getSrc();
        boolean bl = mcast2 = dest == null;
        if (direction == 1) {
            ++this.received_msgs;
            this.received_bytes += (long)length;
            if (mcast2) {
                ++this.received_mcasts;
                this.received_mcast_bytes += (long)length;
            } else {
                ++this.received_ucasts;
                this.received_ucast_bytes += (long)length;
            }
        } else {
            ++this.sent_msgs;
            this.sent_bytes += (long)length;
            if (mcast2) {
                ++this.sent_mcasts;
                this.sent_mcast_bytes += (long)length;
            } else {
                ++this.sent_ucasts;
                this.sent_ucast_bytes += (long)length;
            }
        }
        Address key = direction == 1 ? src : dest;
        HashMap map = direction == 1 ? this.received : this.sent;
        Entry entry = (Entry)map.get(key);
        if (entry == null) {
            entry = new Entry();
            map.put(key, entry);
        }
        ++entry.msgs;
        entry.bytes += (long)length;
        if (mcast2) {
            ++entry.mcasts;
            entry.mcast_bytes += (long)length;
        } else {
            ++entry.ucasts;
            entry.ucast_bytes += (long)length;
        }
    }

    static class Entry {
        long msgs;
        long bytes;
        long ucasts;
        long mcasts;
        long ucast_bytes;
        long mcast_bytes;

        Entry() {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.msgs).append(" (").append(this.bytes).append(" bytes)").append(": ").append(this.ucasts).append(" ucasts (").append(this.ucast_bytes).append(" bytes), ").append(this.mcasts).append(" mcasts (").append(this.mcast_bytes).append(" bytes)");
            return sb.toString();
        }
    }
}

