/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.client.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.TopologyMember;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.utils.ConfigurationHelper;

public final class TopologyMemberImpl
implements TopologyMember {
    private static final long serialVersionUID = 1123652191795626133L;
    private final Pair<TransportConfiguration, TransportConfiguration> connector;
    private final String backupGroupName;
    private final String scaleDownGroupName;
    private transient long uniqueEventID = System.currentTimeMillis();
    private final String nodeId;

    public TopologyMemberImpl(String nodeId, String backupGroupName, String scaleDownGroupName, TransportConfiguration a, TransportConfiguration b) {
        this.nodeId = nodeId;
        this.backupGroupName = backupGroupName;
        this.scaleDownGroupName = scaleDownGroupName;
        this.connector = new Pair<TransportConfiguration, TransportConfiguration>(a, b);
        this.uniqueEventID = System.currentTimeMillis();
    }

    @Override
    public TransportConfiguration getLive() {
        return this.connector.getA();
    }

    @Override
    public TransportConfiguration getBackup() {
        return this.connector.getB();
    }

    public void setBackup(TransportConfiguration param) {
        this.connector.setB(param);
    }

    public void setLive(TransportConfiguration param) {
        this.connector.setA(param);
    }

    @Override
    public String getNodeId() {
        return this.nodeId;
    }

    @Override
    public long getUniqueEventID() {
        return this.uniqueEventID;
    }

    @Override
    public String getBackupGroupName() {
        return this.backupGroupName;
    }

    @Override
    public String getScaleDownGroupName() {
        return this.scaleDownGroupName;
    }

    public void setUniqueEventID(long uniqueEventID) {
        this.uniqueEventID = uniqueEventID;
    }

    public Pair<TransportConfiguration, TransportConfiguration> getConnector() {
        return this.connector;
    }

    @Override
    public boolean isMember(RemotingConnection connection) {
        TransportConfiguration connectorConfig = connection.getTransportConnection() != null ? connection.getTransportConnection().getConnectorConfig() : null;
        return this.isMember(connectorConfig);
    }

    @Override
    public boolean isMember(TransportConfiguration configuration) {
        return this.getConnector().getA() != null && this.getConnector().getA().isSameParams(configuration) || this.getConnector().getB() != null && this.getConnector().getB().isSameParams(configuration);
    }

    @Override
    public String toURI() {
        TransportConfiguration liveConnector = this.getLive();
        Map<String, Object> props = liveConnector.getParams();
        String host = ConfigurationHelper.getStringProperty("host", "localhost", props);
        int port = ConfigurationHelper.getIntProperty("port", 0, props);
        return "tcp://" + host + ":" + port;
    }

    public URI toBackupURI() {
        TransportConfiguration backupConnector = this.getBackup();
        if (backupConnector == null) {
            return null;
        }
        Map<String, Object> props = backupConnector.getParams();
        String host = ConfigurationHelper.getStringProperty("host", "localhost", props);
        int port = ConfigurationHelper.getIntProperty("port", 0, props);
        boolean sslEnabled = ConfigurationHelper.getBooleanProperty("sslEnabled", false, props);
        try {
            return new URI("tcp://" + host + ":" + port + "?" + "sslEnabled" + "=" + sslEnabled);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public String toString() {
        return "TopologyMember[id = " + this.nodeId + ", connector=" + this.connector + ", backupGroupName=" + this.backupGroupName + ", scaleDownGroupName=" + this.scaleDownGroupName + "]";
    }
}

