/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.remoting;

import java.security.Principal;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.cert.X509Certificate;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnection;
import org.apache.activemq.artemis.shaded.io.netty.channel.ChannelHandler;
import org.apache.activemq.artemis.shaded.io.netty.handler.ssl.SslHandler;
import org.apache.activemq.artemis.spi.core.remoting.Connection;

public class CertificateUtil {
    public static X509Certificate[] getCertsFromConnection(Connection connection) {
        X509Certificate[] certificates = null;
        if (connection instanceof NettyConnection) {
            certificates = org.apache.activemq.artemis.utils.CertificateUtil.getCertsFromChannel(((NettyConnection)connection).getChannel());
        }
        return certificates;
    }

    public static Principal getPeerPrincipalFromConnection(Connection connection) {
        NettyConnection nettyConnection;
        ChannelHandler channelHandler;
        Principal result = null;
        if (connection instanceof NettyConnection && (channelHandler = (nettyConnection = (NettyConnection)connection).getChannel().pipeline().get("ssl")) != null && channelHandler instanceof SslHandler) {
            SslHandler sslHandler = (SslHandler)channelHandler;
            try {
                result = sslHandler.engine().getSession().getPeerPrincipal();
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                // empty catch block
            }
        }
        return result;
    }
}

