/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.remoting.impl;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.TransportConfigurationHelper;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnectorFactory;
import org.apache.activemq.artemis.utils.ClassloadingUtil;

public class TransportConfigurationUtil {
    private static final Map<String, Map<String, Object>> DEFAULTS = new HashMap<String, Map<String, Object>>();
    private static final HashMap<String, Object> EMPTY_HELPER = new HashMap();

    public static Map<String, Object> getDefaults(String className) {
        if (className == null) {
            return (Map)EMPTY_HELPER.clone();
        }
        if (!DEFAULTS.containsKey(className)) {
            Object object = TransportConfigurationUtil.instantiateObject(className);
            if (object != null && object instanceof TransportConfigurationHelper) {
                DEFAULTS.put(className, ((TransportConfigurationHelper)object).getDefaults());
            } else {
                DEFAULTS.put(className, EMPTY_HELPER);
            }
        }
        return TransportConfigurationUtil.cloneDefaults(DEFAULTS.get(className));
    }

    private static Object instantiateObject(final String className) {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    return ClassloadingUtil.newInstanceFromClassLoader(className);
                }
                catch (IllegalStateException e) {
                    return null;
                }
            }
        });
    }

    private static Map<String, Object> cloneDefaults(Map<String, Object> defaults) {
        HashMap<String, Object> cloned = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : defaults.entrySet()) {
            cloned.put(entry.getKey(), entry.getValue());
        }
        return cloned;
    }

    public static boolean isSameHost(TransportConfiguration tc1, TransportConfiguration tc2) {
        if (NettyConnectorFactory.class.getName().equals(tc1.getFactoryClassName())) {
            String host1 = tc1.getParams().get("host") != null ? tc1.getParams().get("host").toString() : "localhost";
            String host2 = tc2.getParams().get("host") != null ? tc2.getParams().get("host").toString() : "localhost";
            String port1 = String.valueOf(tc1.getParams().get("port") != null ? tc1.getParams().get("port") : Integer.valueOf(61616));
            String port2 = String.valueOf(tc2.getParams().get("port") != null ? tc2.getParams().get("port") : Integer.valueOf(61616));
            return host1.equals(host2) && port1.equals(port2);
        }
        if ("org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnectorFactory".equals(tc1.getFactoryClassName())) {
            String serverId1 = tc1.getParams().get("serverId") != null ? tc1.getParams().get("serverId").toString() : "0";
            String serverId2 = tc2.getParams().get("serverId") != null ? tc2.getParams().get("serverId").toString() : "0";
            return serverId1.equals(serverId2);
        }
        return false;
    }

    public static Configuration kerb5Config(String principal, boolean initiator) {
        final HashMap<String, String> krb5LoginModuleOptions = new HashMap<String, String>();
        krb5LoginModuleOptions.put("isInitiator", String.valueOf(initiator));
        krb5LoginModuleOptions.put("principal", principal);
        krb5LoginModuleOptions.put("useKeyTab", "true");
        krb5LoginModuleOptions.put("storeKey", "true");
        krb5LoginModuleOptions.put("doNotPrompt", "true");
        krb5LoginModuleOptions.put("renewTGT", "true");
        krb5LoginModuleOptions.put("refreshKrb5Config", "true");
        krb5LoginModuleOptions.put("useTicketCache", "true");
        String ticketCache = System.getenv("KRB5CCNAME");
        if (ticketCache != null) {
            krb5LoginModuleOptions.put("ticketCache", ticketCache);
        }
        return new Configuration(){

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                return new AppConfigurationEntry[]{new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, krb5LoginModuleOptions)};
            }
        };
    }
}

