/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.remoting.impl.netty;

import org.apache.activemq.artemis.shaded.org.jboss.logging.Logger;
import org.apache.activemq.artemis.utils.Env;

public final class Epoll {
    private static final Logger logger = Logger.getLogger(Epoll.class);
    private static final boolean IS_AVAILABLE_EPOLL = Epoll.isIsAvailableEpoll();

    private static boolean isIsAvailableEpoll() {
        try {
            if (Env.is64BitJvm() && Env.isLinuxOs()) {
                return org.apache.activemq.artemis.shaded.io.netty.channel.epoll.Epoll.isAvailable();
            }
            return false;
        }
        catch (Throwable e) {
            logger.warn((Object)e.getMessage(), e);
            return false;
        }
    }

    private Epoll() {
    }

    public static boolean isAvailable() {
        return IS_AVAILABLE_EPOLL;
    }
}

