/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.security;

import java.io.Serializable;
import javax.json.JsonObject;
import org.apache.activemq.artemis.utils.JsonLoader;

public class Role
implements Serializable {
    private static final long serialVersionUID = 3560097227776448872L;
    private final String name;
    private final boolean send;
    private final boolean consume;
    private final boolean createAddress;
    private final boolean deleteAddress;
    private final boolean createDurableQueue;
    private final boolean deleteDurableQueue;
    private final boolean createNonDurableQueue;
    private final boolean deleteNonDurableQueue;
    private final boolean manage;
    private final boolean browse;

    public JsonObject toJson() {
        return JsonLoader.createObjectBuilder().add("name", this.name).add("send", this.send).add("consume", this.consume).add("createDurableQueue", this.createDurableQueue).add("deleteDurableQueue", this.deleteDurableQueue).add("createNonDurableQueue", this.createNonDurableQueue).add("deleteNonDurableQueue", this.deleteNonDurableQueue).add("manage", this.manage).add("browse", this.browse).add("createAddress", this.createAddress).add("deleteAddress", this.deleteAddress).build();
    }

    @Deprecated
    public Role(String name, boolean send, boolean consume, boolean createDurableQueue, boolean deleteDurableQueue, boolean createNonDurableQueue, boolean deleteNonDurableQueue, boolean manage) {
        this(name, send, consume, createDurableQueue, deleteDurableQueue, createNonDurableQueue, deleteNonDurableQueue, manage, consume);
    }

    public Role(String name, boolean send, boolean consume, boolean createDurableQueue, boolean deleteDurableQueue, boolean createNonDurableQueue, boolean deleteNonDurableQueue, boolean manage, boolean browse) {
        this(name, send, consume, createDurableQueue, deleteDurableQueue, createNonDurableQueue, deleteNonDurableQueue, manage, browse, createDurableQueue || createNonDurableQueue, deleteDurableQueue || deleteNonDurableQueue);
    }

    public Role(String name, boolean send, boolean consume, boolean createDurableQueue, boolean deleteDurableQueue, boolean createNonDurableQueue, boolean deleteNonDurableQueue, boolean manage, boolean browse, boolean createAddress, boolean deleteAddress) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        this.name = name;
        this.send = send;
        this.consume = consume;
        this.createAddress = createAddress;
        this.deleteAddress = deleteAddress;
        this.createDurableQueue = createDurableQueue;
        this.deleteDurableQueue = deleteDurableQueue;
        this.createNonDurableQueue = createNonDurableQueue;
        this.deleteNonDurableQueue = deleteNonDurableQueue;
        this.manage = manage;
        this.browse = browse;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSend() {
        return this.send;
    }

    public boolean isConsume() {
        return this.consume;
    }

    public boolean isCreateAddress() {
        return this.createAddress;
    }

    public boolean isDeleteAddress() {
        return this.deleteAddress;
    }

    public boolean isCreateDurableQueue() {
        return this.createDurableQueue;
    }

    public boolean isDeleteDurableQueue() {
        return this.deleteDurableQueue;
    }

    public boolean isCreateNonDurableQueue() {
        return this.createNonDurableQueue;
    }

    public boolean isDeleteNonDurableQueue() {
        return this.deleteNonDurableQueue;
    }

    public String toString() {
        StringBuffer stringReturn = new StringBuffer("Role {name=" + this.name + "; allows=[");
        if (this.send) {
            stringReturn.append(" send ");
        }
        if (this.consume) {
            stringReturn.append(" consume ");
        }
        if (this.createAddress) {
            stringReturn.append(" createAddress ");
        }
        if (this.deleteAddress) {
            stringReturn.append(" deleteAddress ");
        }
        if (this.createDurableQueue) {
            stringReturn.append(" createDurableQueue ");
        }
        if (this.deleteDurableQueue) {
            stringReturn.append(" deleteDurableQueue ");
        }
        if (this.createNonDurableQueue) {
            stringReturn.append(" createNonDurableQueue ");
        }
        if (this.deleteNonDurableQueue) {
            stringReturn.append(" deleteNonDurableQueue ");
        }
        if (this.manage) {
            stringReturn.append(" manage ");
        }
        if (this.browse) {
            stringReturn.append(" browse ");
        }
        stringReturn.append("]}");
        return stringReturn.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Role role = (Role)o;
        if (this.consume != role.consume) {
            return false;
        }
        if (this.createAddress != role.createAddress) {
            return false;
        }
        if (this.deleteAddress != role.deleteAddress) {
            return false;
        }
        if (this.createDurableQueue != role.createDurableQueue) {
            return false;
        }
        if (this.createNonDurableQueue != role.createNonDurableQueue) {
            return false;
        }
        if (this.deleteDurableQueue != role.deleteDurableQueue) {
            return false;
        }
        if (this.deleteNonDurableQueue != role.deleteNonDurableQueue) {
            return false;
        }
        if (this.send != role.send) {
            return false;
        }
        if (this.manage != role.manage) {
            return false;
        }
        if (this.browse != role.browse) {
            return false;
        }
        return this.name.equals(role.name);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.send ? 1 : 0);
        result = 31 * result + (this.consume ? 1 : 0);
        result = 31 * result + (this.createAddress ? 1 : 0);
        result = 31 * result + (this.deleteAddress ? 1 : 0);
        result = 31 * result + (this.createDurableQueue ? 1 : 0);
        result = 31 * result + (this.deleteDurableQueue ? 1 : 0);
        result = 31 * result + (this.createNonDurableQueue ? 1 : 0);
        result = 31 * result + (this.deleteNonDurableQueue ? 1 : 0);
        result = 31 * result + (this.manage ? 1 : 0);
        result = 31 * result + (this.browse ? 1 : 0);
        return result;
    }

    public boolean isManage() {
        return this.manage;
    }

    public boolean isBrowse() {
        return this.browse;
    }
}

