/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.client;

import java.io.Serializable;
import java.util.UUID;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.jms.client.ActiveMQQueue;
import org.apache.activemq.artemis.jms.client.ActiveMQSession;
import org.apache.activemq.artemis.jms.client.ActiveMQTemporaryQueue;
import org.apache.activemq.artemis.jms.client.ActiveMQTemporaryTopic;
import org.apache.activemq.artemis.jms.client.ActiveMQTopic;
import org.apache.activemq.artemis.jms.referenceable.DestinationObjectFactory;
import org.apache.activemq.artemis.jms.referenceable.SerializableObjectRefAddr;

public class ActiveMQDestination
implements Destination,
Serializable,
Referenceable {
    private static final long serialVersionUID = 5027962425462382883L;
    public static final String QUEUE_QUALIFIED_PREFIX = "queue://";
    public static final String TOPIC_QUALIFIED_PREFIX = "topic://";
    public static final String TEMP_QUEUE_QUALIFED_PREFIX = "temp-queue://";
    public static final String TEMP_TOPIC_QUALIFED_PREFIX = "temp-topic://";
    private static final char SEPARATOR = '.';
    protected final String name;
    private final String address;
    private final SimpleString simpleAddress;
    private final TYPE type;
    private final transient ActiveMQSession session;

    private static String escape(String input) {
        if (input == null) {
            return "";
        }
        return input.replace("\\", "\\\\").replace(".", "\\.");
    }

    public static ActiveMQDestination createDestination(String name, TYPE defaultType) {
        if (name.startsWith(QUEUE_QUALIFIED_PREFIX)) {
            return new ActiveMQQueue(name.substring(QUEUE_QUALIFIED_PREFIX.length()));
        }
        if (name.startsWith(TOPIC_QUALIFIED_PREFIX)) {
            return new ActiveMQTopic(name.substring(TOPIC_QUALIFIED_PREFIX.length()));
        }
        if (name.startsWith(TEMP_QUEUE_QUALIFED_PREFIX)) {
            return new ActiveMQQueue(name.substring(TEMP_QUEUE_QUALIFED_PREFIX.length()), true);
        }
        if (name.startsWith(TEMP_TOPIC_QUALIFED_PREFIX)) {
            return new ActiveMQTopic(name.substring(TEMP_TOPIC_QUALIFED_PREFIX.length()), true);
        }
        switch (defaultType) {
            case QUEUE: {
                return new ActiveMQQueue(name);
            }
            case TOPIC: {
                return new ActiveMQTopic(name);
            }
            case TEMP_QUEUE: {
                return new ActiveMQQueue(name, true);
            }
            case TEMP_TOPIC: {
                return new ActiveMQTopic(name, true);
            }
            case DESTINATION: {
                return new ActiveMQDestination(name, name, TYPE.DESTINATION, null);
            }
        }
        throw new IllegalArgumentException("Invalid default destination type: " + (Object)((Object)defaultType));
    }

    public static Destination fromPrefixedName(String address) {
        if (address.startsWith(QUEUE_QUALIFIED_PREFIX)) {
            String name = address.substring(QUEUE_QUALIFIED_PREFIX.length());
            return ActiveMQDestination.createQueue(name);
        }
        if (address.startsWith(TOPIC_QUALIFIED_PREFIX)) {
            String name = address.substring(TOPIC_QUALIFIED_PREFIX.length());
            return ActiveMQDestination.createTopic(name);
        }
        if (address.startsWith(TEMP_QUEUE_QUALIFED_PREFIX)) {
            String name = address.substring(TEMP_QUEUE_QUALIFED_PREFIX.length());
            return new ActiveMQTemporaryQueue(name, name, null);
        }
        if (address.startsWith(TEMP_TOPIC_QUALIFED_PREFIX)) {
            String name = address.substring(TEMP_TOPIC_QUALIFED_PREFIX.length());
            return new ActiveMQTemporaryTopic(name, name, null);
        }
        return new ActiveMQDestination(address, address, TYPE.DESTINATION, null);
    }

    public static String createQueueNameForSubscription(boolean isDurable, String clientID, String subscriptionName) {
        if (clientID != null) {
            if (isDurable) {
                return ActiveMQDestination.escape(clientID) + '.' + ActiveMQDestination.escape(subscriptionName);
            }
            return "nonDurable." + ActiveMQDestination.escape(clientID) + '.' + ActiveMQDestination.escape(subscriptionName);
        }
        if (isDurable) {
            return ActiveMQDestination.escape(subscriptionName);
        }
        return "nonDurable." + ActiveMQDestination.escape(subscriptionName);
    }

    public static String createQueueNameForSharedSubscription(boolean isDurable, String clientID, String subscriptionName) {
        if (clientID != null) {
            return (isDurable ? "Durable" : "nonDurable") + '.' + ActiveMQDestination.escape(clientID) + '.' + ActiveMQDestination.escape(subscriptionName);
        }
        return (isDurable ? "Durable" : "nonDurable") + '.' + ActiveMQDestination.escape(subscriptionName);
    }

    public static Pair<String, String> decomposeQueueNameForDurableSubscription(String queueName) {
        StringBuffer[] parts = new StringBuffer[2];
        int currentPart = 0;
        parts[0] = new StringBuffer();
        parts[1] = new StringBuffer();
        int pos = 0;
        while (pos < queueName.length()) {
            char ch = queueName.charAt(pos);
            ++pos;
            if (ch == '.') {
                if (++currentPart < parts.length) continue;
                throw new JMSRuntimeException("Invalid message queue name: " + queueName);
            }
            if (ch == '\\') {
                if (pos >= queueName.length()) {
                    throw new JMSRuntimeException("Invalid message queue name: " + queueName);
                }
                ch = queueName.charAt(pos);
                ++pos;
            }
            parts[currentPart].append(ch);
        }
        if (currentPart != 1) {
            parts[1] = parts[0];
            parts[0] = new StringBuffer();
        }
        Pair<String, String> pair = new Pair<String, String>(parts[0].toString(), parts[1].toString());
        return pair;
    }

    public static SimpleString createQueueAddressFromName(String name) {
        return new SimpleString(QUEUE_QUALIFIED_PREFIX + name);
    }

    public static SimpleString createTopicAddressFromName(String name) {
        return new SimpleString(TOPIC_QUALIFIED_PREFIX + name);
    }

    public static ActiveMQQueue createQueue(String name) {
        return new ActiveMQQueue(name);
    }

    public static ActiveMQTopic createTopic(String name) {
        return new ActiveMQTopic(name);
    }

    public static ActiveMQTemporaryQueue createTemporaryQueue(String name, ActiveMQSession session) {
        return new ActiveMQTemporaryQueue(name, name, session);
    }

    public static ActiveMQTemporaryQueue createTemporaryQueue(String name) {
        return ActiveMQDestination.createTemporaryQueue(name, null);
    }

    public static ActiveMQTemporaryQueue createTemporaryQueue(ActiveMQSession session) {
        String name = UUID.randomUUID().toString();
        return ActiveMQDestination.createTemporaryQueue(name, session);
    }

    public static ActiveMQTemporaryTopic createTemporaryTopic(ActiveMQSession session) {
        String name = UUID.randomUUID().toString();
        return ActiveMQDestination.createTemporaryTopic(name, session);
    }

    public static ActiveMQTemporaryTopic createTemporaryTopic(String name, ActiveMQSession session) {
        return new ActiveMQTemporaryTopic(name, name, session);
    }

    public static ActiveMQTemporaryTopic createTemporaryTopic(String name) {
        return ActiveMQDestination.createTemporaryTopic(name, null);
    }

    protected ActiveMQDestination(String address, String name, TYPE type, ActiveMQSession session) {
        this.address = address;
        this.name = name;
        this.simpleAddress = new SimpleString(address);
        this.type = type;
        this.session = session;
    }

    @Override
    public Reference getReference() throws NamingException {
        return new Reference(this.getClass().getCanonicalName(), new SerializableObjectRefAddr("ActiveMQ-DEST", this), DestinationObjectFactory.class.getCanonicalName(), null);
    }

    public void delete() throws JMSException {
        if (this.session != null) {
            if (this.session.getCoreSession().isClosed()) {
                return;
            }
            if (this.isQueue()) {
                this.session.deleteTemporaryQueue(this);
            } else {
                this.session.deleteTemporaryTopic(this);
            }
        }
    }

    public boolean isQueue() {
        return TYPE.isQueue(this.type);
    }

    public String getAddress() {
        return this.address;
    }

    public SimpleString getSimpleAddress() {
        return this.simpleAddress;
    }

    public String getName() {
        return this.name;
    }

    public boolean isTemporary() {
        return TYPE.isTemporary(this.type);
    }

    public TYPE getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ActiveMQDestination)) {
            return false;
        }
        ActiveMQDestination that = (ActiveMQDestination)o;
        return this.address.equals(that.address);
    }

    public int hashCode() {
        return this.address.hashCode();
    }

    public static enum TYPE {
        QUEUE,
        TOPIC,
        TEMP_QUEUE,
        TEMP_TOPIC,
        DESTINATION;


        public byte getType() {
            switch (this) {
                case QUEUE: {
                    return 0;
                }
                case TOPIC: {
                    return 1;
                }
                case TEMP_QUEUE: {
                    return 2;
                }
                case TEMP_TOPIC: {
                    return 3;
                }
                case DESTINATION: {
                    return 4;
                }
            }
            return -1;
        }

        public static TYPE getType(byte type) {
            switch (type) {
                case 0: {
                    return QUEUE;
                }
                case 1: {
                    return TOPIC;
                }
                case 2: {
                    return TEMP_QUEUE;
                }
                case 3: {
                    return TEMP_TOPIC;
                }
                case 4: {
                    return DESTINATION;
                }
            }
            return null;
        }

        public static boolean isQueue(TYPE type) {
            boolean result = false;
            if (type.equals((Object)QUEUE) || type.equals((Object)TEMP_QUEUE)) {
                result = true;
            }
            return result;
        }

        public static boolean isTemporary(TYPE type) {
            boolean result = false;
            if (type.equals((Object)TEMP_TOPIC) || type.equals((Object)TEMP_QUEUE)) {
                result = true;
            }
            return result;
        }
    }
}

