/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.protocols;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentMap;
import org.apache.activemq.artemis.shaded.org.jgroups.Address;
import org.apache.activemq.artemis.shaded.org.jgroups.View;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.ManagedAttribute;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.Property;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.locking.LockNotification;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.Locking;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Owner;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

public class CENTRAL_LOCK
extends Locking
implements LockNotification {
    @Property(description="Number of backups to the coordinator. Server locks get replicated to these nodes as well")
    protected int num_backups = 1;
    @Property(description="By default, a lock owner is address:thread-id. If false, we only use the node's address. See https://issues.jboss.org/browse/JGRP-1886 for details")
    protected boolean use_thread_id_for_lock_owner = true;
    protected Address coord;
    @ManagedAttribute
    protected boolean is_coord;
    protected final List<Address> backups = new ArrayList<Address>();

    public CENTRAL_LOCK() {
        this.addLockListener(this);
    }

    @Override
    protected Owner getOwner() {
        return this.use_thread_id_for_lock_owner ? super.getOwner() : new Owner(this.local_addr, -1L);
    }

    public Address getCoord() {
        return this.coord;
    }

    public boolean isCoord() {
        return this.is_coord;
    }

    @ManagedAttribute
    public String getCoordinator() {
        return this.coord != null ? this.coord.toString() : "n/a";
    }

    public int getNumberOfBackups() {
        return this.num_backups;
    }

    public void setNumberOfBackups(int num_backups) {
        this.num_backups = num_backups;
    }

    @ManagedAttribute
    public String getBackups() {
        return this.backups != null ? this.backups.toString() : null;
    }

    @Override
    protected void sendGrantLockRequest(String lock_name, int lock_id, Owner owner, long timeout, boolean is_trylock) {
        Address dest = this.coord;
        if (dest == null) {
            throw new IllegalStateException("No coordinator available, cannot send GRANT-LOCK request");
        }
        this.sendRequest(dest, Locking.Type.GRANT_LOCK, lock_name, lock_id, owner, timeout, is_trylock);
    }

    @Override
    protected void sendReleaseLockRequest(String lock_name, Owner owner) {
        Address dest = this.coord;
        if (dest == null) {
            throw new IllegalStateException("No coordinator available, cannot send RELEASE-LOCK request");
        }
        this.sendRequest(dest, Locking.Type.RELEASE_LOCK, lock_name, owner, 0L, false);
    }

    protected void sendCreateLockRequest(Address dest, String lock_name, Owner owner) {
        this.sendRequest(dest, Locking.Type.CREATE_LOCK, lock_name, owner, 0L, false);
    }

    protected void sendDeleteLockRequest(Address dest, String lock_name) {
        this.sendRequest(dest, Locking.Type.DELETE_LOCK, lock_name, null, 0L, false);
    }

    @Override
    protected void sendAwaitConditionRequest(String lock_name, Owner owner) {
        this.sendRequest(this.coord, Locking.Type.LOCK_AWAIT, lock_name, owner, 0L, false);
    }

    @Override
    protected void sendSignalConditionRequest(String lock_name, boolean all) {
        this.sendRequest(this.coord, all ? Locking.Type.COND_SIG_ALL : Locking.Type.COND_SIG, lock_name, null, 0L, false);
    }

    @Override
    protected void sendDeleteAwaitConditionRequest(String lock_name, Owner owner) {
        this.sendRequest(this.coord, Locking.Type.DELETE_LOCK_AWAIT, lock_name, owner, 0L, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleView(View view) {
        super.handleView(view);
        Address old_coord = this.coord;
        if (view.size() > 0) {
            this.coord = view.getMembers().iterator().next();
            this.is_coord = this.coord.equals(this.local_addr);
            if (this.log.isDebugEnabled()) {
                this.log.debug("local_addr=" + this.local_addr + ", coord=" + this.coord + ", is_coord=" + this.is_coord);
            }
        }
        if (this.is_coord && this.num_backups > 0) {
            List<Address> new_backups = Util.pickNext(view.getMembers(), this.local_addr, this.num_backups);
            ArrayList<Address> copy_locks_list = null;
            List<Address> list = this.backups;
            synchronized (list) {
                if (!this.backups.equals(new_backups)) {
                    copy_locks_list = new ArrayList<Address>(new_backups);
                    copy_locks_list.removeAll(this.backups);
                    this.backups.clear();
                    this.backups.addAll(new_backups);
                }
            }
            if (copy_locks_list != null && !copy_locks_list.isEmpty()) {
                this.copyLocksTo(copy_locks_list);
            }
        }
        if (old_coord != null && !old_coord.equals(this.coord)) {
            this.client_lock_table.resendPendingLockRequests();
        }
    }

    @Override
    public void lockCreated(String name) {
    }

    @Override
    public void lockDeleted(String name) {
    }

    @Override
    public void locked(String lock_name, Owner owner) {
        if (this.is_coord) {
            this.updateBackups(Locking.Type.CREATE_LOCK, lock_name, owner);
        }
    }

    @Override
    public void unlocked(String lock_name, Owner owner) {
        if (this.is_coord) {
            this.updateBackups(Locking.Type.DELETE_LOCK, lock_name, owner);
        }
    }

    @Override
    public void awaiting(String lock_name, Owner owner) {
        if (this.is_coord) {
            this.updateBackups(Locking.Type.CREATE_AWAITER, lock_name, owner);
        }
    }

    @Override
    public void awaited(String lock_name, Owner owner) {
        if (this.is_coord) {
            this.updateBackups(Locking.Type.DELETE_AWAITER, lock_name, owner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateBackups(Locking.Type type, String lock_name, Owner owner) {
        List<Address> list = this.backups;
        synchronized (list) {
            for (Address backup : this.backups) {
                this.sendRequest(backup, type, lock_name, owner, 0L, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyLocksTo(List<Address> new_joiners) {
        HashMap copy;
        ConcurrentMap concurrentMap = this.server_locks;
        synchronized (concurrentMap) {
            copy = new HashMap(this.server_locks);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("copying locks to " + new_joiners);
        }
        for (Map.Entry entry : copy.entrySet()) {
            for (Address joiner : new_joiners) {
                Locking.ServerLock lock = (Locking.ServerLock)entry.getValue();
                if (lock.current_owner != null) {
                    this.sendCreateLockRequest(joiner, (String)entry.getKey(), ((Locking.ServerLock)entry.getValue()).current_owner);
                }
                Locking.ServerCondition serverCondition = lock.condition;
                synchronized (serverCondition) {
                    Queue<Owner> queue = lock.condition.queue;
                    for (Owner owner : queue) {
                        this.sendAwaitConditionRequest(lock.lock_name, owner);
                    }
                }
            }
        }
    }
}

