/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.shaded.org.jgroups.Address;
import org.apache.activemq.artemis.shaded.org.jgroups.Event;
import org.apache.activemq.artemis.shaded.org.jgroups.Header;
import org.apache.activemq.artemis.shaded.org.jgroups.Message;
import org.apache.activemq.artemis.shaded.org.jgroups.View;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.LocalAddress;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.MBean;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.ManagedAttribute;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.Property;
import org.apache.activemq.artemis.shaded.org.jgroups.conf.PropertyConverters;
import org.apache.activemq.artemis.shaded.org.jgroups.stack.IpAddress;
import org.apache.activemq.artemis.shaded.org.jgroups.stack.Protocol;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

@MBean(description="Double-checks suspicions reports")
public class VERIFY_SUSPECT
extends Protocol
implements Runnable {
    @Property(description="Number of millisecs to wait for a response from a suspected member")
    protected long timeout = 2000L;
    @Property(description="Number of verify heartbeats sent to a suspected member")
    protected int num_msgs = 1;
    @Property(description="Use InetAddress.isReachable() to verify suspected member instead of regular messages")
    protected boolean use_icmp = false;
    @Property(description="Send the I_AM_NOT_DEAD message back as a multicast rather than as multiple unicasts (default is false)")
    protected boolean use_mcast_rsps = false;
    @LocalAddress
    @Property(description="Interface for ICMP pings. Used if use_icmp is true The following special values are also recognized: GLOBAL, SITE_LOCAL, LINK_LOCAL and NON_LOOPBACK", systemProperty={"jgroups.bind_addr"})
    protected InetAddress bind_addr;
    @Property(name="bind_interface", converter=PropertyConverters.BindInterface.class, description="The interface (NIC) which should be used by this transport", dependsUpon="bind_addr")
    protected String bind_interface_str = null;
    protected NetworkInterface intf = null;
    protected Address local_addr = null;
    protected final DelayQueue<Entry> suspects = new DelayQueue();
    protected Thread timer = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedAttribute(description="List of currently suspected members")
    public String getSuspects() {
        DelayQueue<Entry> delayQueue = this.suspects;
        synchronized (delayQueue) {
            return this.suspects.toString();
        }
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 6: {
                View v = (View)evt.getArg();
                this.adjustSuspectedMembers(v.getMembers());
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 9: {
                Address suspected_mbr = (Address)evt.getArg();
                if (suspected_mbr == null) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error(Util.getMessage("SuspectedMemberIsNull"));
                    }
                    return null;
                }
                if (this.local_addr != null && this.local_addr.equals(suspected_mbr)) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("I was suspected; ignoring SUSPECT message");
                    }
                    return null;
                }
                if (!this.use_icmp) {
                    this.verifySuspect(suspected_mbr);
                } else {
                    this.verifySuspectWithICMP(suspected_mbr);
                }
                return null;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                VerifyHeader hdr = (VerifyHeader)msg.getHeader(this.id);
                if (hdr == null) break;
                switch (hdr.type) {
                    case 1: {
                        if (hdr.from == null) {
                            if (this.log.isErrorEnabled()) {
                                this.log.error(Util.getMessage("AREYOUDEADHdrFromIsNull"));
                            }
                        } else {
                            Address target = this.use_mcast_rsps ? null : hdr.from;
                            for (int i = 0; i < this.num_msgs; ++i) {
                                Message rsp = new Message(target).setFlag(Message.Flag.INTERNAL).putHeader(this.id, new VerifyHeader(2, this.local_addr));
                                this.down_prot.down(new Event(1, rsp));
                            }
                        }
                        return null;
                    }
                    case 2: {
                        if (hdr.from == null) {
                            if (this.log.isErrorEnabled()) {
                                this.log.error(Util.getMessage("IAMNOTDEADHdrFromIsNull"));
                            }
                            return null;
                        }
                        this.unsuspect(hdr.from);
                        return null;
                    }
                }
                return null;
            }
            case 56: {
                if (this.bind_addr != null) break;
                Map config = (Map)evt.getArg();
                this.bind_addr = (InetAddress)config.get("bind_addr");
            }
        }
        return this.up_prot.up(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void adjustSuspectedMembers(List<Address> new_mbrship) {
        DelayQueue<Entry> delayQueue = this.suspects;
        synchronized (delayQueue) {
            Iterator<Entry> it = this.suspects.iterator();
            while (it.hasNext()) {
                Entry entry = it.next();
                if (new_mbrship.contains(entry.suspect)) continue;
                it.remove();
            }
        }
    }

    @Override
    public void run() {
        while (!this.suspects.isEmpty() && this.timer != null) {
            try {
                Entry entry = (Entry)this.suspects.poll(this.timeout * 2L, TimeUnit.MILLISECONDS);
                if (entry == null) continue;
                if (this.log.isTraceEnabled()) {
                    this.log.trace(entry.suspect + " is dead (passing up SUSPECT event)");
                }
                this.up_prot.up(new Event(9, entry.suspect));
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    void verifySuspect(Address mbr) {
        if (mbr == null) {
            return;
        }
        this.addSuspect(mbr);
        this.startTimer();
        if (this.log.isTraceEnabled()) {
            this.log.trace("verifying that " + mbr + " is dead");
        }
        for (int i = 0; i < this.num_msgs; ++i) {
            Message msg = new Message(mbr).setFlag(Message.Flag.INTERNAL).putHeader(this.id, new VerifyHeader(1, this.local_addr));
            this.down_prot.down(new Event(1, msg));
        }
    }

    void verifySuspectWithICMP(Address suspected_mbr) {
        block8: {
            InetAddress host;
            InetAddress inetAddress = host = suspected_mbr instanceof IpAddress ? ((IpAddress)suspected_mbr).getIpAddress() : null;
            if (host == null) {
                throw new IllegalArgumentException("suspected_mbr is not of type IpAddress - FD_ICMP only works with these");
            }
            try {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("pinging host " + suspected_mbr + " using interface " + this.intf);
                }
                long start = System.currentTimeMillis();
                boolean rc = host.isReachable(this.intf, 0, (int)this.timeout);
                long stop = System.currentTimeMillis();
                if (rc) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("successfully received response from " + host + " (after " + (stop - start) + "ms)");
                    }
                } else {
                    if (this.log.isTraceEnabled()) {
                        this.log.debug("could not ping " + suspected_mbr + " after " + (stop - start) + "ms; " + "passing up SUSPECT event");
                    }
                    this.removeSuspect(suspected_mbr);
                    this.up_prot.up(new Event(9, suspected_mbr));
                }
            }
            catch (Exception ex) {
                if (!this.log.isErrorEnabled()) break block8;
                this.log.error(Util.getMessage("FailedPinging"), suspected_mbr, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addSuspect(Address suspect) {
        if (suspect == null) {
            return false;
        }
        DelayQueue<Entry> delayQueue = this.suspects;
        synchronized (delayQueue) {
            for (Entry entry : this.suspects) {
                if (!entry.suspect.equals(suspect)) continue;
                return false;
            }
            this.suspects.add(new Entry(suspect, System.currentTimeMillis() + this.timeout));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeSuspect(Address suspect) {
        if (suspect == null) {
            return false;
        }
        boolean retval = false;
        DelayQueue<Entry> delayQueue = this.suspects;
        synchronized (delayQueue) {
            Iterator<Entry> it = this.suspects.iterator();
            while (it.hasNext()) {
                Entry entry = it.next();
                if (!entry.suspect.equals(suspect)) continue;
                it.remove();
                retval = true;
            }
        }
        return retval;
    }

    public void unsuspect(Address mbr) {
        boolean removed;
        boolean bl = removed = mbr != null && this.removeSuspect(mbr);
        if (removed) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("member " + mbr + " was unsuspected");
            }
            this.down_prot.down(new Event(51, mbr));
            this.up_prot.up(new Event(51, mbr));
        }
    }

    protected synchronized void startTimer() {
        if (this.timer == null || !this.timer.isAlive()) {
            this.timer = this.getThreadFactory().newThread(this, "VERIFY_SUSPECT.TimerThread");
            this.timer.setDaemon(true);
            this.timer.start();
        }
    }

    @Override
    public void init() throws Exception {
        super.init();
        if (this.bind_addr != null) {
            this.intf = NetworkInterface.getByInetAddress(this.bind_addr);
        }
    }

    @Override
    public synchronized void stop() {
        if (this.timer != null && this.timer.isAlive()) {
            Thread tmp = this.timer;
            this.timer = null;
            tmp.interrupt();
            Object var1_1 = null;
        }
        this.timer = null;
    }

    public static class VerifyHeader
    extends Header {
        static final short ARE_YOU_DEAD = 1;
        static final short I_AM_NOT_DEAD = 2;
        short type = 1;
        Address from = null;

        public VerifyHeader() {
        }

        VerifyHeader(short type) {
            this.type = type;
        }

        VerifyHeader(short type, Address from) {
            this(type);
            this.from = from;
        }

        @Override
        public String toString() {
            switch (this.type) {
                case 1: {
                    return "[VERIFY_SUSPECT: ARE_YOU_DEAD]";
                }
                case 2: {
                    return "[VERIFY_SUSPECT: I_AM_NOT_DEAD]";
                }
            }
            return "[VERIFY_SUSPECT: unknown type (" + this.type + ")]";
        }

        @Override
        public void writeTo(DataOutput out) throws Exception {
            out.writeShort(this.type);
            Util.writeAddress(this.from, out);
        }

        @Override
        public void readFrom(DataInput in) throws Exception {
            this.type = in.readShort();
            this.from = Util.readAddress(in);
        }

        @Override
        public int size() {
            return 2 + Util.size(this.from);
        }
    }

    protected class Entry
    implements Delayed {
        protected final Address suspect;
        protected final long target_time;

        public Entry(Address suspect, long target_time) {
            this.suspect = suspect;
            this.target_time = target_time;
        }

        @Override
        public int compareTo(Delayed o) {
            long other_delay;
            Entry other = (Entry)o;
            long my_delay = this.getDelay(TimeUnit.MILLISECONDS);
            return my_delay < (other_delay = other.getDelay(TimeUnit.MILLISECONDS)) ? -1 : (my_delay > other_delay ? 1 : 0);
        }

        @Override
        public long getDelay(TimeUnit unit) {
            long delay = this.target_time - System.currentTimeMillis();
            return unit.convert(delay, TimeUnit.MILLISECONDS);
        }

        public String toString() {
            return this.suspect + ": " + this.target_time;
        }
    }
}

