/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.activemq.artemis.core.client.ActiveMQClientLogger;
import org.apache.activemq.artemis.core.client.ActiveMQClientMessageBundle;
import org.apache.activemq.artemis.shaded.org.jboss.logging.Logger;
import org.apache.activemq.artemis.utils.ClassloadingUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XMLUtil {
    private static final Logger logger = Logger.getLogger(XMLUtil.class);

    private XMLUtil() {
    }

    public static Element stringToElement(String s) throws Exception {
        return XMLUtil.readerToElement(new StringReader(s));
    }

    public static Element urlToElement(URL url) throws Exception {
        return XMLUtil.readerToElement(new InputStreamReader(url.openStream()));
    }

    public static String readerToString(Reader r) throws Exception {
        int c;
        StringBuilder buff = new StringBuilder();
        while ((c = r.read()) != -1) {
            buff.append((char)c);
        }
        return buff.toString();
    }

    public static Element readerToElement(Reader r) throws Exception {
        int c;
        StringBuffer buff = new StringBuffer();
        while ((c = r.read()) != -1) {
            buff.append((char)c);
        }
        String s = buff.toString();
        StringReader sreader = new StringReader(s);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder parser = factory.newDocumentBuilder();
        Document doc = parser.parse(new InputSource(sreader));
        return doc.getDocumentElement();
    }

    public static String elementToString(Node n) {
        String name = n.getNodeName();
        short type = n.getNodeType();
        if (4 == type) {
            return "<![CDATA[" + n.getNodeValue() + "]]>";
        }
        if (name.startsWith("#")) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append('<').append(name);
        NamedNodeMap attrs = n.getAttributes();
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                Node attr = attrs.item(i);
                sb.append(' ').append(attr.getNodeName()).append("=\"").append(attr.getNodeValue()).append("\"");
            }
        }
        String textContent = null;
        NodeList children = n.getChildNodes();
        if (children.getLength() == 0) {
            textContent = XMLUtil.getTextContent(n);
            if (textContent != null && !"".equals(textContent)) {
                sb.append(textContent).append("</").append(name).append('>');
            } else {
                sb.append("/>").append('\n');
            }
        } else {
            sb.append('>').append('\n');
            boolean hasValidChildren = false;
            for (int i = 0; i < children.getLength(); ++i) {
                String childToString = XMLUtil.elementToString(children.item(i));
                if ("".equals(childToString)) continue;
                sb.append(childToString);
                hasValidChildren = true;
            }
            if (!hasValidChildren && (textContent = XMLUtil.getTextContent(n)) != null) {
                sb.append(textContent);
            }
            sb.append("</").append(name).append('>');
        }
        return sb.toString();
    }

    public static String getTextContent(Node n) {
        if (n.hasChildNodes()) {
            StringBuffer sb = new StringBuffer();
            NodeList nl = n.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                sb.append(XMLUtil.elementToString(nl.item(i)));
                if (i >= nl.getLength() - 1) continue;
                sb.append('\n');
            }
            String s = sb.toString();
            if (s.length() != 0) {
                return s;
            }
        }
        return n.getTextContent();
    }

    public static void assertEquivalent(Node node, Node node2) {
        if (node == null) {
            throw ActiveMQClientMessageBundle.BUNDLE.firstNodeNull();
        }
        if (node2 == null) {
            throw ActiveMQClientMessageBundle.BUNDLE.secondNodeNull();
        }
        if (!node.getNodeName().equals(node2.getNodeName())) {
            throw ActiveMQClientMessageBundle.BUNDLE.nodeHaveDifferentNames();
        }
        int attrCount = 0;
        NamedNodeMap attrs = node.getAttributes();
        if (attrs != null) {
            attrCount = attrs.getLength();
        }
        int attrCount2 = 0;
        NamedNodeMap attrs2 = node2.getAttributes();
        if (attrs2 != null) {
            attrCount2 = attrs2.getLength();
        }
        if (attrCount != attrCount2) {
            throw ActiveMQClientMessageBundle.BUNDLE.nodeHaveDifferentAttNumber();
        }
        block0: for (int i = 0; i < attrCount; ++i) {
            Node n = attrs.item(i);
            String name = n.getNodeName();
            String value = n.getNodeValue();
            for (int j = 0; j < attrCount; ++j) {
                Node n2 = attrs2.item(j);
                String name2 = n2.getNodeName();
                String value2 = n2.getNodeValue();
                if (name.equals(name2) && value.equals(value2)) continue block0;
            }
            throw ActiveMQClientMessageBundle.BUNDLE.attsDontMatch(name, value);
        }
        boolean hasChildren = node.hasChildNodes();
        if (hasChildren != node2.hasChildNodes()) {
            throw ActiveMQClientMessageBundle.BUNDLE.oneNodeHasChildren();
        }
        if (hasChildren) {
            NodeList nl = node.getChildNodes();
            NodeList nl2 = node2.getChildNodes();
            short[] toFilter = new short[]{3, 2, 8};
            List<Node> nodes = XMLUtil.filter(nl, toFilter);
            List<Node> nodes2 = XMLUtil.filter(nl2, toFilter);
            int length = nodes.size();
            if (length != nodes2.size()) {
                throw ActiveMQClientMessageBundle.BUNDLE.nodeHasDifferentChildNumber();
            }
            for (int i = 0; i < length; ++i) {
                Node n = nodes.get(i);
                Node n2 = nodes2.get(i);
                XMLUtil.assertEquivalent(n, n2);
            }
        }
    }

    public static String stripCDATA(String s) {
        if ((s = s.trim()).startsWith("<![CDATA[")) {
            int i = (s = s.substring(9)).indexOf("]]>");
            if (i == -1) {
                throw new IllegalStateException("argument starts with <![CDATA[ but cannot find pairing ]]>");
            }
            s = s.substring(0, i);
        }
        return s;
    }

    public static String replaceSystemProps(String xml) {
        while (xml.contains("${")) {
            int start = xml.indexOf("${");
            int end = xml.indexOf("}") + 1;
            if (end < 0) break;
            String subString = xml.substring(start, end);
            String prop = subString.substring(2, subString.length() - 1).trim();
            String val = "";
            if (prop.contains(":")) {
                String[] parts = prop.split(":", 2);
                prop = parts[0].trim();
                val = parts[1].trim();
            }
            String sysProp = System.getProperty(prop, val);
            logger.debug("replacing " + subString + " with " + sysProp);
            xml = xml.replace(subString, sysProp);
        }
        return xml;
    }

    public static long parseLong(Node elem) {
        String value = elem.getTextContent().trim();
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw ActiveMQClientMessageBundle.BUNDLE.mustBeLong(elem, value);
        }
    }

    public static int parseInt(Node elem) {
        String value = elem.getTextContent().trim();
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw ActiveMQClientMessageBundle.BUNDLE.mustBeInteger(elem, value);
        }
    }

    public static boolean parseBoolean(Node elem) {
        String value = elem.getTextContent().trim();
        try {
            return Boolean.parseBoolean(value);
        }
        catch (NumberFormatException e) {
            throw ActiveMQClientMessageBundle.BUNDLE.mustBeBoolean(elem, value);
        }
    }

    public static double parseDouble(Node elem) {
        String value = elem.getTextContent().trim();
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            throw ActiveMQClientMessageBundle.BUNDLE.mustBeDouble(elem, value);
        }
    }

    public static void validate(Node node, String schemaFile) throws Exception {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = factory.newSchema(XMLUtil.findResource(schemaFile));
        Validator validator = schema.newValidator();
        try {
            validator.validate(new DOMSource(node));
        }
        catch (SAXException e) {
            ActiveMQClientLogger.LOGGER.errorOnXMLTransformInvalidConf(e);
            throw new IllegalStateException("Invalid configuration", e);
        }
    }

    private static List<Node> filter(NodeList nl, short[] typesToFilter) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        block0: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            short type = n.getNodeType();
            for (short typeToFilter : typesToFilter) {
                if (typeToFilter == type) continue block0;
            }
            nodes.add(n);
        }
        return nodes;
    }

    private static URL findResource(final String resourceName) {
        return AccessController.doPrivileged(new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                return ClassloadingUtil.findResource(resourceName);
            }
        });
    }
}

