/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.actors;

import java.util.concurrent.Executor;
import org.apache.activemq.artemis.api.core.ActiveMQInterruptedException;
import org.apache.activemq.artemis.shaded.org.jboss.logging.Logger;
import org.apache.activemq.artemis.utils.actors.ProcessorBase;

public class OrderedExecutor
extends ProcessorBase<Runnable>
implements Executor {
    private static final Logger logger = Logger.getLogger(OrderedExecutor.class);

    public OrderedExecutor(Executor delegate) {
        super(delegate);
    }

    @Override
    protected final void doTask(Runnable task) {
        try {
            task.run();
        }
        catch (ActiveMQInterruptedException e) {
            logger.debug((Object)"Interrupted Thread", e);
        }
        catch (Throwable t) {
            logger.warn((Object)t.getMessage(), t);
        }
    }

    @Override
    public final void execute(Runnable run) {
        this.task(run);
    }

    public String toString() {
        return "OrderedExecutor(tasks=" + this.tasks + ")";
    }
}

