/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.actors;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.activemq.artemis.utils.actors.OrderedExecutor;

public final class OrderedExecutorFactory
implements ExecutorFactory {
    final Executor parent;

    public static boolean flushExecutor(Executor executor) {
        return OrderedExecutorFactory.flushExecutor(executor, 30L, TimeUnit.SECONDS);
    }

    public static boolean flushExecutor(Executor executor, long timeout, TimeUnit unit) {
        CountDownLatch latch = new CountDownLatch(1);
        executor.execute(latch::countDown);
        try {
            return latch.await(timeout, unit);
        }
        catch (Exception e) {
            return false;
        }
    }

    public OrderedExecutorFactory(Executor parent) {
        this.parent = parent;
    }

    @Override
    public Executor getExecutor() {
        return new OrderedExecutor(this.parent);
    }

    public Executor getParent() {
        return this.parent;
    }
}

